/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.charts;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.jfree.chart.JFreeChart;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.charts.ChartUtils;
import org.opennms.netmgt.config.ChartConfigFactory;
import org.opennms.netmgt.config.charts.BarChart;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class ChartUtilsTest {
    private static final String CHART_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tns:chart-configuration xmlns:tns=\"http://xmlns.opennms.org/xsd/config/charts\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://xmlns.opennms.org/xsd/config/charts ../src/services/org/opennms/netmgt/config/chart-configuration.xsd \">\n\n  <tns:bar-chart name=\"sample-bar-chart\" \n   variation=\"2d\" \n   domain-axis-label=\"Severity\" \n   show-legend=\"true\" \n   plot-orientation=\"vertical\" \n   draw-bar-outline=\"true\" \n   range-axis-label=\"Count\" \n   show-urls=\"false\"\n    show-tool-tips=\"false\">\n      \n    <tns:title font=\"SansSerif\" style=\"\" value=\"Alarms\" pitch=\"12\" />\n    <tns:image-size>\n      <tns:hz-size>\n        <tns:pixels>300</tns:pixels>\n      </tns:hz-size>\n      <tns:vt-size>\n        <tns:pixels>300</tns:pixels>\n      </tns:vt-size>\n    </tns:image-size>\n    <tns:sub-title position=\"top\" horizontal-alignment=\"center\">\n           <tns:title font=\"SansSerif\" style=\"\" value=\"Severity Chart\" pitch=\"10\" />\n    </tns:sub-title>\n    <tns:grid-lines visible=\"true\">\n        <tns:rgb>\n            <tns:red>\n                <tns:rgb-color>255</tns:rgb-color>\n            </tns:red>\n            <tns:green>\n                <tns:rgb-color>255</tns:rgb-color>\n            </tns:green>\n            <tns:blue>\n                <tns:rgb-color>255</tns:rgb-color>\n            </tns:blue>\n        </tns:rgb>\n    </tns:grid-lines>\n    <tns:series-def number=\"1\" series-name=\"Events\" use-labels=\"true\" >\n     <tns:jdbc-data-set db-name=\"opennms\" sql=\"select eventseverity, count(*) from events where eventseverity &gt; 4 group by eventseverity\" />\n      <tns:rgb>\n        <tns:red>\n          <tns:rgb-color>255</tns:rgb-color>\n        </tns:red>\n        <tns:green>\n          <tns:rgb-color>255</tns:rgb-color>\n        </tns:green>\n        <tns:blue>\n          <tns:rgb-color>0</tns:rgb-color>\n        </tns:blue>\n      </tns:rgb>\n    </tns:series-def>\n    <tns:series-def number=\"1\" series-name=\"Alarms\" use-labels=\"true\" >\n     <tns:jdbc-data-set db-name=\"opennms\" sql=\"select severity, count(*) from alarms where severity &gt; 4 group by severity\" />\n      <tns:rgb>\n        <tns:red>\n          <tns:rgb-color>255</tns:rgb-color>\n        </tns:red>\n        <tns:green>\n          <tns:rgb-color>0</tns:rgb-color>\n        </tns:green>\n        <tns:blue>\n          <tns:rgb-color>0</tns:rgb-color>\n        </tns:blue>\n      </tns:rgb>\n    </tns:series-def>\n  </tns:bar-chart>\n</tns:chart-configuration>\n";

    @Before
    public void setUp() throws Exception {
        System.setProperty("java.awt.headless", "true");
        ChartUtilsTest.initalizeChartFactory();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetBarChartConfig() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        Assert.assertNotNull((Object)ChartUtils.getBarChartConfigByName((String)"sample-bar-chart"));
        Assert.assertTrue((ChartUtils.getBarChartConfigByName((String)"sample-bar-chart").getClass() == BarChart.class ? 1 : 0) != 0);
    }

    @Test
    public void testGetBarChart() throws MarshalException, ValidationException, IOException, SQLException {
        JFreeChart barChart = ChartUtils.getBarChart((String)"sample-bar-chart");
        Assert.assertNotNull((Object)barChart);
        Assert.assertEquals((long)2L, (long)barChart.getSubtitleCount());
    }

    @Test
    public void testGetChartWithInvalidChartName() throws MarshalException, ValidationException, IOException, SQLException {
        JFreeChart chart = null;
        try {
            chart = ChartUtils.getBarChart((String)"opennms-rules!");
        }
        catch (IllegalArgumentException e) {
            this.log().debug("testGetChartWithInvalidChartName: Good, this test is working.");
        }
        Assert.assertNull((Object)chart);
    }

    @Test
    public void testGetChartAsFileOutputStream() throws FileNotFoundException, IOException, SQLException, ValidationException, MarshalException {
        FileOutputStream stream = new FileOutputStream("//tmp//sample-bar-chart.png");
        ChartUtils.getBarChart((String)"sample-bar-chart", (OutputStream)stream);
        ((OutputStream)stream).close();
    }

    @Test
    public void testGetChartAsBufferedImage() throws MarshalException, ValidationException, IOException, SQLException {
        BufferedImage bi = ChartUtils.getChartAsBufferedImage((String)"sample-bar-chart");
        Assert.assertEquals((long)300L, (long)bi.getHeight());
    }

    private static void initalizeChartFactory() throws MarshalException, ValidationException, IOException {
        ChartConfigFactory.setInstance((ChartConfigFactory)new ChartConfigFactory());
        ByteArrayInputStream rdr = new ByteArrayInputStream(CHART_CONFIG.getBytes("UTF-8"));
        ChartConfigFactory.parseXml((InputStream)rdr);
        rdr.close();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

