/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.netmgt.config.rws.BaseUrl;
import org.opennms.netmgt.config.rws.RwsConfiguration;
import org.opennms.netmgt.config.rws.StandbyUrl;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.rancid.ConnectionProperties;

public abstract class RWSConfigManager
implements RWSConfig {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private int m_cursor = 0;
    private RwsConfiguration m_config;

    public RWSConfigManager() {
    }

    @Deprecated
    public RWSConfigManager(Reader reader) throws MarshalException, ValidationException, IOException {
        this.reloadXML(reader);
    }

    public RWSConfigManager(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.reloadXML(stream);
    }

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionProperties getBase() {
        this.getReadLock().lock();
        try {
            LogUtils.debugf((Object)this, (String)"Connections used: %s%s", (Object[])new Object[]{this.getBaseUrl().getServer_url(), this.getBaseUrl().getDirectory()});
            LogUtils.debugf((Object)this, (String)"RWS timeout(sec): %d", (Object[])new Object[]{this.getBaseUrl().getTimeout()});
            if (this.getBaseUrl().getUsername() == null) {
                ConnectionProperties connectionProperties = new ConnectionProperties(this.getBaseUrl().getServer_url(), this.getBaseUrl().getDirectory(), this.getBaseUrl().getTimeout());
                return connectionProperties;
            }
            String password = "";
            if (this.getBaseUrl().getPassword() != null) {
                password = this.getBaseUrl().getPassword();
            }
            ConnectionProperties connectionProperties = new ConnectionProperties(this.getBaseUrl().getUsername(), password, this.getBaseUrl().getServer_url(), this.getBaseUrl().getDirectory(), this.getBaseUrl().getTimeout());
            return connectionProperties;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionProperties getNextStandBy() {
        if (!this.hasStandbyUrl()) {
            return null;
        }
        this.getReadLock().lock();
        try {
            StandbyUrl standByUrl = this.getNextStandbyUrl();
            LogUtils.debugf((Object)this, (String)"Connections used: %s%s", (Object[])new Object[]{standByUrl.getServer_url(), standByUrl.getDirectory()});
            LogUtils.debugf((Object)this, (String)"RWS timeout(sec): %d", (Object[])new Object[]{standByUrl.getTimeout()});
            if (standByUrl.getUsername() == null) {
                ConnectionProperties connectionProperties = new ConnectionProperties(standByUrl.getServer_url(), standByUrl.getDirectory(), standByUrl.getTimeout());
                return connectionProperties;
            }
            String password = "";
            if (standByUrl.getPassword() != null) {
                password = standByUrl.getPassword();
            }
            ConnectionProperties connectionProperties = new ConnectionProperties(standByUrl.getUsername(), password, standByUrl.getServer_url(), standByUrl.getDirectory(), standByUrl.getTimeout());
            return connectionProperties;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public ConnectionProperties[] getStandBy() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseUrl getBaseUrl() {
        this.getReadLock().lock();
        try {
            BaseUrl baseUrl = this.m_config.getBaseUrl();
            return baseUrl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StandbyUrl[] getStanbyUrls() {
        this.getReadLock().lock();
        try {
            StandbyUrl[] standbyUrlArray = this.m_config.getStandbyUrl();
            return standbyUrlArray;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StandbyUrl getNextStandbyUrl() {
        this.getReadLock().lock();
        try {
            StandbyUrl standbyUrl = null;
            if (this.hasStandbyUrl()) {
                if (this.m_cursor == this.m_config.getStandbyUrlCount()) {
                    this.m_cursor = 0;
                }
                standbyUrl = this.m_config.getStandbyUrl(this.m_cursor++);
            }
            StandbyUrl standbyUrl2 = standbyUrl;
            return standbyUrl2;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasStandbyUrl() {
        this.getReadLock().lock();
        try {
            boolean bl = this.m_config.getStandbyUrlCount() > 0;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void reloadXML(Reader reader) throws MarshalException, ValidationException, IOException {
        this.getWriteLock().lock();
        try {
            this.m_config = (RwsConfiguration)CastorUtils.unmarshal(RwsConfiguration.class, (Reader)reader);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadXML(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.getWriteLock().lock();
        try {
            this.m_config = (RwsConfiguration)CastorUtils.unmarshal(RwsConfiguration.class, (InputStream)stream);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RwsConfiguration getConfiguration() {
        this.getReadLock().lock();
        try {
            RwsConfiguration rwsConfiguration = this.m_config;
            return rwsConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

