/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.netmgt.config.rws.BaseUrl;
import org.opennms.netmgt.config.rws.RwsConfiguration;
import org.opennms.netmgt.config.rws.StandbyUrl;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.rancid.ConnectionProperties;

public abstract class RWSConfigManager
implements RWSConfig {
    private int cursor = 0;
    private RwsConfiguration m_config;

    public ConnectionProperties getBase() {
        this.log().debug("Connections used : " + this.getBaseUrl().getServer_url() + this.getBaseUrl().getDirectory());
        this.log().debug("RWS timeout(sec): " + this.getBaseUrl().getTimeout());
        if (this.getBaseUrl().getUsername() == null) {
            return new ConnectionProperties(this.getBaseUrl().getServer_url(), this.getBaseUrl().getDirectory(), this.getBaseUrl().getTimeout());
        }
        String password = "";
        if (this.getBaseUrl().getPassword() != null) {
            password = this.getBaseUrl().getPassword();
        }
        return new ConnectionProperties(this.getBaseUrl().getUsername(), password, this.getBaseUrl().getServer_url(), this.getBaseUrl().getDirectory(), this.getBaseUrl().getTimeout());
    }

    public ConnectionProperties getNextStandBy() {
        if (!this.hasStandbyUrl()) {
            return null;
        }
        StandbyUrl standByUrl = this.getNextStandbyUrl();
        this.log().debug("Connections used : " + standByUrl.getServer_url() + standByUrl.getDirectory());
        this.log().debug("RWS timeout(sec): " + standByUrl.getTimeout());
        if (standByUrl.getUsername() == null) {
            return new ConnectionProperties(standByUrl.getServer_url(), standByUrl.getDirectory(), standByUrl.getTimeout());
        }
        String password = "";
        if (standByUrl.getPassword() != null) {
            password = standByUrl.getPassword();
        }
        return new ConnectionProperties(standByUrl.getUsername(), password, standByUrl.getServer_url(), standByUrl.getDirectory(), standByUrl.getTimeout());
    }

    public ConnectionProperties[] getStandBy() {
        return null;
    }

    public synchronized BaseUrl getBaseUrl() {
        BaseUrl url = this.m_config.getBaseUrl();
        return url;
    }

    public synchronized StandbyUrl[] getStanbyUrls() {
        return this.m_config.getStandbyUrl();
    }

    public synchronized StandbyUrl getNextStandbyUrl() {
        StandbyUrl standbyUrl = null;
        if (this.hasStandbyUrl()) {
            if (this.cursor == this.m_config.getStandbyUrlCount()) {
                this.cursor = 0;
            }
            standbyUrl = this.m_config.getStandbyUrl(this.cursor++);
        }
        return standbyUrl;
    }

    public synchronized boolean hasStandbyUrl() {
        return this.m_config.getStandbyUrlCount() > 0;
    }

    @Deprecated
    public RWSConfigManager(Reader reader) throws MarshalException, ValidationException, IOException {
        this.reloadXML(reader);
    }

    public RWSConfigManager(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.reloadXML(stream);
    }

    public RWSConfigManager() {
    }

    @Deprecated
    protected synchronized void reloadXML(Reader reader) throws MarshalException, ValidationException, IOException {
        this.m_config = (RwsConfiguration)CastorUtils.unmarshal(RwsConfiguration.class, (Reader)reader);
    }

    protected synchronized void reloadXML(InputStream stream) throws MarshalException, ValidationException, IOException {
        this.m_config = (RwsConfiguration)CastorUtils.unmarshal(RwsConfiguration.class, (InputStream)stream);
    }

    public synchronized RwsConfiguration getConfiguration() {
        return this.m_config;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

