/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.netmgt.config.RWSConfigManager;

public final class RWSConfigFactory
extends RWSConfigManager {
    private static RWSConfig m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    public RWSConfigFactory(long currentVersion, InputStream stream) throws MarshalException, ValidationException, IOException {
        super(stream);
        this.m_currentVersion = currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RWS_CONFIG_FILE_NAME);
        LogUtils.debugf(RWSConfigFactory.class, (String)"init: config file path: %s", (Object[])new Object[]{cfgFile.getPath()});
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(cfgFile);
            RWSConfigFactory.setInstance(new RWSConfigFactory(cfgFile.lastModified(), stream));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    public static synchronized RWSConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(RWSConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            this.getWriteLock().lock();
            try {
                long timestamp = System.currentTimeMillis();
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RWS_CONFIG_FILE_NAME);
                LogUtils.debugf((Object)this, (String)"saveXml: saving config file at %d: %s", (Object[])new Object[]{timestamp, cfgFile.getPath()});
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
                fileWriter.write(xml);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
                LogUtils.debugf((Object)this, (String)"saveXml: finished saving config file: %s", (Object[])new Object[]{cfgFile.getPath()});
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IOException, MarshalException, ValidationException {
        block5: {
            this.getWriteLock().lock();
            try {
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RWS_CONFIG_FILE_NAME);
                if (cfgFile.lastModified() <= this.m_currentVersion) break block5;
                this.m_currentVersion = cfgFile.lastModified();
                LogUtils.debugf((Object)this, (String)"init: config file path: %s", (Object[])new Object[]{cfgFile.getPath()});
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(cfgFile);
                    this.reloadXML(stream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)stream);
                LogUtils.debugf((Object)this, (String)"init: finished loading config file: %s", (Object[])new Object[]{cfgFile.getPath()});
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }
}

