/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.tcp.PerformanceDataProtos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RrdOutputSocket {
    private final String m_host;
    private final int m_port;
    private final PerformanceDataProtos.PerformanceDataReadings.Builder m_messages;

    public RrdOutputSocket(String host, int port) {
        this.m_host = host;
        this.m_port = port;
        this.m_messages = PerformanceDataProtos.PerformanceDataReadings.newBuilder();
    }

    public void addData(String filename, String owner, String data) {
        Long timestamp = this.parseRrdTimestamp(data);
        List<Double> values = this.parseRrdValues(data);
        this.m_messages.addMessage(PerformanceDataProtos.PerformanceDataReading.newBuilder().setPath(filename).setOwner(owner).setTimestamp(timestamp).addAllValue(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData() {
        Socket socket = null;
        try {
            socket = new Socket(InetAddress.getByName(this.m_host), this.m_port);
            OutputStream out = socket.getOutputStream();
            this.m_messages.build().writeTo(out);
            out.flush();
        }
        catch (Throwable e) {
            ThreadCategory.getInstance(this.getClass()).warn((Object)("Error when trying to open connection to " + this.m_host + ":" + this.m_port + ", dropping " + this.m_messages.getMessageCount() + " performance messages: " + e.getMessage()));
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    ThreadCategory.getInstance(this.getClass()).warn((Object)("IOException when closing TCP performance data socket: " + e.getMessage()));
                }
            }
        }
    }

    private Long parseRrdTimestamp(String data) {
        if (data.startsWith("N:")) {
            return System.currentTimeMillis();
        }
        String timestamp = data.split(":")[0];
        return Long.valueOf(timestamp) * 1000L;
    }

    private List<Double> parseRrdValues(String data) {
        ArrayList<Double> retval = new ArrayList<Double>();
        String[] values = data.split(":");
        for (int i = 1; i < values.length; ++i) {
            if ("U".equals(values[i])) {
                retval.add(Double.NaN);
                continue;
            }
            retval.add(new Double(values[i]));
        }
        return retval;
    }
}

