/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.tcp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.tcp.RrdOutputSocket;
import org.opennms.netmgt.rrd.tcp.TcpRrdStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuingTcpRrdStrategy
implements RrdStrategy<TcpRrdStrategy.RrdDefinition, String> {
    private final BlockingQueue<PerformanceDataReading> m_queue = new LinkedBlockingQueue<PerformanceDataReading>(50000);
    private final ConsumerThread m_consumerThread;
    private final TcpRrdStrategy m_delegate;
    private int m_skippedReadings = 0;

    public QueuingTcpRrdStrategy(TcpRrdStrategy delegate) {
        this.m_delegate = delegate;
        this.m_consumerThread = new ConsumerThread(delegate, this.m_queue);
        this.m_consumerThread.start();
    }

    public void setConfigurationProperties(Properties configurationParameters) {
        this.m_delegate.setConfigurationProperties(configurationParameters);
    }

    public String getDefaultFileExtension() {
        return this.m_delegate.getDefaultFileExtension();
    }

    public TcpRrdStrategy.RrdDefinition createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        return new TcpRrdStrategy.RrdDefinition(directory, rrdName);
    }

    public void createFile(TcpRrdStrategy.RrdDefinition rrdDef) throws Exception {
    }

    public String openFile(String fileName) throws Exception {
        return fileName;
    }

    public void updateFile(String fileName, String owner, String data) throws Exception {
        if (this.m_queue.offer(new PerformanceDataReading(fileName, owner, data), 500L, TimeUnit.MILLISECONDS)) {
            if (this.m_skippedReadings > 0) {
                ThreadCategory.getInstance().warn((Object)("Skipped " + this.m_skippedReadings + " performance data message(s) because of queue overflow"));
                this.m_skippedReadings = 0;
            }
        } else {
            ++this.m_skippedReadings;
        }
    }

    public void closeFile(String rrd) throws Exception {
    }

    public Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException {
        return this.m_delegate.fetchLastValue(rrdFile, ds, interval);
    }

    public Double fetchLastValue(String rrdFile, String ds, String consolidationFunction, int interval) throws NumberFormatException {
        return this.m_delegate.fetchLastValue(rrdFile, ds, consolidationFunction, interval);
    }

    public Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException {
        return this.m_delegate.fetchLastValueInRange(rrdFile, ds, interval, range);
    }

    public InputStream createGraph(String command, File workDir) throws IOException {
        return this.m_delegate.createGraph(command, workDir);
    }

    public RrdGraphDetails createGraphReturnDetails(String command, File workDir) throws IOException {
        return this.m_delegate.createGraphReturnDetails(command, workDir);
    }

    public int getGraphLeftOffset() {
        return this.m_delegate.getGraphLeftOffset();
    }

    public int getGraphRightOffset() {
        return this.m_delegate.getGraphRightOffset();
    }

    public int getGraphTopOffsetWithText() {
        return this.m_delegate.getGraphTopOffsetWithText();
    }

    public String getStats() {
        return this.m_delegate.getStats();
    }

    public void promoteEnqueuedFiles(Collection<String> rrdFiles) {
        this.m_delegate.promoteEnqueuedFiles(rrdFiles);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsumerThread
    extends Thread {
        private final BlockingQueue<PerformanceDataReading> m_myQueue;
        private final TcpRrdStrategy m_strategy;

        public ConsumerThread(TcpRrdStrategy strategy, BlockingQueue<PerformanceDataReading> queue) {
            this.m_strategy = strategy;
            this.m_myQueue = queue;
            this.setName(this.getClass().getSimpleName());
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ArrayList sendMe;
                    if (this.m_myQueue.drainTo(sendMe = new ArrayList()) > 0) {
                        RrdOutputSocket socket = new RrdOutputSocket(this.m_strategy.getHost(), this.m_strategy.getPort());
                        for (PerformanceDataReading reading : sendMe) {
                            socket.addData(reading.getFilename(), reading.getOwner(), reading.getData());
                        }
                        socket.writeData();
                        continue;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)"InterruptedException caught in QueuingTcpRrdStrategy$ConsumerThread, closing thread");
            }
            catch (Throwable e) {
                ThreadCategory.getInstance(this.getClass()).fatal((Object)"Unexpected exception caught in QueuingTcpRrdStrategy$ConsumerThread, closing thread", e);
            }
        }
    }

    private static class PerformanceDataReading {
        private String m_filename;
        private String m_owner;
        private String m_data;

        public PerformanceDataReading(String filename, String owner, String data) {
            this.m_filename = filename;
            this.m_owner = owner;
            this.m_data = data;
        }

        public String getFilename() {
            return this.m_filename;
        }

        public String getOwner() {
            return this.m_owner;
        }

        public String getData() {
            return this.m_data;
        }
    }
}

