/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.model;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.rrd.model.AbstractDS;
import org.opennms.netmgt.rrd.model.AbstractRRA;
import org.opennms.netmgt.rrd.model.LongAdapter;
import org.opennms.netmgt.rrd.model.Row;

public abstract class AbstractRRD {
    private String version;
    private Long step;
    private Long lastupdate;

    protected abstract AbstractRRD createRRD();

    public abstract List<? extends AbstractDS> getDataSources();

    public abstract List<? extends AbstractRRA> getRras();

    public abstract void addRRA(AbstractRRA var1);

    public abstract void addDataSource(AbstractDS var1);

    public abstract AbstractDS getDataSource(int var1);

    @XmlElement(name="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElement(name="step")
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    public Long getStep() {
        return this.step;
    }

    public void setStep(Long step) {
        this.step = step;
    }

    @XmlElement(name="lastupdate")
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    public Long getLastUpdate() {
        return this.lastupdate;
    }

    public void setLastUpdate(Long lastUpdate) {
        this.lastupdate = lastUpdate;
    }

    public Long getStartTimestamp(AbstractRRA rra) {
        if (this.getLastUpdate() == null || this.getStep() == null || rra == null) {
            return null;
        }
        return this.getEndTimestamp(rra) - this.getStep() * rra.getPdpPerRow() * (long)(rra.getRows().size() - 1);
    }

    public Long getEndTimestamp(AbstractRRA rra) {
        if (this.getLastUpdate() == null || this.getStep() == null || rra == null) {
            return null;
        }
        return this.getLastUpdate() - this.getLastUpdate() % (this.getStep() * rra.getPdpPerRow());
    }

    public Long findTimestampByRow(AbstractRRA rra, Row row) {
        int rowNumber = rra.getRows().indexOf(row);
        if (rowNumber < 0) {
            return null;
        }
        return this.getStartTimestamp(rra) + (long)rowNumber * rra.getPdpPerRow() * this.getStep();
    }

    public Row findRowByTimestamp(AbstractRRA rra, Long timestamp) {
        try {
            Long n = (timestamp - this.getStartTimestamp(rra)) / (rra.getPdpPerRow() * this.getStep());
            return rra.getRows().get(n.intValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void merge(AbstractRRD rrdSrc) throws IllegalArgumentException {
        if (!this.hasMergeableRRAs(rrdSrc)) {
            throw new IllegalArgumentException("Invalid RRD format. There are not mergeable RRAs on the source RRD.");
        }
        for (AbstractRRA abstractRRA : rrdSrc.getRras()) {
            AbstractRRA localRra = this.getMergeableRRA(abstractRRA);
            if (localRra == null) continue;
            for (Row row : abstractRRA.getRows()) {
                Long ts;
                Row localRow;
                if (row.isNan() || (localRow = this.findRowByTimestamp(localRra, ts = rrdSrc.findTimestampByRow(abstractRRA, row))) == null) continue;
                localRow.setValues(row.getValues());
            }
        }
    }

    public boolean hasMergeableRRAs(AbstractRRD rrdSrc) {
        for (AbstractRRA abstractRRA : rrdSrc.getRras()) {
            for (AbstractRRA abstractRRA2 : this.getRras()) {
                if (!abstractRRA2.formatMergeable(abstractRRA)) continue;
                return true;
            }
        }
        return false;
    }

    public AbstractRRA getMergeableRRA(AbstractRRA rraSrc) {
        for (AbstractRRA abstractRRA : this.getRras()) {
            if (!abstractRRA.formatMergeable(rraSrc)) continue;
            return abstractRRA;
        }
        return null;
    }

    public void merge(List<? extends AbstractRRD> rrdList) throws IllegalArgumentException {
        if (rrdList.size() != this.getDataSources().size()) {
            String msg = String.format("Cannot merge RRDs because the amount of RRDs (%d) doesn't match the amount of data sources (%d)", rrdList.size(), this.getDataSources().size());
            throw new IllegalArgumentException(msg);
        }
        int validDsFound = 0;
        for (AbstractRRD abstractRRD : rrdList) {
            if (!abstractRRD.getStep().equals(this.getStep())) {
                throw new IllegalArgumentException("Cannot merge RRDs because one of them have a different step value.");
            }
            if (!abstractRRD.getVersion().equals(this.getVersion())) {
                throw new IllegalArgumentException("Cannot merge RRDs because one of them have a different file version.");
            }
            if (abstractRRD.getDataSources().size() > 1) {
                throw new IllegalArgumentException("Cannot merge RRDs because one of them has more than one DS.");
            }
            for (AbstractDS abstractDS : this.getDataSources()) {
                if (!abstractDS.getName().equals(abstractRRD.getDataSource(0).getName())) continue;
                ++validDsFound;
                break;
            }
            if (this.hasMergeableRRAs(abstractRRD)) continue;
            throw new IllegalArgumentException("Cannot merge RRDs because there are no mergeable RRA configuration.");
        }
        if (validDsFound != this.getDataSources().size()) {
            throw new IllegalArgumentException("Cannot merge RRDs because some data sources don't have a RRD file on the list.");
        }
        for (AbstractRRA abstractRRA : this.getRras()) {
            for (Row row : abstractRRA.getRows()) {
                for (int k = 0; k < this.getDataSources().size(); ++k) {
                    Double v;
                    Long ts;
                    Row row2;
                    String ds = this.getDataSources().get(k).getName();
                    AbstractRRA singleMetricRra = null;
                    AbstractRRD singleMetricRrd = null;
                    for (AbstractRRD abstractRRD : rrdList) {
                        if (!abstractRRD.getDataSource(0).getName().equals(ds)) continue;
                        singleMetricRrd = abstractRRD;
                        singleMetricRra = abstractRRD.getMergeableRRA(abstractRRA);
                        break;
                    }
                    if (singleMetricRra == null || (row2 = singleMetricRrd.findRowByTimestamp(singleMetricRra, ts = this.findTimestampByRow(abstractRRA, row))) == null || (v = row2.getValues().get(0)).isNaN()) continue;
                    row.getValues().set(k, v);
                }
            }
        }
    }

    public List<AbstractRRD> split() throws IllegalArgumentException {
        if (this.getDataSources().size() <= 1) {
            throw new IllegalArgumentException("Cannot split an RRD composed by 1 or less data-sources.");
        }
        ArrayList<AbstractRRD> rrds = new ArrayList<AbstractRRD>();
        for (int i = 0; i < this.getDataSources().size(); ++i) {
            AbstractRRD rrd = this.createRRD();
            rrd.addDataSource(this.getDataSource(i));
            for (int j = 0; j < this.getRras().size(); ++j) {
                AbstractRRA currentRra = this.getRras().get(j);
                AbstractRRA rra = currentRra.createSingleRRA(i);
                for (Row currentRow : currentRra.getRows()) {
                    Row row = new Row();
                    row.getValues().add(currentRow.getValues().get(i));
                    rra.getRows().add(row);
                }
                rrd.addRRA(rra);
            }
            rrds.add(rrd);
        }
        return rrds;
    }

    public boolean formatEquals(AbstractRRD rrd) {
        if (this.step != null) {
            if (rrd.step == null) {
                return false;
            }
            if (!this.step.equals(rrd.step)) {
                return false;
            }
        } else if (rrd.step != null) {
            return false;
        }
        if (this.getDataSources() != null) {
            if (rrd.getDataSources() == null) {
                return false;
            }
            if (this.getDataSources().size() != rrd.getDataSources().size()) {
                return false;
            }
        } else if (rrd.getDataSources() != null) {
            return false;
        }
        for (int i = 0; i < this.getDataSources().size(); ++i) {
            if (this.getDataSources().get(i).formatEquals(rrd.getDataSources().get(i))) continue;
            return false;
        }
        return this.hasEqualsRras(rrd);
    }

    public boolean hasEqualsRras(AbstractRRD rrd) {
        if (this.getRras() != null) {
            if (rrd.getRras() == null) {
                return false;
            }
            if (this.getRras().size() != rrd.getRras().size()) {
                return false;
            }
        } else if (rrd.getRras() != null) {
            return false;
        }
        for (int i = 0; i < this.getRras().size(); ++i) {
            if (this.getRras().get(i).formatEquals(rrd.getRras().get(i))) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.getRras().stream().flatMap(rra -> rra.getRows().stream()).forEach(row -> {
            ArrayList<Double> values = new ArrayList<Double>();
            row.getValues().forEach(d -> values.add(Double.NaN));
            row.setValues(values);
        });
    }

    public SortedMap<Long, List<Double>> generateSamples() {
        NavigableSet rras = this.getRras().stream().filter(AbstractRRA::hasAverageAsCF).collect(Collectors.toCollection(() -> new TreeSet((rra1, rra2) -> rra1.getPdpPerRow().compareTo(rra2.getPdpPerRow()))));
        TreeMap<Long, List<Double>> collected = new TreeMap<Long, List<Double>>();
        for (AbstractRRA rra : rras) {
            AbstractRRA higherRra;
            NavigableMap<Long, List<Double>> samples = this.generateSamples(rra);
            AbstractRRA lowerRra = rras.lower(rra);
            if (lowerRra != null) {
                long lowerRraStart = this.getLastUpdate() - lowerRra.getPdpPerRow() * this.getStep() * (long)lowerRra.getRows().size();
                long rraStep = rra.getPdpPerRow() * this.getStep();
                samples = samples.headMap((long)((int)Math.ceil((double)lowerRraStart / (double)rraStep)) * rraStep, false);
            }
            if ((higherRra = rras.higher(rra)) != null) {
                long higherRraStep = higherRra.getPdpPerRow() * this.getStep();
                samples = samples.tailMap((long)((int)Math.ceil((double)((Long)samples.firstKey()).longValue() / (double)higherRraStep)) * higherRraStep, true);
            }
            collected.putAll(samples);
        }
        return collected;
    }

    public NavigableMap<Long, List<Double>> generateSamples(AbstractRRA rra) {
        long step = rra.getPdpPerRow() * this.getStep();
        long start = this.getStartTimestamp(rra);
        long end = this.getEndTimestamp(rra);
        TreeMap<Long, List<Double>> valuesMap = new TreeMap<Long, List<Double>>();
        for (long ts = start; ts <= end; ts += step) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i = 0; i < this.getDataSources().size(); ++i) {
                arrayList.add(Double.NaN);
            }
            valuesMap.put(ts, arrayList);
        }
        ArrayList<Double> lastValues = new ArrayList<Double>();
        for (AbstractDS abstractDS : this.getDataSources()) {
            Double v = abstractDS.getLastDs() == null ? 0.0 : abstractDS.getLastDs();
            lastValues.add(v - v % (double)step);
        }
        for (int i = 0; i < this.getDataSources().size(); ++i) {
            if (!this.getDataSource(i).isCounter()) continue;
            ((List)valuesMap.get(end)).set(i, lastValues.get(i));
        }
        long ts = end - step;
        for (int j = rra.getRows().size() - 1; j >= 0; --j) {
            Row row = rra.getRows().get(j);
            for (int i = 0; i < this.getDataSources().size(); ++i) {
                if (this.getDataSource(i).isCounter()) {
                    if (j <= 0) continue;
                    Double last = (Double)lastValues.get(i);
                    Double current = row.getValue(i).isNaN() ? 0.0 : row.getValue(i);
                    Double value = last - current * (double)step;
                    if (value < 0.0) {
                        value = value + Math.pow(2.0, 64.0);
                    }
                    lastValues.set(i, value);
                    if (row.getValue(i).isNaN()) continue;
                    ((List)valuesMap.get(ts)).set(i, value);
                    continue;
                }
                if (row.getValue(i).isNaN()) continue;
                ((List)valuesMap.get(ts + step)).set(i, row.getValue(i));
            }
            ts -= step;
        }
        return valuesMap;
    }

    protected int getIndex(String dsName) {
        if (this.getDataSources() == null) {
            return -1;
        }
        for (int i = 0; i < this.getDataSources().size(); ++i) {
            if (!this.getDataSources().get(i).getName().equals(dsName)) continue;
            return i;
        }
        return -1;
    }
}

