/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.jrobin;

import java.io.File;
import junit.framework.TestCase;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphInfo;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.util.StringUtils;

public class JRobinRrdStrategyTest
extends TestCase {
    private JRobinRrdStrategy m_strategy;

    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        this.m_strategy = new JRobinRrdStrategy();
        this.m_strategy.initialize();
    }

    public void testInitilize() {
    }

    public void testCommandWithoutDrawing() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        String command = "--start=" + start + " --end=" + end;
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new RrdException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            this.m_strategy.createGraph(command, new File(""));
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
            String problemText = "no graph was produced";
            JRobinRrdStrategyTest.assertTrue((String)("cause message should contain '" + problemText + "'"), (boolean)t.getMessage().contains(problemText));
            String suggestionText = "Does the command have any drawing commands";
            JRobinRrdStrategyTest.assertTrue((String)("cause message should contain '" + suggestionText + "'"), (boolean)t.getMessage().contains(suggestionText));
        }
        ta.verifyAnticipated();
    }

    public void testCommentWithNewlines() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        String[] command = new String[]{"--start=" + start, "--end=" + end, "COMMENT:foo\\n"};
        String[] command2 = new String[]{"--start=" + start, "--end=" + end, "COMMENT:foo\\n", "COMMENT:foo2\\n"};
        RrdGraphDef graphDef = this.m_strategy.createGraphDef(new File(""), command);
        RrdGraph graph = new RrdGraph(graphDef);
        JRobinRrdStrategyTest.assertNotNull((String)"graph object", (Object)graph);
        int firstHeight = graph.getRrdGraphInfo().getHeight();
        RrdGraphDef graphDef2 = this.m_strategy.createGraphDef(new File(""), command2);
        RrdGraph graph2 = new RrdGraph(graphDef2);
        JRobinRrdStrategyTest.assertNotNull((String)"second graph object", (Object)graph2);
        int secondHeight = graph2.getRrdGraphInfo().getHeight();
        JRobinRrdStrategyTest.assertFalse((String)("first graph height " + firstHeight + " and second graph height " + secondHeight + " should not be equal... there should be another newline in the second one making it taller"), (firstHeight == secondHeight ? 1 : 0) != 0);
    }

    public void testGprintWithNewlines() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        String[] command = new String[]{"--start=" + start, "--end=" + end, "CDEF:a=1", "GPRINT:a:AVERAGE:\"%8.2lf\\n\""};
        String[] command2 = new String[]{"--start=" + start, "--end=" + end, "CDEF:a=1", "CDEF:b=1", "GPRINT:a:AVERAGE:\"%8.2lf\\n\"", "GPRINT:b:AVERAGE:\"%8.2lf\\n\""};
        RrdGraphDef graphDef = this.m_strategy.createGraphDef(new File(""), command);
        RrdGraph graph = new RrdGraph(graphDef);
        JRobinRrdStrategyTest.assertNotNull((String)"graph object", (Object)graph);
        int firstHeight = graph.getRrdGraphInfo().getHeight();
        RrdGraphDef graphDef2 = this.m_strategy.createGraphDef(new File(""), command2);
        RrdGraph graph2 = new RrdGraph(graphDef2);
        JRobinRrdStrategyTest.assertNotNull((String)"second graph object", (Object)graph2);
        int secondHeight = graph2.getRrdGraphInfo().getHeight();
        JRobinRrdStrategyTest.assertFalse((String)("first graph height " + firstHeight + " and second graph height " + secondHeight + " should not be equal... there should be another line with a newline in the second one making it taller"), (firstHeight == secondHeight ? 1 : 0) != 0);
    }

    public void testPrint() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        String[] command = new String[]{"--start=" + start, "--end=" + end, "CDEF:something=1", "PRINT:something:AVERAGE:\"%le\""};
        RrdGraphDef graphDef = this.m_strategy.createGraphDef(new File(""), command);
        RrdGraph graph = new RrdGraph(graphDef);
        JRobinRrdStrategyTest.assertNotNull((String)"graph object", (Object)graph);
        RrdGraphInfo info = graph.getRrdGraphInfo();
        JRobinRrdStrategyTest.assertNotNull((String)"graph info object", (Object)info);
        String[] printLines = info.getPrintLines();
        JRobinRrdStrategyTest.assertNotNull((String)"graph printLines", (Object)printLines);
        JRobinRrdStrategyTest.assertEquals((String)"graph printLines size", (int)1, (int)printLines.length);
        JRobinRrdStrategyTest.assertEquals((String)"graph printLines item 0", (String)"1.000000e+00", (String)printLines[0]);
        double d = Double.parseDouble(printLines[0]);
        JRobinRrdStrategyTest.assertEquals((String)"graph printLines item 0 as a double", (Object)1.0, (Object)d);
    }

    public void testPrintThroughInterface() throws Exception {
        long end = System.currentTimeMillis();
        long start = end - 86400000L;
        Object[] command = new String[]{"--start=" + start, "--end=" + end, "CDEF:something=1", "PRINT:something:AVERAGE:\"%le\""};
        RrdGraphDetails graphDetails = this.m_strategy.createGraphReturnDetails(StringUtils.arrayToDelimitedString((Object[])command, (String)" "), new File(""));
        JRobinRrdStrategyTest.assertNotNull((String)"graph details object", (Object)graphDetails);
        String[] printLines = graphDetails.getPrintLines();
        JRobinRrdStrategyTest.assertNotNull((String)"graph printLines", (Object)printLines);
        JRobinRrdStrategyTest.assertEquals((String)"graph printLines size", (int)1, (int)printLines.length);
        JRobinRrdStrategyTest.assertEquals((String)"graph printLines item 0", (String)"1.000000e+00", (String)printLines[0]);
        double d = Double.parseDouble(printLines[0]);
        JRobinRrdStrategyTest.assertEquals((String)"graph printLines item 0 as a double", (Object)1.0, (Object)d);
    }
}

