/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.jrobin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jrobin.graph.RrdGraph;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdGraphDetails;

public class JRobinRrdGraphDetails
implements RrdGraphDetails {
    private RrdGraph m_rrdGraph;
    private String m_graphCommand;

    public JRobinRrdGraphDetails(RrdGraph rrdGraph, String graphCommand) {
        this.m_rrdGraph = rrdGraph;
        this.m_graphCommand = graphCommand;
    }

    public RrdGraph getRrdGraph() {
        return this.m_rrdGraph;
    }

    public String getGraphCommand() {
        return this.m_graphCommand;
    }

    public InputStream getInputStream() throws RrdException {
        this.assertGraphProduced();
        return new ByteArrayInputStream(this.m_rrdGraph.getRrdGraphInfo().getBytes());
    }

    public String[] getPrintLines() {
        return this.m_rrdGraph.getRrdGraphInfo().getPrintLines();
    }

    public int getHeight() throws RrdException {
        this.assertGraphProduced();
        return this.m_rrdGraph.getRrdGraphInfo().getHeight();
    }

    public int getWidth() throws RrdException {
        this.assertGraphProduced();
        return this.m_rrdGraph.getRrdGraphInfo().getWidth();
    }

    private void assertGraphProduced() throws RrdException {
        if (this.m_rrdGraph.getRrdGraphInfo().getBytes() == null) {
            String message = "no graph was produced by JRobin for command '" + this.getGraphCommand() + "'.  Does the command have any drawing commands (e.g.: LINE1, LINE2, LINE3, AREA, STACK, GPRINT)?";
            this.log().error(message);
            throw new RrdException(message);
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

