/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;

public class RrdConfig {
    private static Properties m_properties = null;

    private static synchronized Properties getProperties() throws IOException {
        if (m_properties == null) {
            File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RRD_CONFIG_FILE_NAME);
            RrdConfig.loadProperties(new FileInputStream(configFile));
        }
        return m_properties;
    }

    public static synchronized void loadProperties(InputStream in) throws IOException {
        Properties properties = new Properties(System.getProperties());
        properties.load(in);
        in.close();
        m_properties = properties;
    }

    public static synchronized void setProperties(Properties properties) {
        m_properties = properties;
    }

    public static String getProperty(String name, String defaultVal) {
        Logger log = ThreadCategory.getInstance(RrdConfig.class);
        try {
            return RrdConfig.getProperties().getProperty(name, defaultVal);
        }
        catch (IOException e) {
            log.error((Object)("Unable to read property " + name + " returning defaultValue: " + defaultVal), (Throwable)e);
            return defaultVal;
        }
    }

    public static boolean getProperty(String name, boolean defaultVal) {
        return "true".equalsIgnoreCase(RrdConfig.getProperty(name, defaultVal ? "true" : "false"));
    }

    public static int getProperty(String name, int defaultVal) {
        String val = RrdConfig.getProperty(name, null);
        if (val != null) {
            try {
                return Integer.decode(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public static long getProperty(String name, long defaultVal) {
        String val = RrdConfig.getProperty(name, null);
        if (val != null) {
            try {
                return Long.decode(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultVal;
    }
}

