/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.opennms.netmgt.rrd.RrdConfig;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuingRrdStrategy
implements RrdStrategy,
Runnable {
    RrdStrategy m_delegate;
    static final int UPDATE = 0;
    static final int CREATE = 1;
    static final int WRITE_THREADS = RrdConfig.getProperty("org.opennms.rrd.queuing.writethreads", 2);
    private static final boolean QUEUE_CREATES = RrdConfig.getProperty("org.opennms.rrd.queuing.queuecreates", false);
    private static final boolean PRIORITIZE_SIGS = RrdConfig.getProperty("org.opennms.rrd.queuing.prioritizeSignificantUpdates", false);
    private static final long INSIG_HIGH_WATER_MARK = RrdConfig.getProperty("org.opennms.rrd.queuing.inSigHighWaterMark", 0L);
    private static final long SIG_HIGH_WATER_MARK = RrdConfig.getProperty("org.opennms.rrd.queuing.sigHighWaterMark", 0L);
    private static final long QUEUE_HIGH_WATER_MARK = RrdConfig.getProperty("org.opennms.rrd.queuing.queueHighWaterMark", 0L);
    private static final long MODULUS = RrdConfig.getProperty("org.opennms.rrd.queuing.modulus", 10000L);
    private static final String LOG4J_CATEGORY = RrdConfig.getProperty("org.opennms.rrd.queuing.category", "OpenNMS.Queued");
    private static final long MAX_INSIG_UPDATE_SECONDS = RrdConfig.getProperty("org.opennms.rrd.queuing.maxInsigUpdateSeconds", 0L);
    private static final long WRITE_THREAD_SLEEP_TIME = RrdConfig.getProperty("org.opennms.rrd.queuing.writethread.sleepTime", 50L);
    private static final long WRITE_THREAD_EXIT_DELAY = RrdConfig.getProperty("org.opennms.rrd.queuing.writethread.exitDelay", 60000L);
    LinkedList<String> filesWithSignificantWork = new LinkedList();
    LinkedList<String> filesWithInsignificantWork = new LinkedList();
    Map<String, LinkedList<Operation>> pendingFileOperations = new HashMap<String, LinkedList<Operation>>();
    Map<Thread, String> fileAssignments = new HashMap<Thread, String>();
    Set<String> reservedFiles = new HashSet<String>();
    private long m_totalOperationsPending = 0L;
    private long m_enqueuedOperations = 0L;
    private long m_dequeuedOperations = 0L;
    private long m_significantOpsEnqueued = 0L;
    private long m_significantOpsDequeued = 0L;
    private long m_significantOpsCompleted = 0L;
    private long m_dequeuedItems = 0L;
    private long m_createsCompleted = 0L;
    private long m_updatesCompleted = 0L;
    private long m_errors = 0L;
    int threadsRunning = 0;
    private long m_startTime = 0L;
    private long m_promotionCount = 0L;
    long lastLap = System.currentTimeMillis();
    long lastStatsTime = 0L;
    long lastEnqueued = 0L;
    long lastDequeued = 0L;
    long lastSignificantEnqueued = 0L;
    long lastSignificantDequeued = 0L;
    long lastSignificantCompleted = 0L;
    long lastDequeuedItems = 0L;
    long lastOpsPending = 0L;

    public Operation makeCreateOperation(String fileName, Object rrdDef) {
        return new CreateOperation(fileName, rrdDef);
    }

    public Operation makeUpdateOperation(String fileName, String owner, String update) {
        try {
            int colon = update.indexOf(58);
            if (colon >= 0 && Double.parseDouble(update.substring(colon + 1)) == 0.0) {
                long initialTimeStamp = Long.parseLong(update.substring(0, colon));
                if (initialTimeStamp == 0L) {
                    this.log().debug((Object)("ZERO ERROR: created a zero update with ts=0 for file: " + fileName + " data: " + update));
                }
                return new ZeroUpdateOperation(fileName, initialTimeStamp);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return new UpdateOperation(fileName, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperation(Operation op) {
        QueuingRrdStrategy queuingRrdStrategy = this;
        synchronized (queuingRrdStrategy) {
            if (this.queueIsFull()) {
                this.log().error((Object)("RRD Data Queue is Full!! Discarding operation for file " + op.getFileName()));
                return;
            }
            if (op.isSignificant() && this.sigQueueIsFull()) {
                this.log().error((Object)("RRD Data Significant Queue is Full!! Discarding operation for file " + op.getFileName()));
                return;
            }
            if (!op.isSignificant() && this.inSigQueueIsFull()) {
                this.log().error((Object)("RRD Insignificant Data Queue is Full!! Discarding operation for file " + op.getFileName()));
                return;
            }
            this.storeAssignment(op);
            this.setTotalOperationsPending(this.getTotalOperationsPending() + 1L);
            this.setEnqueuedOperations(this.getEnqueuedOperations() + 1L);
            if (op.isSignificant()) {
                this.setSignificantOpsEnqueued(this.getSignificantOpsEnqueued() + 1L);
            }
            this.notifyAll();
            this.ensureThreadsStarted();
        }
    }

    private Category log() {
        return Logger.getLogger((String)LOG4J_CATEGORY);
    }

    private boolean queueIsFull() {
        if (QUEUE_HIGH_WATER_MARK <= 0L) {
            return false;
        }
        return this.getTotalOperationsPending() >= QUEUE_HIGH_WATER_MARK;
    }

    private boolean sigQueueIsFull() {
        if (SIG_HIGH_WATER_MARK <= 0L) {
            return false;
        }
        return this.getTotalOperationsPending() >= SIG_HIGH_WATER_MARK;
    }

    private boolean inSigQueueIsFull() {
        if (INSIG_HIGH_WATER_MARK <= 0L) {
            return false;
        }
        return this.getTotalOperationsPending() >= INSIG_HIGH_WATER_MARK;
    }

    public synchronized void ensureThreadsStarted() {
        if (this.threadsRunning < WRITE_THREADS) {
            ++this.threadsRunning;
            Thread t = new Thread(this);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Operation> getNext() {
        LinkedList<Operation> ops = null;
        QueuingRrdStrategy queuingRrdStrategy = this;
        synchronized (queuingRrdStrategy) {
            String newAssignment;
            this.completeAssignment();
            while ((newAssignment = this.selectNewAssignment()) == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.getStartTime() == 0L) {
                this.setStartTime(System.currentTimeMillis());
            }
            if ((ops = this.takeAssignment(newAssignment)) != null) {
                for (Operation op : ops) {
                    this.setTotalOperationsPending(this.getTotalOperationsPending() - (long)op.getCount());
                    this.setDequeuedOperations(this.getDequeuedOperations() + (long)op.getCount());
                    if (!op.isSignificant()) continue;
                    this.setSignificantOpsDequeued(this.getSignificantOpsDequeued() + (long)op.getCount());
                }
                this.setDequeuedItems(this.getDequeuedItems() + 1L);
            }
        }
        return ops;
    }

    private synchronized void storeAssignment(Operation op) {
        LinkedList<Operation> pendingOperations = this.pendingFileOperations.get(op.getFileName());
        if (pendingOperations == null) {
            pendingOperations = new LinkedList();
            this.pendingFileOperations.put(op.getFileName(), pendingOperations);
            if (!PRIORITIZE_SIGS || op.isSignificant()) {
                this.filesWithSignificantWork.addLast(op.getFileName());
            } else {
                this.filesWithInsignificantWork.addLast(op.getFileName());
            }
        } else if (PRIORITIZE_SIGS && op.isSignificant() && this.hasOnlyInsignificant(pendingOperations)) {
            this.filesWithSignificantWork.addLast(op.getFileName());
        }
        this.promoteAgedFiles();
        op.addToPendingList(pendingOperations);
    }

    private synchronized void promoteAgedFiles() {
        double millisPerPromotion;
        long nextPromotionMillis;
        if (!PRIORITIZE_SIGS) {
            return;
        }
        if (MAX_INSIG_UPDATE_SECONDS == 0L || this.filesWithInsignificantWork.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        long elapsedMillis = Math.max(now - this.getStartTime(), 1L);
        if (elapsedMillis > (nextPromotionMillis = (long)((millisPerPromotion = (double)MAX_INSIG_UPDATE_SECONDS * 1000.0 / (double)this.filesWithInsignificantWork.size()) * (double)this.getPromotionCount()))) {
            String file = this.filesWithInsignificantWork.removeFirst();
            this.filesWithSignificantWork.addFirst(file);
            this.setPromotionCount(this.getPromotionCount() + 1L);
        }
    }

    @Override
    public synchronized void promoteEnqueuedFiles(Collection<String> rrdFiles) {
        this.filesWithSignificantWork.addAll(0, rrdFiles);
    }

    private boolean hasOnlyInsignificant(LinkedList<Operation> pendingOps) {
        for (Operation op : pendingOps) {
            if (!op.isSignificant()) continue;
            return false;
        }
        return true;
    }

    private LinkedList<Operation> takeAssignment(String newAssignment) {
        this.fileAssignments.put(Thread.currentThread(), newAssignment);
        this.reservedFiles.add(newAssignment);
        return this.pendingFileOperations.remove(newAssignment);
    }

    private String selectNewAssignment() {
        String fn;
        Iterator it = this.filesWithSignificantWork.iterator();
        while (it.hasNext()) {
            fn = (String)it.next();
            if (this.reservedFiles.contains(fn)) continue;
            it.remove();
            return fn;
        }
        it = this.filesWithInsignificantWork.iterator();
        while (it.hasNext()) {
            fn = (String)it.next();
            if (this.reservedFiles.contains(fn)) continue;
            it.remove();
            return fn;
        }
        return null;
    }

    private synchronized void completeAssignment() {
        String previousAssignment = this.fileAssignments.remove(Thread.currentThread());
        if (previousAssignment != null) {
            this.reservedFiles.remove(previousAssignment);
        }
    }

    public QueuingRrdStrategy(RrdStrategy delegate) {
        this.m_delegate = delegate;
    }

    public RrdStrategy getDelegate() {
        return this.m_delegate;
    }

    @Override
    public void closeFile(Object rrd) throws Exception {
    }

    public Object createDefinition(String creator, String directory, String dsName, int step, String dsType, int dsHeartbeat, String dsMin, String dsMax, List<String> rraList) throws Exception {
        return this.createDefinition(creator, directory, dsName, step, Collections.singletonList(new RrdDataSource(dsName, dsType, dsHeartbeat, dsMin, dsMax)), rraList);
    }

    @Override
    public Object createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        String fileName = directory + File.separator + rrdName + RrdUtils.getExtension();
        Object def = this.m_delegate.createDefinition(creator, directory, rrdName, step, dataSources, rraList);
        return this.makeCreateOperation(fileName, def);
    }

    @Override
    public void createFile(Object op) throws Exception {
        if (QUEUE_CREATES) {
            this.addOperation((Operation)op);
        } else {
            this.m_delegate.createFile(((Operation)op).getData());
        }
    }

    @Override
    public void initialize() throws Exception {
        this.m_delegate.initialize();
    }

    @Override
    public void graphicsInitialize() throws Exception {
        this.m_delegate.graphicsInitialize();
    }

    @Override
    public Object openFile(String fileName) throws Exception {
        return fileName;
    }

    @Override
    public void updateFile(Object rrdFile, String owner, String data) throws Exception {
        this.addOperation(this.makeUpdateOperation((String)rrdFile, owner, data));
    }

    @Override
    public Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException, RrdException {
        return this.m_delegate.fetchLastValue(rrdFile, ds, interval);
    }

    @Override
    public Double fetchLastValue(String rrdFile, String ds, String consolidationFunction, int interval) throws NumberFormatException, RrdException {
        return this.m_delegate.fetchLastValue(rrdFile, ds, consolidationFunction, interval);
    }

    @Override
    public Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException, RrdException {
        return this.m_delegate.fetchLastValueInRange(rrdFile, ds, interval, range);
    }

    @Override
    public InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        return this.m_delegate.createGraph(command, workDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long waitStart = -1L;
            long delayed = 0L;
            while (delayed < WRITE_THREAD_EXIT_DELAY) {
                if (this.getTotalOperationsPending() > 0L) {
                    delayed = 0L;
                    waitStart = -1L;
                    this.processPendingOperations();
                    continue;
                }
                if (waitStart < 0L) {
                    waitStart = System.currentTimeMillis();
                }
                try {
                    Thread.sleep(WRITE_THREAD_SLEEP_TIME);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                delayed = now - waitStart;
            }
        }
        finally {
            QueuingRrdStrategy queuingRrdStrategy = this;
            synchronized (queuingRrdStrategy) {
                --this.threadsRunning;
                this.completeAssignment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingOperations() {
        LinkedList<Operation> ops;
        String fileName;
        Object rrd;
        block7: {
            rrd = null;
            fileName = null;
            ops = this.getNext();
            if (ops != null) break block7;
            this.processClose(rrd);
            return;
        }
        try {
            for (Operation op : ops) {
                if (!op.isSignificant()) continue;
                this.setSignificantOpsCompleted(this.getSignificantOpsCompleted() + 1L);
            }
            for (Operation op : ops) {
                fileName = op.getFileName();
                rrd = op.process(rrd);
            }
            this.processClose(rrd);
        }
        catch (Exception e) {
            try {
                this.setErrors(this.getErrors() + 1L);
                this.logLapTime("Error updating file " + fileName + ": " + e.getMessage());
                this.log().debug((Object)("Error upading file " + fileName + ": " + e.getMessage()), (Throwable)e);
                this.processClose(rrd);
            }
            catch (Throwable throwable) {
                this.processClose(rrd);
                throw throwable;
            }
        }
    }

    private void processClose(Object rrd) {
        if (rrd != null) {
            try {
                this.m_delegate.closeFile(rrd);
            }
            catch (Throwable t) {
                this.logLapTime("Throwable received while closing file", t);
            }
        }
    }

    @Override
    public String getStats() {
        long now = System.currentTimeMillis();
        long currentElapsedMillis = Math.max(now - this.lastStatsTime, 1L);
        long totalElapsedMillis = Math.max(now - this.getStartTime(), 1L);
        long currentEnqueuedOps = this.getEnqueuedOperations() - this.lastEnqueued;
        long currentDequeuedOps = this.getDequeuedOperations() - this.lastDequeued;
        long currentDequeuedItems = this.getDequeuedItems() - this.lastDequeuedItems;
        long currentSigOpsEnqueued = this.getSignificantOpsEnqueued() - this.lastSignificantEnqueued;
        long currentSigOpsDequeued = this.getSignificantOpsDequeued() - this.lastSignificantDequeued;
        long currentEnqueueRate = (long)((double)currentEnqueuedOps * 1000.0 / (double)currentElapsedMillis);
        long currentSigEnqueueRate = (long)((double)currentSigOpsEnqueued * 1000.0 / (double)currentElapsedMillis);
        long currentInsigEnqueueRate = (long)((double)(currentEnqueuedOps - currentSigOpsEnqueued) * 1000.0 / (double)currentElapsedMillis);
        long overallEnqueueRate = (long)((double)this.getEnqueuedOperations() * 1000.0 / (double)totalElapsedMillis);
        long overallSigEnqueueRate = (long)((double)this.getSignificantOpsEnqueued() * 1000.0 / (double)totalElapsedMillis);
        long overallInsigEnqueueRate = (long)((double)(this.getEnqueuedOperations() - this.getSignificantOpsEnqueued()) * 1000.0 / (double)totalElapsedMillis);
        long currentDequeueRate = (long)((double)currentDequeuedOps * 1000.0 / (double)currentElapsedMillis);
        long currentSigDequeueRate = (long)((double)currentSigOpsDequeued * 1000.0 / (double)currentElapsedMillis);
        long currentInsigDequeueRate = (long)((double)(currentDequeuedOps - currentSigOpsDequeued) * 1000.0 / (double)currentElapsedMillis);
        long overallDequeueRate = (long)((double)this.getDequeuedOperations() * 1000.0 / (double)totalElapsedMillis);
        long overallSigDequeueRate = (long)((double)this.getSignificantOpsDequeued() * 1000.0 / (double)totalElapsedMillis);
        long overallInsigDequeueRate = (long)((double)(this.getDequeuedOperations() - this.getSignificantOpsDequeued()) * 1000.0 / (double)totalElapsedMillis);
        long currentItemDequeueRate = (long)((double)currentDequeuedItems * 1000.0 / (double)currentElapsedMillis);
        long overallItemDequeueRate = (long)((double)this.getDequeuedItems() * 1000.0 / (double)totalElapsedMillis);
        String stats = "\nQS:\ttotalOperationsPending=" + this.getTotalOperationsPending() + ", significantOpsPending=" + (this.getSignificantOpsEnqueued() - this.getSignificantOpsCompleted()) + ", filesWithSignificantWork=" + this.filesWithSignificantWork.size() + ", filesWithInsignificantWork=" + this.filesWithInsignificantWork.size() + "\nQS:\t" + ", createsCompleted=" + this.getCreatesCompleted() + ", updatesCompleted=" + this.getUpdatesCompleted() + ", errors=" + this.getErrors() + ", promotionRate=" + (double)this.getPromotionCount() * 1000.0 / (double)totalElapsedMillis + ", promotionCount=" + this.getPromotionCount() + "\nQS:\t" + ", currentEnqueueRates=(" + currentSigEnqueueRate + "/" + currentInsigEnqueueRate + "/" + currentEnqueueRate + ")" + ", currentDequeueRate=(" + currentSigDequeueRate + "/" + currentInsigDequeueRate + "/" + currentDequeueRate + ")" + ", currentItemDequeRate=" + currentItemDequeueRate + ", currentOpsPerUpdate=" + (double)currentDequeuedOps / Math.max((double)currentDequeuedItems, 1.0) + ", currentPrcntSignificant=" + (double)currentSigOpsEnqueued * 100.0 / Math.max((double)currentEnqueuedOps, 1.0) + "%" + ", elapsedTime=" + (currentElapsedMillis + 500L) / 1000L + "\nQS:\t" + ", overallEnqueueRate=(" + overallSigEnqueueRate + "/" + overallInsigEnqueueRate + "/" + overallEnqueueRate + ")" + ", overallDequeueRate=(" + overallSigDequeueRate + "/" + overallInsigDequeueRate + "/" + overallDequeueRate + ")" + ", overallItemDequeRate=" + overallItemDequeueRate + ", overallOpsPerUpdate=" + (double)this.getDequeuedOperations() / Math.max((double)this.getDequeuedItems(), 1.0) + ", overallPrcntSignificant=" + (double)this.getSignificantOpsEnqueued() * 100.0 / Math.max((double)this.getEnqueuedOperations(), 1.0) + "%" + ", totalElapsedTime=" + (totalElapsedMillis + 500L) / 1000L;
        this.lastStatsTime = now;
        this.lastEnqueued = this.getEnqueuedOperations();
        this.lastDequeued = this.getDequeuedOperations();
        this.lastDequeuedItems = this.getDequeuedItems();
        this.lastSignificantEnqueued = this.getSignificantOpsEnqueued();
        this.lastSignificantDequeued = this.getSignificantOpsDequeued();
        this.lastSignificantCompleted = this.getSignificantOpsCompleted();
        this.lastOpsPending = this.getTotalOperationsPending();
        return stats;
    }

    public void logStats() {
        this.logLapTime(this.getStats());
    }

    void logLapTime(String message) {
        this.log().debug((Object)(message + " " + this.getLapTime()));
    }

    void logLapTime(String message, Throwable t) {
        this.log().debug((Object)(message + " " + this.getLapTime()), t);
    }

    public String getLapTime() {
        long newLap = System.currentTimeMillis();
        double seconds = (double)(newLap - this.lastLap) / 1000.0;
        this.lastLap = newLap;
        return "[" + seconds + " sec]";
    }

    @Override
    public int getGraphLeftOffset() {
        return this.m_delegate.getGraphLeftOffset();
    }

    @Override
    public int getGraphRightOffset() {
        return this.m_delegate.getGraphRightOffset();
    }

    @Override
    public int getGraphTopOffsetWithText() {
        return this.m_delegate.getGraphTopOffsetWithText();
    }

    @Override
    public String getDefaultFileExtension() {
        return this.m_delegate.getDefaultFileExtension();
    }

    @Override
    public RrdGraphDetails createGraphReturnDetails(String command, File workDir) throws IOException, RrdException {
        return this.m_delegate.createGraphReturnDetails(command, workDir);
    }

    public long getTotalOperationsPending() {
        return this.m_totalOperationsPending;
    }

    public void setTotalOperationsPending(long totalOperationsPending) {
        this.m_totalOperationsPending = totalOperationsPending;
    }

    public long getCreatesCompleted() {
        return this.m_createsCompleted;
    }

    public void setCreatesCompleted(long createsCompleted) {
        this.m_createsCompleted = createsCompleted;
    }

    public long getUpdatesCompleted() {
        return this.m_updatesCompleted;
    }

    public void setUpdatesCompleted(long updatesCompleted) {
        this.m_updatesCompleted = updatesCompleted;
    }

    public long getErrors() {
        return this.m_errors;
    }

    public void setErrors(long errors) {
        this.m_errors = errors;
    }

    public long getPromotionCount() {
        return this.m_promotionCount;
    }

    public void setPromotionCount(long promotionCount) {
        this.m_promotionCount = promotionCount;
    }

    public long getSignificantOpsEnqueued() {
        return this.m_significantOpsEnqueued;
    }

    public void setSignificantOpsEnqueued(long significantOpsEnqueued) {
        this.m_significantOpsEnqueued = significantOpsEnqueued;
    }

    public long getSignificantOpsDequeued() {
        return this.m_significantOpsDequeued;
    }

    public void setSignificantOpsDequeued(long significantOpsDequeued) {
        this.m_significantOpsDequeued = significantOpsDequeued;
    }

    public long getEnqueuedOperations() {
        return this.m_enqueuedOperations;
    }

    public void setEnqueuedOperations(long enqueuedOperations) {
        this.m_enqueuedOperations = enqueuedOperations;
    }

    public long getDequeuedOperations() {
        return this.m_dequeuedOperations;
    }

    public void setDequeuedOperations(long dequeuedOperations) {
        this.m_dequeuedOperations = dequeuedOperations;
    }

    public long getDequeuedItems() {
        return this.m_dequeuedItems;
    }

    public void setDequeuedItems(long dequeuedItems) {
        this.m_dequeuedItems = dequeuedItems;
    }

    public long getSignificantOpsCompleted() {
        return this.m_significantOpsCompleted;
    }

    public void setSignificantOpsCompleted(long significantOpsCompleted) {
        this.m_significantOpsCompleted = significantOpsCompleted;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(long updateStart) {
        this.m_startTime = updateStart;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZeroUpdateOperation
    extends UpdateOperation {
        long timeStamp;
        long interval;
        int count;

        ZeroUpdateOperation(String fileName, long intitialTimeStamp) {
            super(fileName, "0", false);
            this.interval = 0L;
            this.timeStamp = intitialTimeStamp;
            this.count = 1;
        }

        @Override
        Object process(Object rrd) throws Exception {
            long ts = this.getFirstTimeStamp();
            for (int i = 0; i < this.count; ++i) {
                if (rrd == null) {
                    rrd = QueuingRrdStrategy.this.m_delegate.openFile(this.getFileName());
                }
                String update = ts + ":0";
                try {
                    QueuingRrdStrategy.this.m_delegate.updateFile(rrd, "", update);
                }
                catch (Exception e) {
                    throw new Exception("Error processing update " + i + " for file " + this.getFileName() + ": " + update, e);
                }
                ts += this.getInterval();
                QueuingRrdStrategy.this.setUpdatesCompleted(QueuingRrdStrategy.this.getUpdatesCompleted() + 1L);
                if (QueuingRrdStrategy.this.getUpdatesCompleted() % MODULUS != 0L) continue;
                QueuingRrdStrategy.this.logStats();
            }
            return rrd;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public void setCount(int newCount) {
            this.count = newCount;
        }

        public long getFirstTimeStamp() {
            return this.timeStamp;
        }

        public long getLastTimeStamp() {
            return this.timeStamp + this.interval * (long)(this.count - 1);
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long newInterval) {
            this.interval = newInterval;
        }

        public void mergeUpdates(ZeroUpdateOperation op) throws IllegalArgumentException {
            long opSpacing = op.getFirstTimeStamp() - this.getLastTimeStamp();
            long tolerance = this.getInterval() / 5L;
            if (opSpacing == 0L) {
                throw new IllegalArgumentException("unable to merge op because the spacing " + opSpacing + " is 0");
            }
            if (this.getInterval() > 0L && Math.abs(opSpacing - this.getInterval()) >= tolerance) {
                throw new IllegalArgumentException("unable to merge op because the spacing " + opSpacing + " is different than the current interval " + this.getInterval());
            }
            if (this.getInterval() > 0L && op.getInterval() > 0L && Math.abs(op.getInterval() - this.getInterval()) >= tolerance) {
                throw new IllegalArgumentException("unable to merge op because the new op interval " + op.getInterval() + " is different than the current interval " + this.getInterval());
            }
            int newCount = this.getCount() + op.getCount();
            long newInterval = ((long)(this.getCount() - 1) * this.getInterval() + (long)(op.getCount() - 1) + op.getInterval() + opSpacing) / (long)(newCount - 1);
            this.setCount(newCount);
            this.setInterval(newInterval);
        }

        @Override
        void addToPendingList(LinkedList<Operation> pendingOperations) {
            if (pendingOperations.size() > 0 && pendingOperations.getLast() instanceof ZeroUpdateOperation) {
                ZeroUpdateOperation zeroOp = (ZeroUpdateOperation)pendingOperations.getLast();
                try {
                    zeroOp.mergeUpdates(this);
                }
                catch (IllegalArgumentException e) {
                    QueuingRrdStrategy.this.log().debug((Object)e.getMessage());
                    super.addToPendingList(pendingOperations);
                }
            } else {
                super.addToPendingList(pendingOperations);
            }
        }
    }

    public class UpdateOperation
    extends Operation {
        UpdateOperation(String fileName, String data) {
            super(fileName, 0, data, true);
        }

        UpdateOperation(String fileName, String data, boolean significant) {
            super(fileName, 0, data, significant);
        }

        Object process(Object rrd) throws Exception {
            if (rrd == null) {
                rrd = QueuingRrdStrategy.this.m_delegate.openFile(this.getFileName());
            }
            String update = (String)this.getData();
            try {
                QueuingRrdStrategy.this.m_delegate.updateFile(rrd, "", update);
            }
            catch (Exception e) {
                throw new Exception("Error processing update for file " + this.getFileName() + ": " + update, e);
            }
            QueuingRrdStrategy.this.setUpdatesCompleted(QueuingRrdStrategy.this.getUpdatesCompleted() + 1L);
            if (QueuingRrdStrategy.this.getUpdatesCompleted() % MODULUS == 0L) {
                QueuingRrdStrategy.this.logStats();
            }
            return rrd;
        }
    }

    public class CreateOperation
    extends Operation {
        CreateOperation(String fileName, Object rrdDef) {
            super(fileName, 1, rrdDef, true);
        }

        Object process(Object rrd) throws Exception {
            if (rrd != null) {
                QueuingRrdStrategy.this.log().debug((Object)"WHAT! rrd open but not created?");
                QueuingRrdStrategy.this.m_delegate.closeFile(rrd);
                rrd = null;
            }
            QueuingRrdStrategy.this.m_delegate.createFile(this.getData());
            QueuingRrdStrategy.this.setCreatesCompleted(QueuingRrdStrategy.this.getCreatesCompleted() + 1L);
            return rrd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Operation {
        String fileName;
        int type;
        Object data;
        boolean significant;

        Operation(String fileName, int type, Object data, boolean significant) {
            this.fileName = fileName;
            this.type = type;
            this.data = data;
            this.significant = significant;
        }

        int getCount() {
            return 1;
        }

        String getFileName() {
            return this.fileName;
        }

        int getType() {
            return this.type;
        }

        Object getData() {
            return this.data;
        }

        boolean isSignificant() {
            return this.significant;
        }

        void addToPendingList(LinkedList<Operation> pendingOperations) {
            pendingOperations.add(this);
        }

        abstract Object process(Object var1) throws Exception;
    }
}

