/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.QueuingRrdStrategy;
import org.opennms.netmgt.rrd.RrdConfig;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RrdUtils {
    private static final String DEFAULT_RRD_STRATEGY_CLASSNAME = "org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy";
    private static final boolean USE_QUEUE = RrdConfig.getProperty("org.opennms.rrd.usequeue", true);
    private static final String RRD_STRATEGY_CLASSNAME = RrdConfig.getProperty("org.opennms.rrd.strategyClass", "org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy");
    private static RrdStrategy m_rrdStrategy = null;
    private static String m_rrdExtension = RrdConfig.getProperty("org.opennms.rrd.fileExtension", null);

    public static RrdStrategy getStrategy() {
        if (m_rrdStrategy == null) {
            throw new IllegalStateException("RrdUtils not initialized");
        }
        return m_rrdStrategy;
    }

    public static void setStrategy(RrdStrategy strategy) {
        m_rrdStrategy = strategy;
    }

    public static void initialize() throws RrdException {
        try {
            RrdUtils.createStrategy();
            m_rrdStrategy.initialize();
        }
        catch (Exception e) {
            throw new RrdException("An error occured initializing the Rrd subsytem", e);
        }
    }

    public static void graphicsInitialize() throws RrdException {
        try {
            RrdUtils.createStrategy();
            m_rrdStrategy.graphicsInitialize();
        }
        catch (Exception e) {
            throw new RrdException("An error occured initializing the Rrd subsytem", e);
        }
    }

    private static void createStrategy() throws RrdException {
        if (m_rrdStrategy == null) {
            RrdStrategy rrdStategy = RrdUtils.constructStrategyInstance();
            if (USE_QUEUE) {
                rrdStategy = new QueuingRrdStrategy(rrdStategy);
            }
            m_rrdStrategy = rrdStategy;
        }
    }

    private static RrdStrategy constructStrategyInstance() throws RrdException {
        try {
            return (RrdStrategy)Class.forName(RRD_STRATEGY_CLASSNAME).newInstance();
        }
        catch (Exception e) {
            RrdUtils.log().error((Object)("constructStrategyInstance: Unable to load and instantiate RrdStrategy " + RRD_STRATEGY_CLASSNAME + ": " + e), (Throwable)e);
            throw new RrdException("Unable to load and instantiate RrdStrategy " + RRD_STRATEGY_CLASSNAME + ": " + e, e);
        }
    }

    public static boolean createRRD(String creator, String directory, String dsName, int step, String dsType, int dsHeartbeat, String dsMin, String dsMax, List<String> rraList) throws RrdException {
        return RrdUtils.createRRD(creator, directory, dsName, step, Collections.singletonList(new RrdDataSource(dsName, dsType, dsHeartbeat, dsMin, dsMax)), rraList);
    }

    public static boolean createRRD(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws RrdException {
        String fileName = rrdName + RrdUtils.getExtension();
        String completePath = directory + File.separator + fileName;
        RrdUtils.log().info((Object)("createRRD: creating RRD file " + completePath));
        try {
            Object def = RrdUtils.getStrategy().createDefinition(creator, directory, rrdName, step, dataSources, rraList);
            RrdUtils.getStrategy().createFile(def);
            return true;
        }
        catch (Exception e) {
            RrdUtils.log().error((Object)("createRRD: An error occured creating rrdfile " + completePath + ": " + e), (Throwable)e);
            throw new RrdException("An error occured creating rrdfile " + completePath + ": " + e, e);
        }
    }

    private static Category log() {
        return ThreadCategory.getInstance(RrdUtils.class);
    }

    public static void updateRRD(String owner, String repositoryDir, String rrdName, String val) throws RrdException {
        RrdUtils.updateRRD(owner, repositoryDir, rrdName, System.currentTimeMillis(), val);
    }

    public static void updateRRD(String owner, String repositoryDir, String rrdName, long timestamp, String val) throws RrdException {
        String rrdFile = repositoryDir + File.separator + rrdName + RrdUtils.getExtension();
        long time = (timestamp + 500L) / 1000L;
        String updateVal = Long.toString(time) + ":" + val;
        RrdUtils.log().info((Object)("updateRRD: updating RRD file " + rrdFile + " with values '" + updateVal + "'"));
        Object rrd = null;
        try {
            rrd = RrdUtils.getStrategy().openFile(rrdFile);
            RrdUtils.getStrategy().updateFile(rrd, owner, updateVal);
        }
        catch (Exception e) {
            RrdUtils.log().error((Object)("updateRRD: Error updating RRD file " + rrdFile + " with values '" + updateVal + "': " + e), (Throwable)e);
            throw new RrdException("Error updating RRD file " + rrdFile + " with values '" + updateVal + "': " + e, e);
        }
        finally {
            try {
                if (rrd != null) {
                    RrdUtils.getStrategy().closeFile(rrd);
                }
            }
            catch (Exception e) {
                RrdUtils.log().error((Object)("updateRRD: Exception closing RRD file " + rrdFile + ": " + e), (Throwable)e);
                throw new RrdException("Exception closing RRD file " + rrdFile + ": " + e, e);
            }
        }
        if (RrdUtils.log().isDebugEnabled()) {
            RrdUtils.log().debug((Object)"updateRRD: RRD update command completed.");
        }
    }

    public static Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException, RrdException {
        return RrdUtils.getStrategy().fetchLastValue(rrdFile, ds, interval);
    }

    public static Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException, RrdException {
        return RrdUtils.getStrategy().fetchLastValueInRange(rrdFile, ds, interval, range);
    }

    public static InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        return RrdUtils.getStrategy().createGraph(command, workDir);
    }

    public static String getExtension() {
        if (m_rrdExtension == null) {
            return RrdUtils.getStrategy().getDefaultFileExtension();
        }
        return m_rrdExtension;
    }

    public static void promoteEnqueuedFiles(Collection<String> files) {
        RrdUtils.getStrategy().promoteEnqueuedFiles(files);
    }
}

