/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.net.InetAddress;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class ReverseDnsRecord {
    String m_hostname;
    String m_zone;
    InetAddress m_ip;

    public ReverseDnsRecord(OnmsIpInterface ipInterface) {
        OnmsSnmpInterface snmpInterface = ipInterface.getSnmpInterface();
        if (snmpInterface == null) {
            ReverseDnsRecord.log().debug("Constructor: no SnmpInterface found");
            this.m_hostname = ipInterface.getNode().getLabel() + ".";
        } else if (snmpInterface.getIfName() != null) {
            ReverseDnsRecord.log().debug("Constructor: SnmpInterface found: ifname: " + snmpInterface.getIfName());
            this.m_hostname = AlphaNumeric.parseAndReplace((String)snmpInterface.getIfName(), (char)'-') + "-" + ipInterface.getNode().getLabel() + ".";
        } else if (snmpInterface.getIfDescr() != null) {
            ReverseDnsRecord.log().debug("Constructor: SnmpInterface found: ifdescr: " + snmpInterface.getIfDescr());
            this.m_hostname = AlphaNumeric.parseAndReplace((String)snmpInterface.getIfDescr(), (char)'-') + "-" + ipInterface.getNode().getLabel() + ".";
        } else {
            ReverseDnsRecord.log().debug("Constructor: SnmpInterface found: ifindex: " + snmpInterface.getIfDescr());
            this.m_hostname = "ifindex-" + snmpInterface.getIfIndex() + "-" + ipInterface.getNode().getLabel() + ".";
        }
        ReverseDnsRecord.log().debug("Constructor: set hostname: " + this.m_hostname);
        this.m_ip = ipInterface.getIpAddress();
        ReverseDnsRecord.log().debug("Constructor: set ip address: " + this.m_ip);
        this.m_zone = ReverseDnsRecord.thirdLevelZonefromInet4Address(this.m_ip.getAddress());
        ReverseDnsRecord.log().debug("Constructor: set zone: " + this.m_zone);
    }

    public String getHostname() {
        return this.m_hostname;
    }

    public String getZone() {
        return this.m_zone;
    }

    public InetAddress getIp() {
        return this.m_ip;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(ReverseDnsRecord.class);
    }

    public static String thirdLevelZonefromInet4Address(byte[] addr) {
        if (addr.length != 4 && addr.length != 16) {
            throw new IllegalArgumentException("array must contain 4 or 16 elements");
        }
        StringBuffer sb = new StringBuffer();
        if (addr.length == 4) {
            for (int i = addr.length - 2; i >= 0; --i) {
                sb.append(addr[i] & 0xFF);
                if (i <= 0) continue;
                sb.append(".");
            }
        }
        sb.append(".in-addr.arpa.");
        return sb.toString();
    }
}

