/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.ReverseDnsProvisioningAdapterService;
import org.opennms.netmgt.provision.ReverseDnsRecord;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class DefaultReverseDnsProvisioningAdapterService
implements ReverseDnsProvisioningAdapterService {
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private TransactionTemplate m_template;

    public void setTemplate(TransactionTemplate template) {
        this.m_template = template;
    }

    public TransactionTemplate getTemplate() {
        return this.m_template;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_nodeDao, (String)"ReverseDnsProvisioner requires a NodeDao which is not null.");
        Assert.notNull((Object)this.m_ipInterfaceDao, (String)"ReverseDnsProvisioner requires an IpInterfaceDao which is not null.");
    }

    @Override
    public List<ReverseDnsRecord> get(final Integer nodeid) {
        final ArrayList<ReverseDnsRecord> records = new ArrayList<ReverseDnsRecord>();
        this.m_template.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus arg0) {
                for (OnmsIpInterface ipInterface : ((OnmsNode)DefaultReverseDnsProvisioningAdapterService.this.m_nodeDao.get((Serializable)nodeid)).getIpInterfaces()) {
                    records.add(new ReverseDnsRecord(ipInterface));
                }
                return null;
            }
        });
        return records;
    }

    @Override
    public void update(Integer nodeid, ReverseDnsRecord rdr) {
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeid, rdr.getIp().getHostAddress());
        if (ipInterface != null) {
            ipInterface.setIpHostName(rdr.getHostname());
            this.m_ipInterfaceDao.update((Object)ipInterface);
        }
    }
}

