/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.inventory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.rancid.ConnectionProperties;
import org.opennms.rancid.InventoryElement2;
import org.opennms.rancid.InventoryMemory;
import org.opennms.rancid.InventoryNode;
import org.opennms.rancid.InventorySoftware;
import org.opennms.rancid.RWSClientApi;
import org.opennms.rancid.RancidApiException;
import org.opennms.rancid.RancidNode;
import org.opennms.rancid.Tuple;
import org.opennms.report.inventory.GroupSet;
import org.opennms.report.inventory.InventoryCalculationException;
import org.opennms.report.inventory.InventoryElement2RP;
import org.opennms.report.inventory.InventoryMemoryRP;
import org.opennms.report.inventory.InventorySoftwareRP;
import org.opennms.report.inventory.Nbisinglenode;
import org.opennms.report.inventory.NodeBaseInventory;
import org.opennms.report.inventory.RwsNbinventoryreport;
import org.opennms.report.inventory.TupleRP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class InventoryReportCalculator
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryReportCalculator.class);
    String m_baseDir;
    private String m_outputFileName;
    ConnectionProperties m_cp;
    RWSConfig m_rwsConfig;
    String theDate;
    String user;
    String theField;
    Date reportRequestDate;
    RwsNbinventoryreport rnbi;

    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.m_outputFileName = outputFileName;
    }

    public String getTheField() {
        return this.theField;
    }

    public void setTheField(String theField) {
        this.theField = theField;
    }

    public String getTheDate() {
        return this.theDate;
    }

    public void setTheDate(String theDate) {
        this.theDate = theDate;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getReportRequestDate() {
        return this.reportRequestDate;
    }

    public void setReportRequestDate(Date reportRequestDate) {
        this.reportRequestDate = reportRequestDate;
    }

    public RWSConfig getRwsConfig() {
        return this.m_rwsConfig;
    }

    public void setRwsConfig(RWSConfig rwsConfig) {
        this.m_rwsConfig = rwsConfig;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
    }

    public void afterPropertiesSet() throws Exception {
        RWSClientApi.init();
        this.m_cp = this.m_rwsConfig.getBase();
    }

    private List<String> getGroups() {
        try {
            return RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp).getResource();
        }
        catch (RancidApiException e) {
            LOG.error("getGroups: has given exception {}. Skipped", (Object)e.getMessage());
            return new ArrayList<String>();
        }
    }

    private List<String> getDeviceListOnGroup(String groupName) {
        try {
            return RWSClientApi.getRWSResourceDeviceList((ConnectionProperties)this.m_cp, (String)groupName).getResource();
        }
        catch (RancidApiException e) {
            LOG.error("getDeviceListOnGroup: group [{}]. Skipped", (Object)groupName);
            return new ArrayList<String>();
        }
    }

    private List<String> getVersionListOnDevice(String deviceName, String groupName) {
        try {
            return RWSClientApi.getRWSResourceConfigList((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName).getResource();
        }
        catch (RancidApiException e) {
            LOG.error("getVersionListOnDevice:  device has no inventory [{}]. {}", (Object)deviceName, (Object)e.getLocalizedMessage());
            return new ArrayList<String>();
        }
    }

    private RancidNode getFullNode(String groupName, String deviceName) {
        try {
            return RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName);
        }
        catch (RancidApiException e) {
            LOG.error("getFullNode:  device has no inventory [{}]. {}", (Object)deviceName, (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public void calculate() {
        this.rnbi = new RwsNbinventoryreport();
        this.rnbi.setUser(this.user);
        this.rnbi.setReportRequestDate(this.reportRequestDate.toString());
        boolean withKey = false;
        if (this.theField.compareTo("") != 0) {
            withKey = true;
            this.rnbi.setTheField(this.theField);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy/M/d");
        Date tmp_date = new Date();
        try {
            tmp_date = format.parse(this.theDate);
        }
        catch (ParseException pe) {
            tmp_date = Calendar.getInstance().getTime();
        }
        LOG.debug("calculate:report date[{}]", (Object)tmp_date.toString());
        this.rnbi.setReportDate(tmp_date.toString());
        int totalGroups = 0;
        int groupsMatching = 0;
        int groupWithoutNodes = 0;
        int groupsWithNodesWithoutinventoryAtAll = 0;
        int groupsWithNodesWithoutinventoryAtReportDate = 0;
        for (String groupName : this.getGroups()) {
            LOG.debug("calculate:report group [{}]", (Object)groupName);
            ++totalGroups;
            GroupSet gs = new GroupSet();
            gs.setGroupSetName(groupName);
            int totalNodes = 0;
            int nodeMatching = 0;
            int nodesWithoutinventoryAtAll = 0;
            int nodesWithoutinventoryAtReportDate = 0;
            boolean groupHasDevices = false;
            boolean groupHasNodesWithoutinventoryAtAll = false;
            boolean groupHasNodesWithoutinventoryAtrequestDate = false;
            for (String deviceName : this.getDeviceListOnGroup(groupName)) {
                ++totalNodes;
                LOG.debug("calculate:report device [{}]", (Object)deviceName);
                RancidNode rancidNode = this.getFullNode(groupName, deviceName);
                if (rancidNode == null) {
                    groupHasNodesWithoutinventoryAtAll = true;
                    ++nodesWithoutinventoryAtAll;
                    continue;
                }
                InventoryNode invNode = new InventoryNode(rancidNode);
                boolean found = false;
                for (String versionMatch : this.getVersionListOnDevice(deviceName, groupName)) {
                    invNode = (InventoryNode)rancidNode.getNodeVersions().get(versionMatch);
                    LOG.debug("calculate:report parsing InventoryNode version[{}] date [{}]", (Object)invNode.getVersionId(), (Object)invNode.getCreationDate());
                    if (tmp_date.compareTo(invNode.getCreationDate()) <= 0) continue;
                    found = true;
                    LOG.debug("calculate:report Date found is [{}] version is [{}]", (Object)invNode.getCreationDate(), (Object)versionMatch);
                    break;
                }
                if (!found) {
                    LOG.debug("calculate: device has no configuration at this date[{}]", (Object)deviceName);
                    groupHasNodesWithoutinventoryAtrequestDate = true;
                    ++nodesWithoutinventoryAtReportDate;
                    continue;
                }
                NodeBaseInventory nodeBaseInv = this.getNodeBaseInventory(deviceName, groupName, invNode.getVersionId());
                Nbisinglenode nbisn = new Nbisinglenode();
                boolean includeNbisn = false;
                nbisn.setConfigurationurl(nodeBaseInv.getConfigurationurl());
                nbisn.setCreationdate(nodeBaseInv.getCreationdate());
                nbisn.setDevicename(nodeBaseInv.getDevicename());
                nbisn.setGroupname(nodeBaseInv.getGroupname());
                nbisn.setStatus(nodeBaseInv.getStatus());
                nbisn.setSwconfigurationurl(nodeBaseInv.getSwconfigurationurl());
                nbisn.setVersion(nodeBaseInv.getVersion());
                ArrayList<InventoryElement2RP> ie2rpList = new ArrayList<InventoryElement2RP>();
                for (InventoryElement2 ie2 : nodeBaseInv.getIe()) {
                    InventoryElement2RP ie2rp = new InventoryElement2RP();
                    boolean addInventoryElement = false;
                    for (Tuple tuple : ie2.getTupleList()) {
                        if (withKey) {
                            if (Pattern.matches(this.theField, tuple.getDescription()) || Pattern.matches(this.theField, tuple.getName())) {
                                includeNbisn = true;
                                addInventoryElement = true;
                            }
                        } else {
                            includeNbisn = true;
                            addInventoryElement = true;
                        }
                        if (tuple.getName().equalsIgnoreCase("name")) {
                            ie2rp.setName(tuple.getDescription());
                            continue;
                        }
                        TupleRP trp = new TupleRP();
                        trp.setName(tuple.getName());
                        trp.setDescription(tuple.getDescription());
                        ie2rp.addTupleRP(trp);
                    }
                    for (InventoryMemory im : ie2.getMemoryList()) {
                        if (withKey) {
                            if (Pattern.matches(this.theField, "Memory") || Pattern.matches(this.theField, im.getType())) {
                                includeNbisn = true;
                                addInventoryElement = true;
                            }
                        } else {
                            includeNbisn = true;
                            addInventoryElement = true;
                        }
                        InventoryMemoryRP imrp = new InventoryMemoryRP();
                        imrp.setType(im.getType());
                        imrp.setSize(im.getSize());
                        ie2rp.addInventoryMemoryRP(imrp);
                    }
                    for (InventorySoftware is : ie2.getSoftwareList()) {
                        if (withKey) {
                            if (Pattern.matches(this.theField, "Software") || Pattern.matches(this.theField, is.getType()) || Pattern.matches(this.theField, is.getVersion())) {
                                includeNbisn = true;
                                addInventoryElement = true;
                            }
                        } else {
                            includeNbisn = true;
                            addInventoryElement = true;
                        }
                        InventorySoftwareRP isrp = new InventorySoftwareRP();
                        isrp.setType(is.getType());
                        isrp.setVersion(is.getVersion());
                        ie2rp.addInventorySoftwareRP(isrp);
                    }
                    if (!addInventoryElement) continue;
                    ie2rpList.add(ie2rp);
                }
                nbisn.setInventoryElement2RP(ie2rpList);
                if (!includeNbisn) continue;
                ++nodeMatching;
                groupHasDevices = true;
                gs.addNbisinglenode(nbisn);
            }
            gs.setTotalNodes(totalNodes);
            gs.setNodesMatching(nodeMatching);
            gs.setNodesWithoutinventoryAtReportDate(nodesWithoutinventoryAtReportDate);
            gs.setNodesWithoutinventoryAtAll(nodesWithoutinventoryAtAll);
            this.rnbi.addGroupSet(gs);
            if (groupHasDevices) {
                ++groupsMatching;
            } else {
                ++groupWithoutNodes;
            }
            if (groupHasDevices && groupHasNodesWithoutinventoryAtAll) {
                ++groupsWithNodesWithoutinventoryAtAll;
            }
            if (!groupHasDevices || !groupHasNodesWithoutinventoryAtrequestDate) continue;
            ++groupsWithNodesWithoutinventoryAtReportDate;
        }
        this.rnbi.setTotalGroups(totalGroups);
        this.rnbi.setGroupsMatching(groupsMatching);
        this.rnbi.setGroupsWithNodesWithoutinventoryAtAll(groupsWithNodesWithoutinventoryAtAll);
        this.rnbi.setGroupsWithNodesWithoutinventoryAtReportDate(groupsWithNodesWithoutinventoryAtReportDate);
        this.rnbi.setGroupWithoutNodes(groupWithoutNodes);
    }

    public NodeBaseInventory getNodeBaseInventory(String node, String group, String version) {
        RancidNode rn;
        LOG.debug("getNodeBaseInventory {} {} {}", new Object[]{node, group, version});
        NodeBaseInventory nbi = new NodeBaseInventory();
        try {
            rn = RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)group, (String)node);
        }
        catch (RancidApiException e) {
            LOG.debug("getNodeBaseInventory: inventory not found. Skipping");
            return nbi;
        }
        InventoryNode in = (InventoryNode)rn.getNodeVersions().get(version);
        nbi.setDevicename(node);
        nbi.setGroupname(group);
        nbi.setVersion(version);
        nbi.setStatus(in.getParent().getState());
        nbi.setCreationdate(in.getCreationDate());
        nbi.setSwconfigurationurl(in.getSoftwareImageUrl());
        nbi.setConfigurationurl(in.getConfigurationUrl());
        try {
            nbi.setIe(RWSClientApi.getRWSRancidNodeInventoryElement2((ConnectionProperties)this.m_cp, (RancidNode)rn, (String)version));
        }
        catch (RancidApiException e) {
            LOG.debug("getNodeBaseInventory: inventory not found for version: {}. Skipping", (Object)version);
        }
        return nbi;
    }

    public void writeXML() throws InventoryCalculationException {
        try {
            LOG.debug("Writing the XML");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
            String datestamp = fmt.format(this.reportRequestDate);
            this.m_outputFileName = "/NODEINVENTORY" + datestamp + ".xml";
            LOG.debug("Report Store XML file: {}", (Object)this.m_outputFileName);
            File reportFile = new File(this.m_baseDir, this.m_outputFileName);
            this.marshal(reportFile);
        }
        catch (InventoryCalculationException e) {
            LOG.error("Unable to marshal report as XML");
            throw new InventoryCalculationException(e);
        }
    }

    public void marshal(File outputFile) throws InventoryCalculationException {
        try {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            Marshaller marshaller = new Marshaller((Writer)fileWriter);
            marshaller.setSuppressNamespaces(true);
            marshaller.marshal((Object)this.rnbi);
            LOG.debug("The xml marshalled from the castor classes is saved in {}", (Object)outputFile.getAbsoluteFile());
            ((Writer)fileWriter).close();
        }
        catch (MarshalException me) {
            LOG.error("MarshalException ", (Throwable)me);
            throw new InventoryCalculationException(me);
        }
        catch (ValidationException ve) {
            LOG.error("Validation Exception ", (Throwable)ve);
            throw new InventoryCalculationException(ve);
        }
        catch (IOException ioe) {
            LOG.error("IO Exception ", (Throwable)ioe);
            throw new InventoryCalculationException(ioe);
        }
    }
}

