/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.inventory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.rancid.ConnectionProperties;
import org.opennms.rancid.InventoryElement2;
import org.opennms.rancid.InventoryMemory;
import org.opennms.rancid.InventoryNode;
import org.opennms.rancid.InventorySoftware;
import org.opennms.rancid.RWSClientApi;
import org.opennms.rancid.RancidApiException;
import org.opennms.rancid.RancidNode;
import org.opennms.rancid.Tuple;
import org.opennms.report.inventory.GroupSet;
import org.opennms.report.inventory.InventoryCalculationException;
import org.opennms.report.inventory.InventoryElement2RP;
import org.opennms.report.inventory.InventoryMemoryRP;
import org.opennms.report.inventory.InventorySoftwareRP;
import org.opennms.report.inventory.Nbisinglenode;
import org.opennms.report.inventory.NodeBaseInventory;
import org.opennms.report.inventory.RwsNbinventoryreport;
import org.opennms.report.inventory.TupleRP;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryReportCalculator
implements InitializingBean {
    String m_baseDir;
    private String m_outputFileName;
    ConnectionProperties m_cp;
    RWSConfig m_rwsConfig;
    String theDate;
    String user;
    String theField;
    Date reportRequestDate;
    RwsNbinventoryreport rnbi;

    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.m_outputFileName = outputFileName;
    }

    public String getTheField() {
        return this.theField;
    }

    public void setTheField(String theField) {
        this.theField = theField;
    }

    public String getTheDate() {
        return this.theDate;
    }

    public void setTheDate(String theDate) {
        this.theDate = theDate;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getReportRequestDate() {
        return this.reportRequestDate;
    }

    public void setReportRequestDate(Date reportRequestDate) {
        this.reportRequestDate = reportRequestDate;
    }

    public RWSConfig getRwsConfig() {
        return this.m_rwsConfig;
    }

    public void setRwsConfig(RWSConfig rwsConfig) {
        this.m_rwsConfig = rwsConfig;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
    }

    private static Logger log() {
        return Logger.getLogger((String)"Rancid");
    }

    public void afterPropertiesSet() throws Exception {
        RWSClientApi.init();
        this.m_cp = this.m_rwsConfig.getBase();
    }

    private List<String> getGroups() {
        try {
            return RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp).getResource();
        }
        catch (RancidApiException e) {
            InventoryReportCalculator.log().error((Object)("getGroups: has given exception " + e.getMessage() + ". Skipped"));
            return new ArrayList<String>();
        }
    }

    private List<String> getDeviceListOnGroup(String groupName) {
        try {
            return RWSClientApi.getRWSResourceDeviceList((ConnectionProperties)this.m_cp, (String)groupName).getResource();
        }
        catch (RancidApiException e) {
            InventoryReportCalculator.log().error((Object)("getDeviceListOnGroup: group [" + groupName + "]. Skipped"));
            return new ArrayList<String>();
        }
    }

    private List<String> getVersionListOnDevice(String deviceName, String groupName) {
        try {
            return RWSClientApi.getRWSResourceConfigList((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName).getResource();
        }
        catch (RancidApiException e) {
            InventoryReportCalculator.log().error((Object)("getVersionListOnDevice:  device has no inventory [" + deviceName + "]. " + e.getLocalizedMessage()));
            return new ArrayList<String>();
        }
    }

    private RancidNode getFullNode(String groupName, String deviceName) {
        try {
            return RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName);
        }
        catch (RancidApiException e) {
            InventoryReportCalculator.log().error((Object)("getFullNode:  device has no inventory [" + deviceName + "]. " + e.getLocalizedMessage()));
            return null;
        }
    }

    public void calculate() {
        this.rnbi = new RwsNbinventoryreport();
        this.rnbi.setUser(this.user);
        this.rnbi.setReportRequestDate(this.reportRequestDate.toString());
        boolean withKey = false;
        if (this.theField.compareTo("") != 0) {
            withKey = true;
            this.rnbi.setTheField(this.theField);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy/M/d");
        Date tmp_date = new Date();
        try {
            tmp_date = format.parse(this.theDate);
        }
        catch (ParseException pe) {
            tmp_date = Calendar.getInstance().getTime();
        }
        InventoryReportCalculator.log().debug((Object)("calculate:report date[" + tmp_date.toString() + "]"));
        this.rnbi.setReportDate(tmp_date.toString());
        int totalGroups = 0;
        int groupsMatching = 0;
        int groupWithoutNodes = 0;
        int groupsWithNodesWithoutinventoryAtAll = 0;
        int groupsWithNodesWithoutinventoryAtReportDate = 0;
        for (String groupName : this.getGroups()) {
            InventoryReportCalculator.log().debug((Object)("calculate:report group [" + groupName + "]"));
            ++totalGroups;
            GroupSet gs = new GroupSet();
            gs.setGroupSetName(groupName);
            int totalNodes = 0;
            int nodeMatching = 0;
            int nodesWithoutinventoryAtAll = 0;
            int nodesWithoutinventoryAtReportDate = 0;
            boolean groupHasDevices = false;
            boolean groupHasNodesWithoutinventoryAtAll = false;
            boolean groupHasNodesWithoutinventoryAtrequestDate = false;
            for (String deviceName : this.getDeviceListOnGroup(groupName)) {
                ++totalNodes;
                InventoryReportCalculator.log().debug((Object)("calculate:report device [" + deviceName + "]"));
                RancidNode rancidNode = this.getFullNode(groupName, deviceName);
                if (rancidNode == null) {
                    groupHasNodesWithoutinventoryAtAll = true;
                    ++nodesWithoutinventoryAtAll;
                    continue;
                }
                InventoryNode invNode = new InventoryNode(rancidNode);
                boolean found = false;
                for (String versionMatch : this.getVersionListOnDevice(deviceName, groupName)) {
                    invNode = (InventoryNode)rancidNode.getNodeVersions().get(versionMatch);
                    InventoryReportCalculator.log().debug((Object)("calculate:report parsing InventoryNode version[" + invNode.getVersionId() + "] date [" + invNode.getCreationDate() + "]"));
                    if (tmp_date.compareTo(invNode.getCreationDate()) <= 0) continue;
                    found = true;
                    InventoryReportCalculator.log().debug((Object)("calculate:report Date found is [" + invNode.getCreationDate() + "] version is [" + versionMatch + "]"));
                    break;
                }
                if (!found) {
                    InventoryReportCalculator.log().debug((Object)("calculate: device has no configuration at this date[" + deviceName + "]"));
                    groupHasNodesWithoutinventoryAtrequestDate = true;
                    ++nodesWithoutinventoryAtReportDate;
                    continue;
                }
                NodeBaseInventory nodeBaseInv = this.getNodeBaseInventory(deviceName, groupName, invNode.getVersionId());
                Nbisinglenode nbisn = new Nbisinglenode();
                boolean includeNbisn = false;
                nbisn.setConfigurationurl(nodeBaseInv.getConfigurationurl());
                nbisn.setCreationdate(nodeBaseInv.getCreationdate());
                nbisn.setDevicename(nodeBaseInv.getDevicename());
                nbisn.setGroupname(nodeBaseInv.getGroupname());
                nbisn.setStatus(nodeBaseInv.getStatus());
                nbisn.setSwconfigurationurl(nodeBaseInv.getSwconfigurationurl());
                nbisn.setVersion(nodeBaseInv.getVersion());
                ArrayList<InventoryElement2RP> ie2rpList = new ArrayList<InventoryElement2RP>();
                for (InventoryElement2 ie2 : nodeBaseInv.getIe()) {
                    InventoryElement2RP ie2rp = new InventoryElement2RP();
                    boolean addInventoryElement = false;
                    for (Tuple tuple : ie2.getTupleList()) {
                        if (withKey) {
                            if (Pattern.matches(this.theField, tuple.getDescription()) || Pattern.matches(this.theField, tuple.getName())) {
                                includeNbisn = true;
                                addInventoryElement = true;
                            }
                        } else {
                            includeNbisn = true;
                            addInventoryElement = true;
                        }
                        if (tuple.getName().equalsIgnoreCase("name")) {
                            ie2rp.setName(tuple.getDescription());
                            continue;
                        }
                        TupleRP trp = new TupleRP();
                        trp.setName(tuple.getName());
                        trp.setDescription(tuple.getDescription());
                        ie2rp.addTupleRP(trp);
                    }
                    for (InventoryMemory im : ie2.getMemoryList()) {
                        if (withKey) {
                            if (Pattern.matches(this.theField, "Memory") || Pattern.matches(this.theField, im.getType())) {
                                includeNbisn = true;
                                addInventoryElement = true;
                            }
                        } else {
                            includeNbisn = true;
                            addInventoryElement = true;
                        }
                        InventoryMemoryRP imrp = new InventoryMemoryRP();
                        imrp.setType(im.getType());
                        imrp.setSize(im.getSize());
                        ie2rp.addInventoryMemoryRP(imrp);
                    }
                    for (InventorySoftware is : ie2.getSoftwareList()) {
                        if (withKey) {
                            if (Pattern.matches(this.theField, "Software") || Pattern.matches(this.theField, is.getType()) || Pattern.matches(this.theField, is.getVersion())) {
                                includeNbisn = true;
                                addInventoryElement = true;
                            }
                        } else {
                            includeNbisn = true;
                            addInventoryElement = true;
                        }
                        InventorySoftwareRP isrp = new InventorySoftwareRP();
                        isrp.setType(is.getType());
                        isrp.setVersion(is.getVersion());
                        ie2rp.addInventorySoftwareRP(isrp);
                    }
                    if (!addInventoryElement) continue;
                    ie2rpList.add(ie2rp);
                }
                nbisn.setInventoryElement2RP(ie2rpList);
                if (!includeNbisn) continue;
                ++nodeMatching;
                groupHasDevices = true;
                gs.addNbisinglenode(nbisn);
            }
            gs.setTotalNodes(totalNodes);
            gs.setNodesMatching(nodeMatching);
            gs.setNodesWithoutinventoryAtReportDate(nodesWithoutinventoryAtReportDate);
            gs.setNodesWithoutinventoryAtAll(nodesWithoutinventoryAtAll);
            this.rnbi.addGroupSet(gs);
            if (groupHasDevices) {
                ++groupsMatching;
            } else {
                ++groupWithoutNodes;
            }
            if (groupHasDevices && groupHasNodesWithoutinventoryAtAll) {
                ++groupsWithNodesWithoutinventoryAtAll;
            }
            if (!groupHasDevices || !groupHasNodesWithoutinventoryAtrequestDate) continue;
            ++groupsWithNodesWithoutinventoryAtReportDate;
        }
        this.rnbi.setTotalGroups(totalGroups);
        this.rnbi.setGroupsMatching(groupsMatching);
        this.rnbi.setGroupsWithNodesWithoutinventoryAtAll(groupsWithNodesWithoutinventoryAtAll);
        this.rnbi.setGroupsWithNodesWithoutinventoryAtReportDate(groupsWithNodesWithoutinventoryAtReportDate);
        this.rnbi.setGroupWithoutNodes(groupWithoutNodes);
    }

    public NodeBaseInventory getNodeBaseInventory(String node, String group, String version) {
        RancidNode rn;
        InventoryReportCalculator.log().debug((Object)("getNodeBaseInventory " + node + " " + group + " " + version));
        NodeBaseInventory nbi = new NodeBaseInventory();
        try {
            rn = RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)group, (String)node);
        }
        catch (RancidApiException e) {
            InventoryReportCalculator.log().debug((Object)"getNodeBaseInventory: inventory not found. Skipping");
            return nbi;
        }
        InventoryNode in = (InventoryNode)rn.getNodeVersions().get(version);
        nbi.setDevicename(node);
        nbi.setGroupname(group);
        nbi.setVersion(version);
        nbi.setStatus(in.getParent().getState());
        nbi.setCreationdate(in.getCreationDate());
        nbi.setSwconfigurationurl(in.getSoftwareImageUrl());
        nbi.setConfigurationurl(in.getConfigurationUrl());
        try {
            nbi.setIe(RWSClientApi.getRWSRancidNodeInventoryElement2((ConnectionProperties)this.m_cp, (RancidNode)rn, (String)version));
        }
        catch (RancidApiException e) {
            InventoryReportCalculator.log().debug((Object)("getNodeBaseInventory: inventory not found for version: " + version + ". Skipping"));
        }
        return nbi;
    }

    public void writeXML() throws InventoryCalculationException {
        try {
            InventoryReportCalculator.log().debug((Object)"Writing the XML");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
            String datestamp = fmt.format(this.reportRequestDate);
            this.m_outputFileName = "/NODEINVENTORY" + datestamp + ".xml";
            InventoryReportCalculator.log().debug((Object)("Report Store XML file: " + this.m_outputFileName));
            File reportFile = new File(this.m_baseDir, this.m_outputFileName);
            this.marshal(reportFile);
        }
        catch (InventoryCalculationException e) {
            InventoryReportCalculator.log().fatal((Object)"Unable to marshal report as XML");
            throw new InventoryCalculationException(e);
        }
    }

    public void marshal(File outputFile) throws InventoryCalculationException {
        try {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            Marshaller marshaller = new Marshaller((Writer)fileWriter);
            marshaller.setSuppressNamespaces(true);
            marshaller.marshal((Object)this.rnbi);
            InventoryReportCalculator.log().debug((Object)("The xml marshalled from the castor classes is saved in " + outputFile.getAbsoluteFile()));
            ((Writer)fileWriter).close();
        }
        catch (MarshalException me) {
            InventoryReportCalculator.log().fatal((Object)"MarshalException ", (Throwable)me);
            throw new InventoryCalculationException(me);
        }
        catch (ValidationException ve) {
            InventoryReportCalculator.log().fatal((Object)"Validation Exception ", (Throwable)ve);
            throw new InventoryCalculationException(ve);
        }
        catch (IOException ioe) {
            InventoryReportCalculator.log().fatal((Object)"IO Exception ", (Throwable)ioe);
            throw new InventoryCalculationException(ioe);
        }
    }
}

