/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.rancid.ConnectionProperties;
import org.opennms.rancid.InventoryNode;
import org.opennms.rancid.RWSClientApi;
import org.opennms.rancid.RancidApiException;
import org.opennms.rancid.RancidNode;
import org.opennms.report.configuration.ConfigurationCalculationException;
import org.opennms.report.configuration.GroupXSet;
import org.opennms.report.configuration.NodeSet;
import org.opennms.report.configuration.RwsRancidlistreport;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationReportCalculator
implements InitializingBean {
    String m_baseDir;
    private String m_outputFileName;
    ConnectionProperties m_cp;
    RWSConfig m_rwsConfig;
    String theDate;
    String user;
    Date reportRequestDate;
    RwsRancidlistreport rlist;

    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.m_outputFileName = outputFileName;
    }

    public String getTheDate() {
        return this.theDate;
    }

    public void setTheDate(String theDate) {
        this.theDate = theDate;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getReportRequestDate() {
        return this.reportRequestDate;
    }

    public void setReportRequestDate(Date reportRequestDate) {
        this.reportRequestDate = reportRequestDate;
    }

    public RWSConfig getRwsConfig() {
        return this.m_rwsConfig;
    }

    public void setRwsConfig(RWSConfig rwsConfig) {
        this.m_rwsConfig = rwsConfig;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
    }

    private static Logger log() {
        return Logger.getLogger((String)"Rancid");
    }

    public void afterPropertiesSet() throws Exception {
        RWSClientApi.init();
        this.m_cp = this.m_rwsConfig.getBase();
    }

    private List<String> getGroups() {
        try {
            return RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp).getResource();
        }
        catch (RancidApiException e) {
            ConfigurationReportCalculator.log().error((Object)("getGroups: has given exception " + e.getMessage() + ". Skipped"));
            return new ArrayList<String>();
        }
    }

    private List<String> getDeviceListOnGroup(String groupName) {
        try {
            return RWSClientApi.getRWSResourceDeviceList((ConnectionProperties)this.m_cp, (String)groupName).getResource();
        }
        catch (RancidApiException e) {
            ConfigurationReportCalculator.log().error((Object)("getDeviceListOnGroup: group [" + groupName + "]. Skipped"));
            return new ArrayList<String>();
        }
    }

    private List<String> getVersionListOnDevice(String deviceName, String groupName) {
        try {
            return RWSClientApi.getRWSResourceConfigList((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName).getResource();
        }
        catch (RancidApiException e) {
            ConfigurationReportCalculator.log().error((Object)("getVersionListOnDevice:  device has no inventory [" + deviceName + "]. " + e.getLocalizedMessage()));
            return new ArrayList<String>();
        }
    }

    private RancidNode getFullNode(String groupName, String deviceName) {
        try {
            return RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName);
        }
        catch (RancidApiException e) {
            ConfigurationReportCalculator.log().error((Object)("getFullNode:  device has no inventory [" + deviceName + "]. " + e.getLocalizedMessage()));
            return null;
        }
    }

    public void calculate() {
        this.rlist = new RwsRancidlistreport();
        this.rlist.setUser(this.user);
        this.rlist.setReportRequestDate(this.reportRequestDate.toString());
        SimpleDateFormat format = new SimpleDateFormat("yyyy/M/d");
        Date tmp_date = new Date();
        try {
            tmp_date = format.parse(this.theDate);
        }
        catch (ParseException pe) {
            tmp_date = Calendar.getInstance().getTime();
        }
        ConfigurationReportCalculator.log().debug((Object)("calculate:report date[" + tmp_date.toString() + "]"));
        this.rlist.setReportDate(tmp_date.toString());
        int totalGroups = 0;
        int groupsMatching = 0;
        int groupWithoutNodes = 0;
        int groupsWithNodesWithoutconfigurationAtAll = 0;
        int groupsWithNodesWithoutconfigurationAtReportDate = 0;
        for (String groupName : this.getGroups()) {
            ConfigurationReportCalculator.log().debug((Object)("calculate:report group [" + groupName + "]"));
            ++totalGroups;
            GroupXSet gs = new GroupXSet();
            gs.setGroupXSetName(groupName);
            int totalNodes = 0;
            int nodeMatching = 0;
            int nodesWithoutConfigurationAtAll = 0;
            int nodesWithoutConfigurationAtReportDate = 0;
            boolean groupHasDevices = false;
            boolean groupHasNodesWithoutconfigurationAtAll = false;
            boolean groupHasNodesWithoutconfigurationAtrequestDate = false;
            for (String deviceName : this.getDeviceListOnGroup(groupName)) {
                ++totalNodes;
                NodeSet ns = new NodeSet();
                ns.setDevicename(deviceName);
                ns.setGroupname(groupName);
                ConfigurationReportCalculator.log().debug((Object)("calculate:report device [" + deviceName + "]"));
                RancidNode rancidNode = this.getFullNode(groupName, deviceName);
                if (rancidNode == null) {
                    ns.setVersion("No Configurations found");
                    groupHasNodesWithoutconfigurationAtAll = true;
                    ++nodesWithoutConfigurationAtAll;
                    gs.addNodeSet(ns);
                    continue;
                }
                InventoryNode invNode = new InventoryNode(rancidNode);
                boolean found = false;
                for (String versionMatch : this.getVersionListOnDevice(deviceName, groupName)) {
                    invNode = (InventoryNode)rancidNode.getNodeVersions().get(versionMatch);
                    ConfigurationReportCalculator.log().debug((Object)("calculate:report parsing InventoryNode version[" + invNode.getVersionId() + "] date [" + invNode.getCreationDate() + "]"));
                    if (tmp_date.compareTo(invNode.getCreationDate()) <= 0) continue;
                    found = true;
                    ConfigurationReportCalculator.log().debug((Object)("calculate:report Date found is [" + invNode.getCreationDate() + "] version is [" + versionMatch + "]"));
                    break;
                }
                if (!found) {
                    ConfigurationReportCalculator.log().debug((Object)("calculate:report device has no inventory at this date[" + deviceName + "]"));
                    groupHasNodesWithoutconfigurationAtrequestDate = true;
                    ++nodesWithoutConfigurationAtReportDate;
                    ns.setVersion("No configuration found at Report Date");
                } else {
                    ns.setVersion(invNode.getVersionId());
                    ns.setConfigurationurl(invNode.getConfigurationUrl());
                    ns.setSwconfigurationurl(invNode.getSoftwareImageUrl());
                    ns.setStatus(rancidNode.getState());
                    ns.setCreationdate(invNode.getCreationDate().toString());
                    groupHasDevices = true;
                    ++nodeMatching;
                }
                gs.addNodeSet(ns);
            }
            gs.setTotalNodes(totalNodes);
            gs.setNodesMatching(nodeMatching);
            gs.setNodesWithoutconfigurationAtReportDate(nodesWithoutConfigurationAtReportDate);
            gs.setNodesWithoutconfigurationAtAll(nodesWithoutConfigurationAtAll);
            this.rlist.addGroupXSet(gs);
            if (groupHasDevices) {
                ++groupsMatching;
            } else {
                ++groupWithoutNodes;
            }
            if (groupHasDevices && groupHasNodesWithoutconfigurationAtAll) {
                ++groupsWithNodesWithoutconfigurationAtAll;
            }
            if (!groupHasDevices || !groupHasNodesWithoutconfigurationAtrequestDate) continue;
            ++groupsWithNodesWithoutconfigurationAtReportDate;
        }
        this.rlist.setTotalGroups(totalGroups);
        this.rlist.setGroupWithoutNodes(groupWithoutNodes);
        this.rlist.setGroupsMatching(groupsMatching);
        this.rlist.setGroupsWithNodesWithoutconfigurationAtAll(groupsWithNodesWithoutconfigurationAtAll);
        this.rlist.setGroupsWithNodesWithoutconfigurationAtReportDate(groupsWithNodesWithoutconfigurationAtReportDate);
    }

    public void writeXML() throws ConfigurationCalculationException {
        try {
            ConfigurationReportCalculator.log().debug((Object)"Writing the XML");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
            String datestamp = fmt.format(this.reportRequestDate);
            this.m_outputFileName = "/RANCIDLISTREPORT" + datestamp + ".xml";
            ConfigurationReportCalculator.log().debug((Object)("Report Store XML file: " + this.m_outputFileName));
            File reportFile = new File(this.m_baseDir, this.m_outputFileName);
            this.marshal(reportFile);
        }
        catch (ConfigurationCalculationException e) {
            ConfigurationReportCalculator.log().fatal((Object)"Unable to marshal report as XML");
            throw new ConfigurationCalculationException(e);
        }
    }

    public void marshal(File outputFile) throws ConfigurationCalculationException {
        try {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            Marshaller marshaller = new Marshaller((Writer)fileWriter);
            marshaller.setSuppressNamespaces(true);
            marshaller.marshal((Object)this.rlist);
            ConfigurationReportCalculator.log().debug((Object)("The xml marshalled from the castor classes is saved in " + outputFile.getAbsoluteFile()));
            ((Writer)fileWriter).close();
        }
        catch (MarshalException me) {
            ConfigurationReportCalculator.log().fatal((Object)"MarshalException ", (Throwable)me);
            throw new ConfigurationCalculationException(me);
        }
        catch (ValidationException ve) {
            ConfigurationReportCalculator.log().fatal((Object)"Validation Exception ", (Throwable)ve);
            throw new ConfigurationCalculationException(ve);
        }
        catch (IOException ioe) {
            ConfigurationReportCalculator.log().fatal((Object)"IO Exception ", (Throwable)ioe);
            throw new ConfigurationCalculationException(ioe);
        }
    }
}

