/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.datablock;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.logger.Log4JLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.apache.fop.apps.Driver;
import org.apache.fop.messaging.MessageHandler;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.xml.sax.InputSource;

public class PDFWriter {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    Driver m_driver;
    String m_xslSource = null;

    public PDFWriter(String xslSource) {
        this.m_xslSource = xslSource;
    }

    public void generateHTML(FileReader xml, OutputStream fotFileName) throws MarshalException, ValidationException, IOException, Exception {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        try {
            if (this.log().isInfoEnabled()) {
                this.log().info((Object)("XSL File " + this.m_xslSource));
            }
            FileReader xsl = new FileReader(this.m_xslSource);
            TransformerFactory tfact = TransformerFactory.newInstance();
            Transformer processor = tfact.newTransformer(new StreamSource(xsl));
            processor.transform(new StreamSource(xml), new StreamResult(fotFileName));
            xml = null;
            fotFileName.close();
            fotFileName = null;
        }
        catch (Exception e) {
            this.log().fatal((Object)("Exception: " + e), (Throwable)e);
            throw e;
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(PDFWriter.class);
    }

    public void generatePDF(FileReader xml, OutputStream pdfWriter, String fotFileName) throws MarshalException, ValidationException, IOException, Exception {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Log4JLogger avalonLogger = new Log4JLogger(this.log());
        try {
            if (this.log().isInfoEnabled()) {
                this.log().info((Object)("XSL File " + this.m_xslSource));
            }
            FileReader xsl = new FileReader(this.m_xslSource);
            File file = new File(fotFileName);
            FileWriter fot = new FileWriter(file);
            TransformerFactory tfact = TransformerFactory.newInstance();
            Transformer processor = tfact.newTransformer(new StreamSource(xsl));
            processor.transform(new StreamSource(xml), new StreamResult(fot));
            if (this.log().isInfoEnabled()) {
                this.log().info((Object)("FOT generated is saved in " + fotFileName));
            }
            xml = null;
            NullLogger nullLogger = new NullLogger();
            MessageHandler.setScreenLogger((Logger)nullLogger);
            MessageHandler.setOutputMethod((int)3);
            fot.close();
            fot = null;
            FileReader reader = new FileReader(file);
            InputSource dataSource = new InputSource(reader);
            this.m_driver = new Driver(dataSource, pdfWriter);
            this.m_driver.setLogger((Logger)avalonLogger);
            this.m_driver.setRenderer(1);
            this.m_driver.run();
            Runtime runn = Runtime.getRuntime();
            runn.exec("rm " + fotFileName);
        }
        catch (Exception e) {
            this.log().fatal((Object)("Exception: " + e), (Throwable)e);
            throw e;
        }
    }
}

