/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.datablock;

import java.util.ArrayList;
import java.util.List;
import org.opennms.report.datablock.Outage;
import org.opennms.report.datablock.OutageSince;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutageSvcTimesList
extends ArrayList<Outage> {
    private static final long serialVersionUID = -4701288568774571119L;
    private long m_outTimeSince = -1L;
    private long m_outTime = 0L;
    private long m_busOutTime;

    public OutageSvcTimesList() {
    }

    public OutageSvcTimesList(int initialCapacity) {
        super(initialCapacity);
    }

    public void addSvcTime(long losttime, long regainedtime) {
        if (regainedtime < losttime) {
            return;
        }
        this.add(new Outage(losttime, regainedtime));
    }

    public void addSvcTime(long losttime) {
        this.add(new Outage(losttime));
    }

    public long getDownTime(long curTime, long rollingWindow) {
        long startTime;
        this.m_outTimeSince = startTime = curTime - rollingWindow;
        this.m_outTime = 0L;
        for (Outage svcTime : this) {
            long outtime = svcTime.getDownTime(curTime, rollingWindow);
            if (outtime <= 0L) continue;
            this.m_outTime += outtime;
        }
        return this.m_outTime;
    }

    public List<OutageSince> getServiceOutages(String nodeName, long curTime, long rollingWindow) {
        if (nodeName == null) {
            return null;
        }
        long startTime = curTime - rollingWindow;
        ArrayList<OutageSince> retList = new ArrayList<OutageSince>();
        for (Outage svcTime : this) {
            if (svcTime.getRegainedTime() > 0L ? svcTime.getRegainedTime() <= startTime : svcTime.getLostTime() > curTime) continue;
            long outFrom = startTime;
            if (startTime < svcTime.getLostTime()) {
                outFrom = svcTime.getLostTime();
            }
            long outtime = svcTime.getDownTime(curTime, rollingWindow);
            OutageSince outageSince = null;
            if (outtime > 0L) {
                outageSince = new OutageSince(nodeName, outFrom, outtime);
            }
            if (outageSince == null) continue;
            retList.add(outageSince);
        }
        return retList;
    }

    @Override
    public String toString() {
        String retVal = "";
        for (Outage outage : this) {
            retVal = retVal + "\n" + outage;
        }
        return retVal;
    }
}

