/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.availability.render;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.logger.Log4JLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.apache.fop.apps.Driver;
import org.apache.fop.messaging.MessageHandler;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.report.availability.render.ReportRenderException;
import org.opennms.report.availability.render.ReportRenderer;
import org.springframework.core.io.Resource;

public class PDFReportRenderer
implements ReportRenderer {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private String m_outputFileName;
    private String m_inputFileName;
    private Resource m_xsltResource;
    private String m_baseDir;

    public void render() throws ReportRenderException {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance(PDFReportRenderer.class);
        Log4JLogger avalonLogger = new Log4JLogger(log);
        try {
            log.debug((Object)("XSL File " + this.m_xsltResource.getDescription()));
            FileReader xsl = new FileReader(this.m_xsltResource.getFile());
            log.debug((Object)("Base directory " + this.m_baseDir));
            log.debug((Object)("file to render" + this.m_inputFileName));
            FileReader xml = new FileReader(this.m_baseDir + this.m_inputFileName);
            log.debug((Object)("ouput File " + this.m_outputFileName));
            FileOutputStream pdfOutputStream = new FileOutputStream(new File(this.m_baseDir + this.m_outputFileName));
            NullLogger nullLogger = new NullLogger();
            MessageHandler.setScreenLogger((Logger)nullLogger);
            MessageHandler.setOutputMethod((int)3);
            Driver driver = new Driver();
            driver.setLogger((Logger)avalonLogger);
            driver.setOutputStream((OutputStream)pdfOutputStream);
            driver.setRenderer(1);
            TransformerFactory tfact = TransformerFactory.newInstance();
            Transformer transformer = tfact.newTransformer(new StreamSource(xsl));
            transformer.transform(new StreamSource(xml), new SAXResult(driver.getContentHandler()));
            pdfOutputStream.close();
        }
        catch (IOException ioe) {
            log.fatal((Object)"IOException ", (Throwable)ioe);
            throw new ReportRenderException(ioe);
        }
        catch (TransformerConfigurationException tce) {
            log.fatal((Object)"transformerConfigurationException ", (Throwable)tce);
            throw new ReportRenderException(tce);
        }
        catch (TransformerException te) {
            log.fatal((Object)"TransformerException ", (Throwable)te);
            throw new ReportRenderException(te);
        }
    }

    public void setXsltResource(Resource xsltResource) {
        this.m_xsltResource = xsltResource;
    }

    public void setOutputFileName(String outputFileName) {
        this.m_outputFileName = outputFileName;
    }

    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    public void setInputFileName(String inputFileName) {
        this.m_inputFileName = inputFileName;
    }

    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }
}

