/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.availability.render;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.report.availability.render.ReportRenderException;
import org.opennms.report.availability.render.ReportRenderer;
import org.springframework.core.io.Resource;

public class HTMLReportRenderer
implements ReportRenderer {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private String m_outputFileName;
    private String m_inputFileName;
    private String m_baseDir;
    private Resource m_xsltResource;

    public void render() throws ReportRenderException {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        Category log = ThreadCategory.getInstance(HTMLReportRenderer.class);
        try {
            log.debug((Object)("XSL File " + this.m_xsltResource.getDescription()));
            FileReader xsl = new FileReader(this.m_xsltResource.getFile());
            log.debug((Object)("file to render" + this.m_inputFileName));
            FileReader xml = new FileReader(this.m_baseDir + this.m_inputFileName);
            log.debug((Object)("ouput File " + this.m_outputFileName));
            FileWriter htmlWriter = new FileWriter(this.m_baseDir + this.m_outputFileName);
            TransformerFactory tfact = TransformerFactory.newInstance();
            Transformer processor = tfact.newTransformer(new StreamSource(xsl));
            processor.transform(new StreamSource(xml), new StreamResult(htmlWriter));
            htmlWriter.close();
            ((Reader)xsl).close();
            ((Reader)xml).close();
        }
        catch (IOException ioe) {
            log.fatal((Object)"IOException ", (Throwable)ioe);
            throw new ReportRenderException(ioe);
        }
        catch (TransformerConfigurationException tce) {
            log.fatal((Object)"ransformerConfigurationException ", (Throwable)tce);
            throw new ReportRenderException(tce);
        }
        catch (TransformerException te) {
            log.fatal((Object)"TransformerException ", (Throwable)te);
            throw new ReportRenderException(te);
        }
    }

    public void setXsltResource(Resource xsltResource) {
        this.m_xsltResource = xsltResource;
    }

    public void setOutputFileName(String outputFileName) {
        this.m_outputFileName = outputFileName;
    }

    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    public void setInputFileName(String intputFileName) {
        this.m_inputFileName = intputFileName;
    }

    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }
}

