/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.availability;

import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.report.availability.AvailabilityCalculationException;
import org.opennms.report.availability.AvailabilityCalculator;
import org.opennms.report.availability.AvailabilityReport;
import org.opennms.report.availability.ReportMailer;
import org.opennms.report.availability.render.ReportRenderException;
import org.opennms.report.availability.render.ReportRenderer;

public class AvailabilityReportRunner
implements Runnable {
    private String m_logo;
    private String m_categoryName;
    private String m_monthFormat;
    private String m_format;
    private String m_email;
    private Date m_periodEndDate;
    private AvailabilityCalculator m_classicCalculator;
    private AvailabilityCalculator m_calendarCalculator;
    private ReportRenderer m_htmlReportRenderer;
    private ReportRenderer m_pdfReportRenderer;
    private ReportRenderer m_svgReportRenderer;
    private Category log;
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private static final String HTML_FORMAT = "HTML";
    private static final String SVG_FORMAT = "SVG";
    private static final String PDF_FORMAT = "PDF";

    public AvailabilityReportRunner() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(AvailabilityReport.class);
        this.log.debug((Object)"initialised AvailablilityReportMailer");
    }

    public void run() {
        ReportRenderer renderer;
        AvailabilityCalculator calculator = this.m_monthFormat == null || this.m_monthFormat.equals("") || this.m_monthFormat.equals("classic") ? this.m_classicCalculator : this.m_calendarCalculator;
        calculator.setCalendar(new GregorianCalendar());
        calculator.setCategoryName(this.m_categoryName);
        calculator.setLogoURL(this.m_logo);
        calculator.setPeriodEndDate(this.m_periodEndDate);
        if (this.m_format == null || this.m_format.equals(SVG_FORMAT)) {
            this.log.debug((Object)"report will be rendered as PDF with embedded SVG");
            renderer = this.m_svgReportRenderer;
            calculator.setReportFormat(SVG_FORMAT);
        } else if (this.m_format.equals(PDF_FORMAT)) {
            this.log.debug((Object)"report will be rendered as PDF");
            renderer = this.m_pdfReportRenderer;
            calculator.setReportFormat(PDF_FORMAT);
        } else {
            this.log.debug((Object)"report will be rendered as html");
            renderer = this.m_htmlReportRenderer;
            calculator.setReportFormat(HTML_FORMAT);
        }
        try {
            this.log.debug((Object)"Starting Availability Report Calculations");
            calculator.calculate();
            calculator.writeLocateableXML();
            String outputFile = calculator.getOutputFileName();
            this.log.debug((Object)("Written Availability Report as XML to " + outputFile));
            renderer.setInputFileName(outputFile);
            this.log.debug((Object)("rendering XML " + outputFile + " as " + renderer.getOutputFileName()));
            renderer.render();
            ReportMailer mailer = new ReportMailer(this.m_email, renderer.getBaseDir() + renderer.getOutputFileName());
            mailer.send();
        }
        catch (AvailabilityCalculationException ce) {
            this.log.fatal((Object)"Unable to calculate report data ", (Throwable)ce);
        }
        catch (ReportRenderException re) {
            this.log.fatal((Object)"Unable to render report ", (Throwable)re);
        }
        catch (IOException ioe) {
            this.log.fatal((Object)"Unable to render report ", (Throwable)ioe);
        }
    }

    public void setCalendarCalculator(AvailabilityCalculator calculator) {
        this.m_calendarCalculator = calculator;
    }

    public void setClassicCalculator(AvailabilityCalculator calulator) {
        this.m_classicCalculator = calulator;
    }

    public void setHtmlReportRenderer(ReportRenderer reportRenderer) {
        this.m_htmlReportRenderer = reportRenderer;
    }

    public void setPdfReportRenderer(ReportRenderer reportRenderer) {
        this.m_pdfReportRenderer = reportRenderer;
    }

    public void setSvgReportRenderer(ReportRenderer reportRenderer) {
        this.m_svgReportRenderer = reportRenderer;
    }

    public void setCategoryName(String name) {
        this.m_categoryName = name;
    }

    public void setEmail(String m_email) {
        this.m_email = m_email;
    }

    public void setFormat(String m_format) {
        this.m_format = m_format;
    }

    public void setLogo(String m_logo) {
        this.m_logo = m_logo;
    }

    public void setMonthFormat(String format) {
        this.m_monthFormat = format;
    }

    public void setPeriodEndDate(Date date) {
        this.m_periodEndDate = date;
    }
}

