/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.datablock;

import org.opennms.report.datablock.Outage;
import org.opennms.report.datablock.OutageSvcTimesList;
import org.opennms.report.datablock.StandardNamedObject;

public class Service
extends StandardNamedObject {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private OutageSvcTimesList m_outageList;
    private double m_percentAvail;
    private double m_percentBusAvail;
    private long m_downTime;
    private long m_busDownTime;
    private long m_monitoredTime;
    private long m_monitoredBusTime;

    public Service() {
        this.m_outageList = new OutageSvcTimesList();
    }

    public Service(String name) {
        this.setName(name);
        this.m_outageList = new OutageSvcTimesList();
    }

    public Service(String name, OutageSvcTimesList outages) {
        this.setName(name);
        this.m_outageList = outages != null ? outages : new OutageSvcTimesList();
    }

    public Service(OutageSvcTimesList outages) {
        if (outages != null) {
            this.m_outageList = outages;
        }
    }

    public double getDownTime() {
        return this.m_downTime;
    }

    public long getBusDownTime() {
        return this.m_busDownTime;
    }

    public double getPercentAvail() {
        return this.m_percentAvail;
    }

    public double getBusPercentAvail() {
        return this.m_percentBusAvail;
    }

    public long getMonitoredTime() {
        return this.m_monitoredTime;
    }

    public long getMonitoredBusTime() {
        return this.m_monitoredBusTime;
    }

    public OutageSvcTimesList getOutages() {
        return this.m_outageList;
    }

    public void addOutage(long lost, long regained) {
        if (this.m_outageList == null) {
            this.m_outageList = new OutageSvcTimesList();
        }
        this.m_outageList.addSvcTime(lost, regained);
    }

    public void addOutage(long lost) {
        if (this.m_outageList == null) {
            this.m_outageList = new OutageSvcTimesList();
        }
        this.m_outageList.addSvcTime(lost);
    }

    public void addOutage(Outage outage) {
        if (this.m_outageList == null) {
            this.m_outageList = new OutageSvcTimesList();
        }
        this.m_outageList.addSvcTime(outage.getLostTime(), outage.getRegainedTime());
    }

    public long getDownTime(long currentTime, long rollingWindow) {
        if (this.m_outageList != null) {
            return this.m_outageList.getDownTime(currentTime, rollingWindow);
        }
        return 0L;
    }

    public double getPercentAvail(long currentTime, long rollingWindow) {
        double percent;
        this.m_downTime = this.getDownTime(currentTime, rollingWindow);
        double outage = 1.0 * (double)this.m_downTime;
        double denom = 1.0 * (double)rollingWindow;
        this.m_percentAvail = percent = 100.0 * (1.0 - outage / denom);
        this.m_monitoredTime = rollingWindow;
        return percent;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof String) {
                return ((String)obj).equals(this.getName());
            }
            if (obj instanceof Service) {
                return obj == this;
            }
        }
        return false;
    }
}

