/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.availability;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CatFactory;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.config.categories.Catinfo;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.report.availability.AvailCalculations;
import org.opennms.report.availability.CatSections;
import org.opennms.report.availability.Categories;
import org.opennms.report.availability.Category;
import org.opennms.report.availability.Created;
import org.opennms.report.availability.Report;
import org.opennms.report.availability.Section;
import org.opennms.report.datablock.Node;
import org.opennms.report.datablock.Outage;
import org.opennms.report.datablock.OutageSvcTimesList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailabilityData {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private static final String DEFAULT_FORMAT = "PDF";
    static Connection m_availConn;
    private List<Node> m_nodes;
    private String m_commonRule;
    private long m_endTime;
    private long m_12MonthsBack;
    private long m_lastMonthEndTime;
    private int m_daysInLastMonth;
    CatFactory m_catFactory;
    private int m_sectionIndex = 0;

    public AvailabilityData(String categoryName, Report report, String monthFormat, Calendar calendar, String startMonth, String startDate, String startYear) throws IOException, MarshalException, ValidationException, Exception {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, Integer.parseInt(startDate));
        cal.set(2, Integer.parseInt(startMonth));
        cal.set(1, Integer.parseInt(startYear));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        this.generateData(categoryName, report, DEFAULT_FORMAT, monthFormat, calendar, new Date(cal.getTimeInMillis()));
    }

    public AvailabilityData(String categoryName, Report report, String format, String monthFormat, Calendar calendar, String startMonth, String startDate, String startYear) throws IOException, MarshalException, ValidationException, Exception {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, Integer.parseInt(startDate));
        cal.set(2, Integer.parseInt(startMonth));
        cal.set(1, Integer.parseInt(startYear));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        this.generateData(categoryName, report, format, monthFormat, calendar, new Date(cal.getTimeInMillis()));
    }

    public AvailabilityData(String categoryName, Report report, String format, String monthFormat, Calendar calendar, Date periodEndDate) throws IOException, MarshalException, ValidationException, Exception {
        this.generateData(categoryName, report, format, monthFormat, calendar, periodEndDate);
    }

    private void generateData(String categoryName, Report report, String format, String monthFormat, Calendar calendar, Date periodEndDate) throws IOException, MarshalException, ValidationException, Exception {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)"Inside AvailabilityData");
        this.m_nodes = new ArrayList<Node>();
        this.initializeInterval(calendar, periodEndDate);
        Catinfo config = null;
        try {
            CategoryFactory.init();
            this.m_catFactory = CategoryFactory.getInstance();
            config = this.m_catFactory.getConfig();
        }
        catch (IOException e) {
            log.fatal((Object)"Initializing CategoryFactory", (Throwable)e);
            throw e;
        }
        catch (MarshalException e) {
            log.fatal((Object)"Initializing CategoryFactory", (Throwable)e);
            throw e;
        }
        catch (ValidationException e) {
            log.fatal((Object)"Initializing CategoryFactory", (Throwable)e);
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CATEGORY " + categoryName));
        }
        if (categoryName.equals("") || categoryName.equals("all")) {
            int catCount = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)("catCount " + catCount));
            }
            for (Categorygroup cg : config.getCategorygroupCollection()) {
                org.opennms.netmgt.config.categories.Categories cats = cg.getCategories();
                for (org.opennms.netmgt.config.categories.Category cat : cats.getCategoryCollection()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("CATEGORY " + cat.getLabel()));
                    }
                    this.populateDataStructures(cat, report, format, monthFormat, ++catCount);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("catCount " + catCount));
            }
        } else {
            org.opennms.netmgt.config.categories.Category cat = this.m_catFactory.getCategory(categoryName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("CATEGORY - now populating data structures " + cat.getLabel()));
            }
            this.populateDataStructures(cat, report, format, monthFormat, 1);
        }
        SimpleDateFormat simplePeriod = new SimpleDateFormat("MMMMMMMMMMM dd, yyyy");
        String reportPeriod = simplePeriod.format(new Date(this.m_12MonthsBack)) + " - " + simplePeriod.format(new Date(this.m_endTime));
        Created created = report.getCreated();
        if (created == null) {
            created = new Created();
        }
        created.setPeriod(reportPeriod);
        report.setCreated(created);
        if (log.isDebugEnabled()) {
            log.debug((Object)"After availCalculations");
        }
    }

    private void populateDataStructures(org.opennms.netmgt.config.categories.Category cat, Report report, String format, String monthFormat, int catIndex) throws Exception {
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Inside populate data Structures" + catIndex));
        }
        report.setCatCount(catIndex);
        log.debug((Object)"Inside populate data Structures");
        try {
            String categoryName = cat.getLabel();
            this.m_commonRule = this.m_catFactory.getEffectiveRule(categoryName);
            ArrayList<String> monitoredServices = new ArrayList<String>(cat.getServiceCollection());
            this.populateNodesFromDB(cat, monitoredServices);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Nodes " + this.m_nodes));
            }
            ListIterator<Node> cleanNodes = this.m_nodes.listIterator();
            while (cleanNodes.hasNext()) {
                Node node = cleanNodes.next();
                if (node == null || node.hasOutages()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing node: " + node));
                }
                cleanNodes.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cleaned Nodes " + this.m_nodes));
            }
            TreeMap<Double, List<String>> topOffenders = this.getPercentNode();
            if (log.isDebugEnabled()) {
                log.debug((Object)("TOP OFFENDERS " + topOffenders));
            }
            if (this.m_nodes.size() <= 0) {
                this.m_nodes = null;
            }
            if (this.m_nodes != null) {
                AvailCalculations availCalculations = new AvailCalculations(this.m_nodes, this.m_endTime, this.m_lastMonthEndTime, monitoredServices, report, topOffenders, cat.getWarning(), cat.getNormal(), cat.getComment(), cat.getLabel(), format, monthFormat, catIndex, this.m_sectionIndex);
                this.m_sectionIndex = availCalculations.getSectionIndex();
                report.setSectionCount(this.m_sectionIndex - 1);
            } else {
                Category category = new Category();
                category.setCatComments(cat.getComment());
                category.setCatName(cat.getLabel());
                category.setCatIndex(catIndex);
                category.setNodeCount(0);
                category.setIpaddrCount(0);
                category.setServiceCount(0);
                Section section = new Section();
                section.setSectionIndex(this.m_sectionIndex);
                CatSections catSections = new CatSections();
                catSections.addSection(section);
                category.addCatSections(catSections);
                Categories categories = report.getCategories();
                categories.addCategory(category);
                report.setCategories(categories);
                report.setSectionCount(this.m_sectionIndex);
                ++this.m_sectionIndex;
            }
        }
        catch (Exception e) {
            log.fatal((Object)"Exception has occured", (Throwable)e);
            throw e;
        }
    }

    public void initializeInterval(Calendar calendar, Date periodEndDate) {
        GregorianCalendar tempCal = new GregorianCalendar();
        tempCal.setTime(periodEndDate);
        ((Calendar)tempCal).add(5, -1);
        tempCal.set(11, 23);
        tempCal.set(12, 59);
        tempCal.set(13, 59);
        tempCal.set(14, 999);
        this.m_endTime = tempCal.getTimeInMillis();
        ((Calendar)tempCal).add(1, -1);
        tempCal.set(5, 1);
        tempCal.set(11, 0);
        tempCal.set(12, 0);
        tempCal.set(13, 0);
        tempCal.set(14, 0);
        this.m_12MonthsBack = tempCal.getTimeInMillis();
        tempCal.setTimeInMillis(this.m_endTime);
        ((Calendar)tempCal).add(2, -1);
        this.m_daysInLastMonth = ((Calendar)tempCal).getActualMaximum(5);
        tempCal.set(5, this.m_daysInLastMonth);
        tempCal.set(11, 23);
        tempCal.set(12, 59);
        tempCal.set(13, 59);
        tempCal.set(14, 999);
        this.m_lastMonthEndTime = tempCal.getTimeInMillis();
    }

    public List<Node> getNodes() {
        return this.m_nodes;
    }

    public void initialiseConnection() throws IOException, MarshalException, ValidationException, ClassNotFoundException, SQLException {
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        try {
            DataSourceFactory.init();
            m_availConn = DataSourceFactory.getInstance().getConnection();
        }
        catch (MarshalException e) {
            log.fatal((Object)"initialize: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            log.fatal((Object)"initialize: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            log.fatal((Object)"initialize: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)"initialize: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            log.fatal((Object)"initialize: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            log.fatal((Object)"initialize: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public void closeConnection() {
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        if (m_availConn != null) {
            try {
                m_availConn.close();
                m_availConn = null;
            }
            catch (Throwable t) {
                log.warn((Object)"initialize: an exception occured while closing the JDBC connection", t);
            }
        }
    }

    public TreeMap<Double, List<String>> getPercentNode() {
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        int days = this.m_daysInLastMonth;
        long endTime = this.m_lastMonthEndTime;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(endTime);
        ((Calendar)cal).add(5, -1 * days);
        long rollingWindow = endTime - cal.getTime().getTime();
        long startTime = cal.getTime().getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getPercentNode: Start time " + new Date(startTime)));
            log.debug((Object)("getPercentNode: End time " + new Date(endTime)));
        }
        TreeMap<Double, List<String>> percentNode = new TreeMap<Double, List<String>>();
        for (Node node : this.m_nodes) {
            if (node == null) continue;
            double percent = node.getPercentAvail(endTime, rollingWindow);
            String nodeName = node.getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node " + nodeName + " " + percent + "%"));
            }
            if (!(percent < 100.0)) continue;
            List<String> nodeNames = percentNode.get(new Double(percent));
            if (nodeNames == null) {
                nodeNames = new ArrayList<String>();
            }
            nodeNames.add(nodeName);
            percentNode.put(new Double(percent), nodeNames);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Percent node " + percentNode));
        }
        return percentNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateNodesFromDB(org.opennms.netmgt.config.categories.Category cat, List<String> monitoredServices) throws SQLException, FilterParseException, Exception {
        this.m_nodes = new ArrayList<Node>();
        org.apache.log4j.Category log = ThreadCategory.getInstance(AvailabilityData.class);
        log.debug((Object)"in populateNodesFromDB");
        this.initialiseConnection();
        PreparedStatement servicesGetStmt = m_availConn.prepareStatement("SELECT ifServices.serviceid, service.servicename FROM ifServices, ipInterface, node, service WHERE ((ifServices.nodeid = ? ) AND (ifServices.ipaddr = ?) AND ipinterface.ipaddr = ? AND ipinterface.isManaged ='M' AND (ifServices.serviceid = service.serviceid) AND (ifservices.status = 'A')) AND node.nodeid = ? AND node.nodetype = 'A'");
        PreparedStatement ipInfoGetStmt = m_availConn.prepareStatement("SELECT  node.nodeid, node.nodelabel FROM node, ipInterface WHERE ((ipInterface.ipaddr = ?) AND (ipInterface.nodeid = node.nodeid) AND (node.nodeType = 'A') AND (ipinterface.ismanaged = 'M') )");
        PreparedStatement outagesGetStmt = m_availConn.prepareStatement("SELECT ifLostService, ifRegainedService from outages where  (outages.nodeid = ?) AND (outages.ipaddr = ?) AND (outages.serviceid = ?)");
        String filterRule = this.m_commonRule;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Category: " + filterRule));
        }
        String ip22 = null;
        ResultSet ipRS = null;
        try {
            try {
                List nodeIPs = FilterDaoFactory.getInstance().getIPList(filterRule);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Number of IPs satisfying rule: " + nodeIPs.size()));
                }
                for (String ip22 : nodeIPs) {
                    ipInfoGetStmt.setString(1, ip22);
                    ipRS = ipInfoGetStmt.executeQuery();
                    while (ipRS.next()) {
                        int nodeid = ipRS.getInt(1);
                        String nodeName = ipRS.getString(2);
                        ResultSet svcRS = null;
                        servicesGetStmt.setLong(1, nodeid);
                        servicesGetStmt.setString(2, ip22);
                        servicesGetStmt.setString(3, ip22);
                        servicesGetStmt.setLong(4, nodeid);
                        svcRS = servicesGetStmt.executeQuery();
                        while (svcRS.next()) {
                            int svcid = svcRS.getInt(1);
                            String svcname = svcRS.getString(2);
                            if (!monitoredServices.isEmpty() && !monitoredServices.contains(svcname)) continue;
                            OutageSvcTimesList outageSvcTimesList = new OutageSvcTimesList();
                            this.getOutagesNodeIpSvc(nodeid, nodeName, ip22, svcid, svcname, outageSvcTimesList, outagesGetStmt);
                        }
                        try {
                            if (svcRS == null) continue;
                            svcRS.close();
                        }
                        catch (Exception e) {
                            log.fatal((Object)"Exception while closing the services result set", (Throwable)e);
                            throw e;
                        }
                    }
                }
                Object var19_22 = null;
            }
            catch (SQLException e) {
                log.fatal((Object)("Unable to get node list for category '" + cat.getLabel() + "'"), (Throwable)e);
                throw e;
            }
            catch (FilterParseException e) {
                log.fatal((Object)("Unable to get node list for category '" + cat.getLabel() + "'"), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.fatal((Object)("Unable to get node list for category '" + cat.getLabel() + "'"), (Throwable)e);
                throw new Exception("Unable to get node list for category '" + cat.getLabel() + "': " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            try {
                if (ipRS != null) {
                    ipRS.close();
                }
                if (servicesGetStmt != null) {
                    servicesGetStmt.close();
                }
                if (ipInfoGetStmt != null) {
                    ipInfoGetStmt.close();
                }
                if (outagesGetStmt != null) {
                    outagesGetStmt.close();
                }
                if (m_availConn == null) throw throwable;
                this.closeConnection();
                throw throwable;
            }
            catch (Exception e) {
                log.fatal((Object)("Exception while closing the ip get node info result set.  IP: " + ip22), (Throwable)e);
                throw e;
            }
        }
        try {}
        catch (Exception e) {
            log.fatal((Object)("Exception while closing the ip get node info result set.  IP: " + ip22), (Throwable)e);
            throw e;
        }
        if (ipRS != null) {
            ipRS.close();
        }
        if (servicesGetStmt != null) {
            servicesGetStmt.close();
        }
        if (ipInfoGetStmt != null) {
            ipInfoGetStmt.close();
        }
        if (outagesGetStmt != null) {
            outagesGetStmt.close();
        }
        if (m_availConn == null) return;
        this.closeConnection();
    }

    private void getOutagesNodeIpSvc(int nodeid, String nodeName, String ipaddr, int serviceid, String serviceName, OutageSvcTimesList outageSvcTimesList, PreparedStatement outagesGetStmt) throws SQLException {
        org.apache.log4j.Category log = ThreadCategory.getInstance(AvailabilityData.class);
        try {
            outagesGetStmt.setInt(1, nodeid);
            outagesGetStmt.setString(2, ipaddr);
            outagesGetStmt.setInt(3, serviceid);
            ResultSet rs = outagesGetStmt.executeQuery();
            if (this.m_nodes != null && this.m_nodes.size() > 0) {
                ListIterator<Node> lstIter = this.m_nodes.listIterator();
                boolean foundFlag = false;
                Node oldNode = null;
                while (lstIter.hasNext()) {
                    oldNode = lstIter.next();
                    if (oldNode == null || oldNode.getNodeID() != nodeid) continue;
                    foundFlag = true;
                    break;
                }
                if (!foundFlag) {
                    Node newNode = new Node(nodeName, nodeid);
                    newNode.addInterface(ipaddr, serviceName);
                    this.m_nodes.add(newNode);
                } else {
                    oldNode.addInterface(ipaddr, serviceName);
                }
            } else {
                Node newNode = new Node(nodeName, nodeid);
                newNode.addInterface(ipaddr, serviceName);
                this.m_nodes.add(newNode);
            }
            while (rs.next()) {
                Timestamp lost = rs.getTimestamp(1);
                Timestamp regained = rs.getTimestamp(2);
                long losttime = lost.getTime();
                long regainedtime = 0L;
                if (regained != null) {
                    regainedtime = regained.getTime();
                }
                if (regainedtime > 0L ? regainedtime <= this.m_12MonthsBack || losttime >= this.m_endTime : losttime >= this.m_endTime) continue;
                Outage outage = new Outage(losttime, regainedtime);
                outageSvcTimesList.add(outage);
                this.addNode(nodeName, nodeid, ipaddr, serviceName, losttime, regainedtime);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.fatal((Object)"Error has occured while getting the outages ", (Throwable)e);
            throw e;
        }
    }

    public void addNode(String nodeName, int nodeid, String ipaddr, String serviceid, long losttime, long regainedtime) {
        if (this.m_nodes != null) {
            if (this.m_nodes.size() <= 0) {
                Node newNode = new Node(nodeName, nodeid);
                if (losttime > 0L) {
                    if (regainedtime > 0L) {
                        newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                    } else {
                        newNode.addInterface(ipaddr, serviceid, losttime);
                    }
                } else {
                    newNode.addInterface(ipaddr, serviceid);
                }
                this.m_nodes.add(newNode);
                return;
            }
            Node newNode = null;
            boolean foundFlag = false;
            ListIterator<Node> lstIter = this.m_nodes.listIterator();
            while (lstIter.hasNext()) {
                newNode = lstIter.next();
                if (newNode.getNodeID() != nodeid) continue;
                foundFlag = true;
                break;
            }
            if (!foundFlag) {
                newNode = new Node(nodeName, nodeid);
                if (losttime > 0L) {
                    if (regainedtime > 0L) {
                        newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                    } else {
                        newNode.addInterface(ipaddr, serviceid, losttime);
                    }
                } else {
                    newNode.addInterface(ipaddr, serviceid);
                }
                this.m_nodes.add(newNode);
                return;
            }
            if (losttime > 0L) {
                if (regainedtime > 0L) {
                    newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                } else {
                    newNode.addInterface(ipaddr, serviceid, losttime);
                }
            } else {
                newNode.addInterface(ipaddr, serviceid);
            }
            return;
        }
        this.m_nodes = new ArrayList<Node>();
    }
}

