/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.reporting.service;

import java.util.List;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.reportd.Report;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.ReportdConfigurationDao;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.reporting.service.ReportDeliveryException;
import org.opennms.netmgt.reporting.service.ReportDeliveryService;
import org.opennms.netmgt.reporting.service.ReportRunException;
import org.opennms.netmgt.reporting.service.ReportScheduler;
import org.opennms.netmgt.reporting.service.ReportService;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.util.Assert;

@EventListener(name="Reportd:EventListener")
public class Reportd
implements SpringServiceDaemon {
    public static final String NAME = "Reportd";
    private volatile EventForwarder m_eventForwarder;
    private ReportScheduler m_reportScheduler;
    private ReportService m_reportService;
    private ReportDeliveryService m_reportDeliveryService;
    private ReportdConfigurationDao m_reportConfigurationDao;
    private String reportDirectory;

    public void start() throws Exception {
        this.reportDirectory = this.m_reportConfigurationDao.getStorageDirectory();
        this.m_reportScheduler.start();
    }

    public void destroy() throws Exception {
        this.m_reportScheduler.destroy();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_eventForwarder, (String)"No Event Forwarder Set");
        Assert.notNull((Object)this.m_reportScheduler, (String)"No Report Scheduler Set");
        Assert.notNull((Object)this.m_reportService, (String)"No Report service set");
        Assert.notNull((Object)this.m_reportDeliveryService, (String)"No Delivery service set");
        Assert.notNull((Object)this.m_reportConfigurationDao, (String)"NoConfiguration DAO Defined");
    }

    public void runReport(String reportName) {
        LogUtils.infof((Object)this, (String)"Running report by name: (%s).", (Object[])new Object[]{reportName});
        this.runReport(this.m_reportConfigurationDao.getReport(reportName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(Report report) {
        String originalName = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)NAME);
            LogUtils.debugf((Object)this, (String)"reportd -- running job %s", (Object[])new Object[]{report.getReportName()});
            String fileName = this.m_reportService.runReport(report, this.reportDirectory);
            if (report.getRecipientCount() > 0) {
                LogUtils.debugf((Object)this, (String)"reportd -- delivering report %s to %d recipients", (Object[])new Object[]{report.getReportName(), report.getRecipientCount()});
                this.m_reportDeliveryService.deliverReport(report, fileName);
            } else {
                LogUtils.infof((Object)this, (String)"Skipped delivery of report %s because it has no recipients", (Object[])new Object[]{report.getReportName()});
            }
            LogUtils.debugf((Object)this, (String)"reportd -- done running job %s", (Object[])new Object[]{report.getReportName()});
        }
        catch (ReportRunException e) {
            this.createAndSendReportingEvent("uei.opennms.org/reportd/reportRunFailed", report.getReportName(), e.getMessage());
        }
        catch (ReportDeliveryException e) {
            this.createAndSendReportingEvent("uei.opennms.org/reportd/reportDeliveryFailed", report.getReportName(), e.getMessage());
        }
        finally {
            ThreadCategory.setPrefix((String)originalName);
        }
    }

    private void createAndSendReportingEvent(String uei, String reportName, String reason) {
        LogUtils.debugf((Object)this, (String)"Crafting reporting event with UEI '%s' for report '%s' with reason '%s'", (Object[])new Object[]{uei, reportName, reason});
        EventBuilder bldr = new EventBuilder(uei, NAME);
        bldr.addParam("reportName", reportName);
        bldr.addParam("reason", reason);
        this.m_eventForwarder.sendNow(bldr.getEvent());
    }

    @EventHandler(uei="uei.opennms.org/reportd/runReport")
    public void handleRunReportEvent(Event e) {
        String reportName = new String();
        for (Parm parm : e.getParmCollection()) {
            if ("reportName".equals(parm.getParmName())) {
                reportName = parm.getValue().getContent();
                continue;
            }
            LogUtils.infof((Object)this, (String)"Unknown Event Constant: %s", (Object[])new Object[]{parm.getParmName()});
        }
        if (reportName != "") {
            LogUtils.debugf((Object)this, (String)"running report %s", (Object[])new Object[]{reportName});
            this.runReport(reportName);
        } else {
            LogUtils.errorf((Object)this, (String)"Can not run report -- reportName not specified", (Object[])new Object[0]);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event e) {
        if (this.isReloadConfigEventTarget(e)) {
            LogUtils.infof((Object)this, (String)"handleReloadConfigEvent: reloading configuration...", (Object[])new Object[0]);
            EventBuilder ebldr = null;
            try {
                this.reportDirectory = this.m_reportConfigurationDao.getStorageDirectory();
                LogUtils.debugf((Object)this, (String)"handleReloadConfigEvent: lock acquired, unscheduling current reports...", (Object[])new Object[0]);
                this.m_reportScheduler.rebuildReportSchedule();
                LogUtils.debugf((Object)this, (String)"handleRelodConfigEvent: reports rescheduled.", (Object[])new Object[0]);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", NAME);
                ebldr.addParam("daemonName", NAME);
            }
            catch (Throwable ex) {
                LogUtils.errorf((Object)this, (Throwable)ex, (String)"handleReloadConfigurationEvent: Error reloading configuration: %s", (Object[])new Object[]{ex.getMessage()});
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", NAME);
                ebldr.addParam("daemonName", NAME);
                ebldr.addParam("reason", ex.getLocalizedMessage().substring(1, 128));
            }
            if (ebldr != null) {
                this.getEventForwarder().sendNow(ebldr.getEvent());
            }
            LogUtils.infof((Object)this, (String)"handleReloadConfigEvent: configuration reloaded.", (Object[])new Object[0]);
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !NAME.equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LogUtils.debugf((Object)this, (String)("isReloadConfigEventTarget: Reportd was target of reload event: " + isTarget), (Object[])new Object[0]);
        return isTarget;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setReportScheduler(ReportScheduler reportScheduler) {
        this.m_reportScheduler = reportScheduler;
    }

    public ReportScheduler getReportScheduler() {
        return this.m_reportScheduler;
    }

    public ReportService getReportService() {
        return this.m_reportService;
    }

    public void setReportService(ReportService reportService) {
        this.m_reportService = reportService;
    }

    public ReportDeliveryService getReportDeliveryService() {
        return this.m_reportDeliveryService;
    }

    public void setReportDeliveryService(ReportDeliveryService reportDeliveryService) {
        this.m_reportDeliveryService = reportDeliveryService;
    }

    public ReportdConfigurationDao getReportdConfigurationDao() {
        return this.m_reportConfigurationDao;
    }

    public void setReportdConfigurationDao(ReportdConfigurationDao reportConfigurationDao) {
        this.m_reportConfigurationDao = reportConfigurationDao;
    }
}

