/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.reporting.service;

import java.text.ParseException;
import java.util.Arrays;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.reportd.Report;
import org.opennms.netmgt.dao.ReportdConfigurationDao;
import org.opennms.netmgt.reporting.service.ReportJob;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.StringUtils;

public class ReportScheduler
implements InitializingBean,
DisposableBean {
    protected static final String JOB_GROUP = "Reportd";
    @Autowired
    private ReportdConfigurationDao m_configDao;
    @Autowired
    private Scheduler m_scheduler;
    private JobFactory m_reportJobFactory;
    private Object m_lock = new Object();

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        try {
            this.getScheduler().setJobFactory(this.getReportJobFactory());
        }
        catch (SchedulerException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"afterPropertiesSet: couldn't set proper JobFactory for scheduler: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    ReportScheduler(Scheduler sched) {
        this.m_scheduler = sched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildReportSchedule() {
        LogUtils.infof((Object)this, (String)"rebuildReportSchedule: obtaining lock...", (Object[])new Object[0]);
        Object object = this.m_lock;
        synchronized (object) {
            LogUtils.debugf((Object)this, (String)"rebuildReportSchedule: lock acquired. reloading configuration...", (Object[])new Object[0]);
            try {
                this.m_configDao.reloadConfiguration();
                LogUtils.debugf((Object)this, (String)"rebuildReportSchedule: removing current report jobs from schedule...", (Object[])new Object[0]);
                this.removeCurrentJobsFromSchedule();
                LogUtils.debugf((Object)this, (String)"rebuildReportSchedule: recreating report schedule based on configuration...", (Object[])new Object[0]);
                this.buildReportSchedule();
                this.printCurrentSchedule();
            }
            catch (DataAccessResourceFailureException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"rebuildReportSchedule: %s", (Object[])new Object[]{e.getMessage()});
                throw new IllegalStateException(e);
            }
        }
        LogUtils.infof((Object)this, (String)"rebuildReportSchedule: schedule rebuilt and lock released.", (Object[])new Object[0]);
    }

    private void printCurrentSchedule() {
        try {
            LogUtils.infof((Object)this, (String)"calendarNames: %s", (Object[])new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getCalendarNames())});
            LogUtils.infof((Object)this, (String)"current executing jobs: %s", (Object[])new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getCurrentlyExecutingJobs().toArray())});
            LogUtils.infof((Object)this, (String)"current job names: %s", (Object[])new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getJobNames(JOB_GROUP))});
            LogUtils.infof((Object)this, (String)"scheduler metadata: %s", (Object[])new Object[]{this.getScheduler().getMetaData()});
            LogUtils.infof((Object)this, (String)"trigger names: %s", (Object[])new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getTriggerNames(JOB_GROUP))});
            for (String triggerName : Arrays.asList(this.getScheduler().getTriggerNames(JOB_GROUP))) {
                CronTrigger t = (CronTrigger)this.getScheduler().getTrigger(triggerName, JOB_GROUP);
                StringBuilder sb = new StringBuilder("trigger: ");
                sb.append(triggerName);
                sb.append(", calendar name: ");
                sb.append(t.getCalendarName());
                sb.append(", cron expression: ");
                sb.append(t.getCronExpression());
                sb.append(", URL: ");
                sb.append(t.getJobDataMap().get((Object)"report"));
                sb.append(", next fire time: ");
                sb.append(t.getNextFireTime());
                sb.append(", previous fire time: ");
                sb.append(t.getPreviousFireTime());
                sb.append(", time zone: ");
                sb.append(t.getTimeZone());
                sb.append(", priority: ");
                sb.append(t.getPriority());
                LogUtils.infof((Object)this, (String)sb.toString(), (Object[])new Object[0]);
            }
        }
        catch (Throwable e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"printCurrentSchedule: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReportSchedule() {
        Object object = this.m_lock;
        synchronized (object) {
            for (Report report : this.m_configDao.getReports()) {
                JobDetail detail = null;
                CronTrigger trigger = null;
                try {
                    detail = new JobDetail(report.getReportName(), JOB_GROUP, ReportJob.class, false, false, false);
                    detail.getJobDataMap().put((Object)"report", (Object)report);
                    trigger = new CronTrigger(report.getReportName(), JOB_GROUP, report.getCronSchedule());
                    trigger.setMisfireInstruction(2);
                    this.getScheduler().scheduleJob(detail, (Trigger)trigger);
                }
                catch (ParseException e) {
                    LogUtils.errorf((Object)this, (Throwable)e, (String)"buildReportSchedule: %s", (Object[])new Object[]{e.getMessage()});
                }
                catch (SchedulerException e) {
                    LogUtils.errorf((Object)this, (Throwable)e, (String)"buildReportSchedule: %s", (Object[])new Object[]{e.getMessage()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCurrentJobsFromSchedule() {
        Object object = this.m_lock;
        synchronized (object) {
            try {
                for (String jobName : Arrays.asList(this.m_scheduler.getJobNames(JOB_GROUP))) {
                    this.getScheduler().deleteJob(jobName, JOB_GROUP);
                }
            }
            catch (SchedulerException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"removeCurrentJobsFromSchedule: %s", (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    public ReportdConfigurationDao getConfigDao() {
        return this.m_configDao;
    }

    public void setConfigDao(ReportdConfigurationDao configDao) {
        this.m_configDao = configDao;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setReportJobFactory(JobFactory reportJobFactory) {
        this.m_reportJobFactory = reportJobFactory;
    }

    public JobFactory getReportJobFactory() {
        return this.m_reportJobFactory;
    }

    public void start() throws SchedulerException {
        this.getScheduler().start();
        this.buildReportSchedule();
        this.printCurrentSchedule();
    }

    public void destroy() throws SchedulerException {
        this.getScheduler().shutdown();
    }
}

