/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.poller.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Main {
    String[] m_args;
    ClassPathXmlApplicationContext m_context;
    PollerFrontEnd m_frontEnd;
    String m_url;
    String m_locationName;
    boolean m_shuttingDown = false;
    boolean m_gui = false;
    CommandLine m_cl;

    private Main(String[] args) {
        this.m_args = args;
        this.initializeLogging();
    }

    private void initializeLogging() {
        Logger logger = Logger.getRootLogger();
        logger.setLevel(Level.WARN);
        PatternLayout layout = new PatternLayout("%d %-5p [%t] %c: %m%n");
        FileAppender a = new FileAppender();
        a.setName("default");
        a.setAppend(true);
        a.setBufferedIO(true);
        String logFile = System.getProperty("os.name").contains("Windows") ? System.getProperty("java.io.tmpdir") + File.separator + "opennms-remote-poller.log" : System.getProperty("user.home") + File.separator + ".opennms" + File.separator + "remote-poller.log";
        File logDirectory = new File(logFile).getParentFile();
        if (!logDirectory.exists() && !logDirectory.mkdirs()) {
            throw new IllegalStateException("Could not create parent directory for log file '" + logFile + "'");
        }
        a.setFile(logFile);
        a.setLayout((Layout)layout);
        a.activateOptions();
        logger.removeAllAppenders();
        logger.addAppender((Appender)a);
    }

    private void run() {
        try {
            this.parseArguments();
            this.createAppContext();
            this.registerShutDownHook();
            if (!this.m_gui && !this.m_frontEnd.isRegistered()) {
                if (this.m_locationName == null) {
                    this.log().fatal((Object)"No location name provided.  You must pass a location name the first time you start the remote poller!");
                    System.exit(27);
                } else {
                    this.m_frontEnd.register(this.m_locationName);
                }
            }
        }
        catch (Exception e) {
            this.log().fatal((Object)"Exception occurred during registration!", (Throwable)e);
            System.exit(27);
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void parseArguments() throws ParseException {
        Options options = new Options();
        options.addOption("h", "help", false, "this help");
        options.addOption("d", "debug", false, "write debug messages to the log");
        options.addOption("g", "gui", false, "start a GUI (default: false)");
        options.addOption("l", "location", true, "the location name of this remote poller");
        options.addOption("u", "url", true, "the RMI URL for OpenNMS (rmi://server-name/)");
        PosixParser parser = new PosixParser();
        this.m_cl = parser.parse(options, this.m_args);
        if (this.m_cl.hasOption("h")) {
            this.usage(options);
            System.exit(1);
        }
        if (this.m_cl.hasOption("d")) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
        if (this.m_cl.hasOption("l")) {
            this.m_locationName = this.m_cl.getOptionValue("l");
        }
        if (this.m_cl.hasOption("u")) {
            String arg = this.m_cl.getOptionValue("u").toLowerCase();
            if (arg.startsWith("http")) {
                try {
                    URL url = new URL(arg);
                    this.m_url = "rmi://" + url.getHost();
                }
                catch (MalformedURLException e) {
                    this.usage(options);
                    e.printStackTrace();
                    System.exit(2);
                }
            } else {
                this.m_url = arg;
            }
        } else {
            this.usage(options);
            System.exit(3);
        }
        if (this.m_cl.hasOption("g")) {
            this.m_gui = true;
        }
    }

    private void usage(Options o) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("usage: ", o);
    }

    private void registerShutDownHook() {
        Thread shutdownHook = new Thread(){

            public void run() {
                Main.this.m_shuttingDown = true;
                Main.this.m_context.close();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private void createAppContext() {
        File homeDir = new File(System.getProperty("user.home"));
        String homeUrl = homeDir.toURI().toString();
        if (homeUrl.endsWith("/")) {
            homeUrl = homeUrl.substring(0, homeUrl.length() - 1);
        }
        this.log().debug((Object)("user.home.url = " + homeUrl));
        System.setProperty("user.home.url", homeUrl);
        this.log().debug((Object)("opennms.poller.server.url = " + this.m_url));
        System.setProperty("opennms.poller.server.url", this.m_url);
        this.log().debug((Object)("location name = " + this.m_locationName));
        ArrayList<String> configs = new ArrayList<String>();
        configs.add("classpath:/META-INF/opennms/applicationContext-remotePollerBackEnd.xml");
        configs.add("classpath:/META-INF/opennms/applicationContext-pollerFrontEnd.xml");
        if (this.m_gui) {
            configs.add("classpath:/META-INF/opennms/applicationContext-ws-gui.xml");
        }
        this.m_context = new ClassPathXmlApplicationContext(configs.toArray(new String[0]));
        this.m_frontEnd = (PollerFrontEnd)this.m_context.getBean("pollerFrontEnd");
        this.m_frontEnd.addPropertyChangeListener(new PropertyChangeListener(){

            private boolean shouldExit(PropertyChangeEvent e) {
                Main.this.log().debug((Object)("shouldExit: received property change event: " + e.getPropertyName() + ";oldvalue:" + e.getOldValue() + ";newvalue:" + e.getNewValue()));
                String propName = e.getPropertyName();
                Object newValue = e.getNewValue();
                if ("exitNecessary".equals(propName) && Boolean.TRUE.equals(newValue)) {
                    Main.this.log().info((Object)"shouldExit: Exiting because exitNecessary is TRUE");
                    return true;
                }
                if ("started".equals(propName) && Boolean.FALSE.equals(newValue)) {
                    Main.this.log().info((Object)"shouldExit: Exiting because started is now false");
                    return true;
                }
                Main.this.log().debug((Object)"shouldExit: not exiting");
                return false;
            }

            public void propertyChange(PropertyChangeEvent e) {
                if (!Main.this.m_shuttingDown && this.shouldExit(e)) {
                    System.exit(10);
                }
            }
        });
    }

    public static void main(String[] args) {
        String killSwitchFileName = System.getProperty("opennms.poller.killSwitch.resource");
        File killSwitch = null;
        if (!"".equals(killSwitchFileName) && killSwitchFileName != null && !(killSwitch = new File(System.getProperty("opennms.poller.killSwitch.resource"))).exists()) {
            try {
                killSwitch.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        new Main(args).run();
    }
}

