/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.poller.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Main {
    String[] m_args;
    ClassPathXmlApplicationContext m_context;
    PollerFrontEnd m_frontEnd;
    String m_url;
    String m_locationName;

    private Main(String[] args) {
        this.m_args = args;
    }

    private void run() {
        this.parseArguments();
        this.createAppContext();
        this.registerShutDownHook();
        if (!this.m_frontEnd.isRegistered()) {
            this.m_frontEnd.register(this.m_locationName);
        }
    }

    private void parseArguments() {
        if (this.m_args.length < 2) {
            this.usage();
        }
        this.m_url = this.m_args[0];
        this.m_locationName = this.m_args[1];
    }

    private void registerShutDownHook() {
        Thread shutdownHook = new Thread(){

            public void run() {
                Main.this.m_context.close();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private void createAppContext() {
        File homeDir = new File(System.getProperty("user.home"));
        String homeUrl = homeDir.toURI().toString();
        if (homeUrl.endsWith("/")) {
            homeUrl = homeUrl.substring(0, homeUrl.length() - 1);
        }
        System.err.println("user.home.url = " + homeUrl);
        System.setProperty("user.home.url", homeUrl);
        System.err.println("opennms.poller.server.url = " + this.m_url);
        System.setProperty("opennms.poller.server.url", this.m_url);
        String[] configs = new String[]{"classpath:/META-INF/opennms/applicationContext-remotePollerBackEnd.xml", "classpath:/META-INF/opennms/applicationContext-pollerFrontEnd.xml"};
        this.m_context = new ClassPathXmlApplicationContext(configs);
        this.m_frontEnd = (PollerFrontEnd)this.m_context.getBean("pollerFrontEnd");
        this.m_frontEnd.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if ("started".equals(e.getPropertyName()) && Boolean.FALSE.equals(e.getNewValue())) {
                    System.exit(1);
                }
            }
        });
    }

    private void usage() {
        System.err.println("The remote poller is not registered with the server.");
        System.err.println("Register it by running this command:");
        System.err.println("\tjava -jar opennms-remote-poller.jar <server URL> <location name>");
        System.err.println("where:");
        System.err.println("\t<server URL>    is URL of the RMI service on the OpenNMS server,");
        System.err.println("\t                usually 'rmi://<server name>'.");
        System.err.println("\t<location name> is name of a configured monitoring location");
        System.err.println("\t                definition on the OpenNMS server.");
        System.exit(1);
    }

    public static void main(String[] args) {
        new Main(args).run();
    }
}

