/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.xml.AbstractMergingJaxbConfigDao;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.BeanInfo;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.config.collectd.jmx.Mbeans;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class JMXDataCollectionConfigDao
extends AbstractMergingJaxbConfigDao<JmxDatacollectionConfig, JmxDatacollectionConfig> {
    public static final Logger LOG = LoggerFactory.getLogger(JMXDataCollectionConfigDao.class);
    private final Map<String, JmxCollection> m_collectionMap = new HashMap<String, JmxCollection>();
    private final ReadWriteLock m_lock = new ReentrantReadWriteLock();

    public JMXDataCollectionConfigDao() {
        super(JmxDatacollectionConfig.class, "JMX Data Collection Configuration", Paths.get("etc", "jmx-datacollection-config.xml"), Paths.get("etc", "jmx-datacollection-config.d"));
    }

    public JmxDatacollectionConfig translateConfig(JmxDatacollectionConfig config) {
        for (JmxCollection collection : config.getJmxCollectionList()) {
            if (!collection.hasImportMbeans()) continue;
            for (String importMbeans : collection.getImportGroupsList()) {
                File file = this.getOpennmsHome().resolve(Paths.get("etc", importMbeans)).toFile();
                LOG.debug("parseJmxMbeans: parsing {}", (Object)file);
                Mbeans mbeans = (Mbeans)JaxbUtils.unmarshal(Mbeans.class, (Resource)new FileSystemResource(file));
                collection.addMbeans(mbeans.getMbeanList());
            }
        }
        return config;
    }

    public JmxDatacollectionConfig getConfig() {
        return (JmxDatacollectionConfig)this.getObject();
    }

    public JmxDatacollectionConfig mergeConfigs(JmxDatacollectionConfig source, JmxDatacollectionConfig target) {
        if (target == null) {
            target = new JmxDatacollectionConfig();
        }
        return target.merge(source);
    }

    public void onConfigUpdated(JmxDatacollectionConfig config) {
        this.buildCollectionMap(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCollectionMap(JmxDatacollectionConfig config) {
        this.m_lock.writeLock().lock();
        try {
            this.m_collectionMap.clear();
            for (JmxCollection collection : config.getJmxCollectionList()) {
                HashMap<String, Mbean> groupMap = new HashMap<String, Mbean>();
                for (Mbean mbean : collection.getMbeans()) {
                    groupMap.put(mbean.getName(), mbean);
                }
                this.m_collectionMap.put(collection.getName(), collection);
            }
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmxCollection getJmxCollection(String collectionName) {
        this.getObject();
        this.m_lock.readLock().lock();
        try {
            JmxCollection collection = this.m_collectionMap.get(collectionName);
            if (collection == null) {
                LOG.warn("No JMX Config for collection '{}' found", (Object)collectionName);
            }
            JmxCollection jmxCollection = collection;
            return jmxCollection;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Attrib>> getAttributeMap(String cName, String aSysoid, String anAddress) {
        this.getObject();
        this.m_lock.readLock().lock();
        try {
            HashMap<String, List<Attrib>> attributeMap = new HashMap<String, List<Attrib>>();
            LOG.debug("getMibObjectList: collection: {} sysoid: {} address: {}", new Object[]{anAddress, cName, aSysoid});
            if (aSysoid == null) {
                LOG.debug("getMibObjectList: aSysoid parameter is NULL...");
                HashMap<String, List<Attrib>> hashMap = attributeMap;
                return hashMap;
            }
            JmxCollection collection = this.m_collectionMap.get(cName);
            if (collection == null) {
                HashMap<String, List<Attrib>> hashMap = attributeMap;
                return hashMap;
            }
            for (Mbean mbean : collection.getMbeans()) {
                ArrayList<Attrib> list = new ArrayList<Attrib>(mbean.getAttribList());
                for (CompAttrib compAttrib : mbean.getCompAttribList()) {
                    for (CompMember compMember : compAttrib.getCompMemberList()) {
                        Attrib attribWrapper = new Attrib();
                        attribWrapper.setName(compAttrib.getName() + "|" + compMember.getName());
                        attribWrapper.setAlias(compMember.getAlias());
                        attribWrapper.setType(compMember.getType());
                        list.add(attribWrapper);
                    }
                }
                attributeMap.put(mbean.getObjectname(), list);
            }
            HashMap<String, List<Attrib>> hashMap = attributeMap;
            return hashMap;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BeanInfo> getMBeanInfo(String cName) {
        this.getObject();
        this.m_lock.readLock().lock();
        try {
            HashMap<String, BeanInfo> map = new HashMap<String, BeanInfo>();
            JmxCollection collection = this.m_collectionMap.get(cName);
            if (collection == null) {
                LOG.warn("no collection named '{}' was found", (Object)cName);
            } else {
                for (Mbean mbean : collection.getMbeans()) {
                    BeanInfo beanInfo = new BeanInfo();
                    beanInfo.setMbeanName(mbean.getName());
                    beanInfo.setObjectName(mbean.getObjectname());
                    beanInfo.setKeyField(mbean.getKeyfield());
                    beanInfo.setExcludes(mbean.getExclude());
                    beanInfo.setKeyAlias(mbean.getKeyAlias());
                    ArrayList<String> attribNameList = new ArrayList<String>();
                    ArrayList<String> compAttribNameList = new ArrayList<String>();
                    for (CompAttrib myCa : mbean.getCompAttribList()) {
                        for (CompMember myCm : myCa.getCompMemberList()) {
                            attribNameList.add(myCa.getName() + "|" + myCm.getName());
                            compAttribNameList.add(myCa.getName() + "|" + myCm.getName());
                        }
                    }
                    for (Attrib myA : mbean.getAttribList()) {
                        attribNameList.add(myA.getName());
                    }
                    beanInfo.setAttributes(attribNameList);
                    beanInfo.setCompositeAttributes(compAttribNameList);
                    map.put(mbean.getObjectname(), beanInfo);
                }
            }
            Map map2 = Collections.unmodifiableMap(map);
            return map2;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStep(String cName) {
        this.getObject();
        this.m_lock.readLock().lock();
        try {
            JmxCollection collection = this.m_collectionMap.get(cName);
            if (collection != null) {
                int n = collection.getRrd().getStep();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRRAList(String cName) {
        this.getObject();
        this.m_lock.readLock().lock();
        try {
            JmxCollection collection = this.m_collectionMap.get(cName);
            if (collection != null) {
                List list = collection.getRrd().getRraCollection();
                return list;
            }
            List<String> list = null;
            return list;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public String getRrdPath() {
        String rrdPath = this.getConfig().getRrdRepository();
        if (rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (rrdPath.endsWith(File.separator)) {
            rrdPath = rrdPath.substring(0, rrdPath.length() - File.separator.length());
        }
        return rrdPath;
    }
}

