/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.RancidAdapterConfig;
import org.opennms.netmgt.config.common.BasicSchedule;
import org.opennms.netmgt.config.rancid.adapter.ExcludeRange;
import org.opennms.netmgt.config.rancid.adapter.IncludeRange;
import org.opennms.netmgt.config.rancid.adapter.Mapping;
import org.opennms.netmgt.config.rancid.adapter.Package;
import org.opennms.netmgt.config.rancid.adapter.PolicyManage;
import org.opennms.netmgt.config.rancid.adapter.RancidConfiguration;
import org.opennms.netmgt.config.rancid.adapter.Schedule;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.filter.FilterDaoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RancidAdapterConfigManager
implements RancidAdapterConfig {
    private RancidConfiguration m_config;
    private static boolean m_verifyServer;
    private static String m_localServer;
    private Map<String, List<String>> m_urlIPMap;
    private Map<Package, List<String>> m_pkgIpMap;
    private Map<Package, PolicyManage> m_pkgPolicyMap;

    public RancidAdapterConfigManager(InputStream reader, String serverName, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        m_localServer = serverName;
        m_verifyServer = verifyServer;
        this.reloadXML(reader);
    }

    public RancidAdapterConfigManager() {
    }

    protected synchronized void reloadXML(InputStream reader) throws MarshalException, ValidationException, IOException {
        this.m_config = (RancidConfiguration)CastorUtils.unmarshal(RancidConfiguration.class, (InputStream)reader);
        this.createPolicyNamePkgMap();
        this.createUrlIpMap();
        this.createPackageIpListMap();
    }

    private void createPolicyNamePkgMap() {
        this.m_pkgPolicyMap = new HashMap<Package, PolicyManage>();
        if (this.hasPolicies()) {
            for (PolicyManage pm : this.policies()) {
                this.m_pkgPolicyMap.put(pm.getPackage(), pm);
            }
        }
    }

    private void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        if (this.hasPolicies()) {
            for (Package pkg : this.packages()) {
                for (String url : this.includeURLs(pkg)) {
                    List iplist = IpListFromUrl.parse((String)url);
                    if (iplist.size() <= 0) continue;
                    this.m_urlIPMap.put(url, iplist);
                }
            }
        }
    }

    private void createPackageIpListMap() {
        this.m_pkgIpMap = new HashMap<Package, List<String>>();
        if (this.hasPolicies()) {
            for (Package pkg : this.packages()) {
                try {
                    List<String> ipList = this.getIpList(pkg);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("createPackageIpMap: package " + pkg.getName() + ": ipList size =  " + ipList.size());
                    }
                    if (ipList.size() <= 0) continue;
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("createPackageIpMap: package " + pkg.getName() + ". IpList size is " + ipList.size());
                    }
                    this.m_pkgIpMap.put(pkg, ipList);
                }
                catch (Throwable t) {
                    this.log().error("createPackageIpMap: failed to map package: " + pkg.getName() + " to an IP List: " + t, t);
                }
            }
        }
    }

    private List<String> getIpList(Package pkg) {
        StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
        if (m_verifyServer) {
            filterRules.append(" & (serverName == ");
            filterRules.append('\"');
            filterRules.append(m_localServer);
            filterRules.append('\"');
            filterRules.append(")");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("createPackageIpMap: package is " + pkg.getName() + ". filer rules are  " + filterRules.toString());
        }
        List ipList = FilterDaoFactory.getInstance().getIPList(filterRules.toString());
        return ipList;
    }

    private synchronized boolean interfaceInPackage(String iface, Package pkg) {
        ThreadCategory log = this.log();
        boolean filterPassed = false;
        List<String> ipList = this.m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(iface);
        }
        if (log.isDebugEnabled()) {
            log.debug("interfaceInPackage: Interface " + iface + " passed filter for package " + pkg.getName() + "?: " + filterPassed);
        }
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
        for (IncludeRange rng : pkg.getIncludeRange()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_include = true;
            break;
        }
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        for (String spec : pkg.getSpecific()) {
            byte[] speca = InetAddressUtils.toIpAddrBytes((String)spec);
            if (new ByteArrayComparator().compare(speca, addr) != 0) continue;
            has_specific = true;
            break;
        }
        Enumeration eurl = pkg.enumerateIncludeUrl();
        while (!has_specific && eurl.hasMoreElements()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.nextElement());
        }
        for (ExcludeRange rng : pkg.getExcludeRangeCollection()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_exclude = true;
            break;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    private synchronized List<String> getAllPackageMatches(String ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        for (Package pkg : this.packages()) {
            boolean inPkg = this.interfaceInPackage(ipaddr, pkg);
            if (!inPkg) continue;
            matchingPkgs.add(pkg.getName());
        }
        return matchingPkgs;
    }

    @Override
    public long getDelay(String ipaddr) {
        if (this.hasPolicyManage(ipaddr) && this.getPolicyManageWithoutTesting(ipaddr).hasDelay()) {
            return this.getPolicyManageWithoutTesting(ipaddr).getDelay();
        }
        return this.getConfiguration().getDelay();
    }

    @Override
    public int getRetries(String ipaddr) {
        if (this.hasPolicyManage(ipaddr) && this.getPolicyManage(ipaddr).hasRetries()) {
            return this.getPolicyManageWithoutTesting(ipaddr).getRetries();
        }
        return this.getConfiguration().getRetries();
    }

    @Override
    public boolean useCategories(String ipaddr) {
        if (this.hasPolicyManage(ipaddr) && this.getPolicyManage(ipaddr).hasUseCategories()) {
            return this.getPolicyManageWithoutTesting(ipaddr).getUseCategories();
        }
        return this.getConfiguration().getUseCategories();
    }

    @Override
    public String getType(String sysoid) {
        if (sysoid != null) {
            for (Mapping map : this.mappings()) {
                if (!sysoid.startsWith(map.getSysoidMask())) continue;
                return map.getType();
            }
        }
        return this.getConfiguration().getDefaultType();
    }

    @Override
    public boolean isCurTimeInSchedule(String ipaddr) {
        if (this.hasSchedule(ipaddr)) {
            GregorianCalendar cal = new GregorianCalendar();
            for (Schedule schedule : this.getSchedules(ipaddr)) {
                if (!this.isTimeInSchedule(cal, schedule)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private synchronized boolean isTimeInSchedule(Calendar cal, Schedule schedule) {
        return BasicScheduleUtils.isTimeInSchedule((Calendar)cal, (BasicSchedule)schedule);
    }

    private boolean hasPolicies() {
        return this.getConfiguration().getPolicies() != null;
    }

    private boolean hasPolicyManage(String ipaddress) {
        return this.getAllPackageMatches(ipaddress).size() > 0;
    }

    private PolicyManage getPolicyManage(String ipaddr) {
        if (this.hasPolicyManage(ipaddr)) {
            return this.getPolicyManageWithoutTesting(ipaddr);
        }
        return null;
    }

    private PolicyManage getPolicyManageWithoutTesting(String ipaddr) {
        String pkgname = this.getAllPackageMatches(ipaddr).get(0);
        for (Map.Entry<Package, PolicyManage> entry : this.m_pkgPolicyMap.entrySet()) {
            if (!entry.getKey().getName().equals(pkgname)) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean hasSchedule(String ipaddress) {
        if (this.hasPolicyManage(ipaddress)) {
            return this.getPolicyManageWithoutTesting(ipaddress).getScheduleCount() > 0;
        }
        return false;
    }

    public List<Schedule> getSchedules(String ipaddress) {
        if (this.hasPolicyManage(ipaddress)) {
            return this.getPolicyManageWithoutTesting(ipaddress).getScheduleCollection();
        }
        return new ArrayList<Schedule>();
    }

    public Iterable<Package> packages() {
        ArrayList<Package> pkgs = new ArrayList<Package>();
        if (this.hasPolicies()) {
            for (PolicyManage pm : this.policies()) {
                pkgs.add(pm.getPackage());
            }
        }
        return pkgs;
    }

    public Iterable<Mapping> mappings() {
        return this.getConfiguration().getMappingCollection();
    }

    public Iterable<PolicyManage> policies() {
        return this.getConfiguration().getPolicies().getPolicyManageCollection();
    }

    public Iterable<String> includeURLs(Package pkg) {
        return pkg.getIncludeUrlCollection();
    }

    public synchronized RancidConfiguration getConfiguration() {
        return this.m_config;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public synchronized void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }
}

