/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosdrx.jmx;

import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.openoss.opennms.spring.qosdrx.jmx.QoSDrxMBean;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.DefaultLocatorFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class QoSDrx
implements QoSDrxMBean {
    private static final String NAME = "OpenOSS.QoSDrx";
    private ClassPathXmlApplicationContext m_context;
    int m_status = 0;

    ApplicationContext getContext() {
        return this.m_context;
    }

    public void init() {
        ThreadCategory.setPrefix((String)NAME);
    }

    public void start() {
        ThreadCategory.setPrefix((String)NAME);
        this.m_status = 1;
        ThreadCategory.getInstance().debug((Object)("SPRING: thread.classLoader=" + Thread.currentThread().getContextClassLoader()));
        BeanFactoryLocator bfl = DefaultLocatorFactory.getInstance();
        BeanFactoryReference bf = bfl.useBeanFactory("daoContext");
        ApplicationContext daoContext = (ApplicationContext)bf.getFactory();
        ThreadCategory.getInstance().debug((Object)"QoSDrx using /org/openoss/opennms/spring/qosdrx/qosdrx-spring-context.xml");
        this.m_context = new ClassPathXmlApplicationContext(new String[]{"/org/openoss/opennms/spring/qosdrx/qosdrx-spring-context.xml"}, daoContext);
        ThreadCategory.getInstance().debug((Object)("SPRING: context.classLoader=" + this.m_context.getClassLoader()));
        this.getQoSDrx().init();
        this.getQoSDrx().start();
        this.m_status = 2;
    }

    public void stop() {
        ThreadCategory.setPrefix((String)NAME);
        this.m_status = 3;
        this.getQoSDrx().stop();
        this.m_context.close();
        this.m_status = 4;
    }

    public String getRuntimeStatistics() {
        return this.getQoSDrx().getRuntimeStatistics();
    }

    public String status() {
        ThreadCategory.setPrefix((String)NAME);
        return Fiber.STATUS_NAMES[this.m_status];
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getStats() {
        return this.getQoSDrx().getStats();
    }

    private org.openoss.opennms.spring.qosdrx.QoSDrx getQoSDrx() {
        org.openoss.opennms.spring.qosdrx.QoSDrx qosdrx = (org.openoss.opennms.spring.qosdrx.QoSDrx)this.m_context.getBean("QoSDrx");
        qosdrx.setapplicationcontext(this.m_context);
        return qosdrx;
    }
}

