/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosd.jmx;

import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.openoss.opennms.spring.qosd.jmx.QoSDMBean;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.DefaultLocatorFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class QoSD
implements QoSDMBean {
    private static final String NAME = "OpenOSS.QoSD";
    private ClassPathXmlApplicationContext m_context;
    int m_status = 0;

    ApplicationContext getContext() {
        return this.m_context;
    }

    public void init() {
        ThreadCategory.setPrefix((String)NAME);
    }

    public void start() {
        ThreadCategory.setPrefix((String)NAME);
        this.m_status = 1;
        ThreadCategory.getInstance().debug((Object)("SPRING: thread.classLoader=" + Thread.currentThread().getContextClassLoader()));
        BeanFactoryLocator bfl = DefaultLocatorFactory.getInstance();
        BeanFactoryReference bf = bfl.useBeanFactory("daoContext");
        ApplicationContext daoContext = (ApplicationContext)bf.getFactory();
        String qosdj2ee = System.getProperty("qosd.usej2ee");
        ThreadCategory.getInstance().info((Object)("QoSD System Property qosd.usej2ee=" + qosdj2ee));
        if ("true".equals(qosdj2ee)) {
            ThreadCategory.getInstance().debug((Object)"QoSD using /org/openoss/opennms/spring/qosd/qosd-j2ee-context.xml");
            this.m_context = new ClassPathXmlApplicationContext(new String[]{"/org/openoss/opennms/spring/qosd/qosd-j2ee-context.xml"}, daoContext);
        } else {
            ThreadCategory.getInstance().debug((Object)"QoSD using /org/openoss/opennms/spring/qosd/qosd-spring-context.xml");
            this.m_context = new ClassPathXmlApplicationContext(new String[]{"/org/openoss/opennms/spring/qosd/qosd-spring-context.xml"}, daoContext);
        }
        ThreadCategory.getInstance().debug((Object)("SPRING: context.classLoader=" + this.m_context.getClassLoader()));
        this.getQoSD().init();
        this.getQoSD().start();
        this.m_status = 2;
    }

    public void stop() {
        ThreadCategory.setPrefix((String)NAME);
        this.m_status = 3;
        this.getQoSD().stop();
        this.m_context.close();
        this.m_status = 4;
    }

    public String status() {
        ThreadCategory.setPrefix((String)NAME);
        return Fiber.STATUS_NAMES[this.m_status];
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getStats() {
        return this.getQoSD().getStats();
    }

    private org.openoss.opennms.spring.qosd.QoSD getQoSD() {
        org.openoss.opennms.spring.qosd.QoSD qosd = (org.openoss.opennms.spring.qosd.QoSD)this.m_context.getBean("QoSD");
        qosd.setapplicationcontext(this.m_context);
        return qosd;
    }
}

