/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosdrx;

import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.NodeDao;
import org.openoss.ossj.fm.monitor.spring.OssBeanRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class QoSDrx
extends AbstractServiceDaemon {
    private OssBeanRunner initialOssBeanRunner = null;
    private static AssetRecordDao _assetRecordDao;
    private static NodeDao _nodeDao;
    private static AlarmDao _alarmDao;
    private ClassPathXmlApplicationContext m_context = null;
    public static final String NAME = "OpenOSS.QoSDrx";
    private static String m_stats;

    public QoSDrx() {
        super(NAME);
    }

    public void setInitialOssBeanRunner(OssBeanRunner initialOssBeanRunner) {
        this.initialOssBeanRunner = initialOssBeanRunner;
    }

    public void setAssetRecordDao(AssetRecordDao ar) {
        _assetRecordDao = ar;
    }

    public void setNodeDao(NodeDao nodedao) {
        _nodeDao = nodedao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        _alarmDao = alarmDao;
    }

    public void setApplicationContext(ClassPathXmlApplicationContext context) {
        this.m_context = context;
    }

    protected void onInit() {
        ThreadCategory log = QoSDrx.getLog();
        log.info("QoSDrx.init(): Initialising QoSDrx");
        if (log.isDebugEnabled()) {
            log.debug("QoSDrx.init(): Setting initialOssBeanRunner.setLogName(_logName) to:" + log.getName());
        }
        this.initialOssBeanRunner.setLogName(log.getName());
        if (this.initialOssBeanRunner.getStatus() == 0) {
            this.initialOssBeanRunner.setParentApplicationContext((ApplicationContext)this.m_context);
            this.initialOssBeanRunner.init();
        }
        log.info("QoSDrx.init(): QoSDrx initialised. Status= START_PENDING");
    }

    protected void onStart() {
        ThreadCategory log = QoSDrx.getLog();
        log.info("QoSDrx.start(): Starting QoSDrx");
        if (this.initialOssBeanRunner.getStatus() == 1) {
            this.initialOssBeanRunner.run();
            while (this.initialOssBeanRunner.getStatus() != 3) {
            }
            log.info("QoSDrx.start(): OssBean Receiver Configurations: " + this.initialOssBeanRunner.getOssBeanInstancesStatus());
        } else {
            log.error("QoSDrx.start(): initialOssBeanRunner not initialised status= STOPPED");
            this.setStatus(4);
            this.initialOssBeanRunner.stop();
        }
    }

    protected void onStop() {
        ThreadCategory log = QoSDrx.getLog();
        log.info("QoSDrx.stop(): Stopping QoSDrx");
        this.initialOssBeanRunner.stop();
        while (this.initialOssBeanRunner.getStatus() != 5) {
        }
    }

    protected void onPause() {
        ThreadCategory log = QoSDrx.getLog();
        log.error("QoSDrx.pause(): NOT IMPLEMENTED - this method does nothing and returns");
    }

    protected void onResume() {
        ThreadCategory log = QoSDrx.getLog();
        log.error("QoSDrx.resume(): NOT IMPLEMENTED - this method does nothing and returns");
    }

    private static ThreadCategory getLog() {
        return ThreadCategory.getInstance(QoSDrx.class);
    }

    public String getRuntimeStatistics() {
        ThreadCategory log = QoSDrx.getLog();
        String runtimeStats = "QoSDrx.getRuntimeStatistics(): NOT AVAILABLE";
        try {
            runtimeStats = this.initialOssBeanRunner.getRuntimeStatistics();
        }
        catch (Throwable ex) {
            log.error("QoSDrx.getStats() Problem getting statistics:", ex);
        }
        return runtimeStats;
    }

    public String getStats() {
        return m_stats == null ? "QoSDrx.getStats(): No Stats Available" : m_stats.toString();
    }

    static {
        m_stats = null;
    }
}

