/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import io.opentracing.Span;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.tasks.AbstractTask;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.jexl.OnmsJexlEngine;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.service.DetectorRunner;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpInterfaceScan
implements RunInBatch {
    private static final Logger LOG = LoggerFactory.getLogger(IpInterfaceScan.class);
    private final ProvisionService m_provisionService;
    private final InetAddress m_address;
    private final Integer m_nodeId;
    private final String m_foreignSource;
    private final OnmsMonitoringLocation m_location;
    private final Span m_parentSpan;
    private Span m_span;

    public IpInterfaceScan(Integer nodeId, InetAddress address, String foreignSource, OnmsMonitoringLocation location, ProvisionService provisionService, Span span) {
        this.m_nodeId = nodeId;
        this.m_address = address;
        this.m_foreignSource = foreignSource;
        this.m_location = location;
        this.m_provisionService = provisionService;
        this.m_parentSpan = span;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public OnmsMonitoringLocation getLocation() {
        return this.m_location;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("address", (Object)this.m_address).append("foreign source", (Object)this.m_foreignSource).append("node ID", (Object)this.m_nodeId).append("location", this.m_location != null ? this.m_location.getLocationName() : null).toString();
    }

    public static Callback<Boolean> servicePersister(final BatchTask currentPhase, final ProvisionService service, final PluginConfig detectorConfig, final int nodeId, final InetAddress address, final CompletableFuture<Boolean> future) {
        return new Callback<Boolean>(){

            public void accept(Boolean serviceDetected) {
                final String hostAddress = InetAddressUtils.str((InetAddress)address);
                final String serviceName = detectorConfig.getName();
                LOG.info("Attempted to detect service {} on address {}: {}", new Object[]{serviceName, hostAddress, serviceDetected});
                if (serviceDetected.booleanValue()) {
                    currentPhase.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

                        public void run(BatchTask batch) {
                            if ("SNMP".equals(serviceName)) {
                                service.setIsPrimaryFlag(nodeId, hostAddress);
                            }
                        }
                    }, new RunInBatch(){

                        public void run(BatchTask batch) {
                            service.addMonitoredService(nodeId, hostAddress, serviceName);
                        }
                    }, new RunInBatch(){

                        public void run(BatchTask batch) {
                            service.updateMonitoredServiceState(nodeId, hostAddress, serviceName);
                        }
                    }});
                }
                future.complete(serviceDetected);
            }

            public Boolean apply(Throwable t) {
                LOG.info("Exception occurred while trying to detect service {} on address {}", new Object[]{detectorConfig.getName(), InetAddressUtils.str((InetAddress)address), t});
                return false;
            }
        };
    }

    protected static AbstractTask createDetectorTask(BatchTask currentPhase, ProvisionService service, PluginConfig detectorConfig, int nodeId, InetAddress address, OnmsMonitoringLocation location, Span span, CompletableFuture<Boolean> future) {
        return currentPhase.getCoordinator().createTask((ContainerTask)currentPhase, (Async)new DetectorRunner(service, detectorConfig, nodeId, address, location, span), IpInterfaceScan.servicePersister(currentPhase, service, detectorConfig, nodeId, address, future));
    }

    public void run(BatchTask currentPhase) {
        this.m_span = this.getProvisionService().buildAndStartSpan("IpInterfaceScan", this.m_parentSpan.context());
        this.m_span.setTag("ipAddress", InetAddressUtils.str((InetAddress)this.getAddress()));
        this.m_span.setTag("location", this.getLocation().getLocationName());
        List<PluginConfig> detectorConfigs = this.getProvisionService().getDetectorsForForeignSource(this.getForeignSource() == null ? "default" : this.getForeignSource());
        LOG.info("Detecting services for node {}/{} on address {}: found {} detectors", new Object[]{this.getNodeId(), this.getForeignSource(), InetAddressUtils.str((InetAddress)this.getAddress()), detectorConfigs.size()});
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        for (PluginConfig detectorConfig : detectorConfigs) {
            if (!IpInterfaceScan.shouldDetect(detectorConfig, this.getAddress())) continue;
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            futures.add(future);
            currentPhase.add(IpInterfaceScan.createDetectorTask(currentPhase, this.getProvisionService(), detectorConfig, this.getNodeId(), this.getAddress(), this.getLocation(), this.m_span, future));
        }
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        allFutures.whenComplete((aVoid, throwable) -> this.m_span.finish());
    }

    protected static boolean shouldDetect(PluginConfig detectorConfig, InetAddress address) {
        String ipMatch = detectorConfig.getParameter("ipMatch");
        if (ipMatch == null || ipMatch.trim().isEmpty()) {
            return true;
        }
        if (ipMatch.startsWith("~")) {
            return address.getHostAddress().matches(ipMatch.substring(1));
        }
        return IpInterfaceScan.isIpMatching(address, ipMatch);
    }

    protected static boolean isIpMatching(InetAddress ip, String expr) {
        try {
            OnmsJexlEngine parser = new OnmsJexlEngine();
            parser.white(IPLike.class.getName());
            parser.white(InetAddress.class.getName());
            Expression e = parser.createExpression(IpInterfaceScan.generateExpr(expr));
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("iplike", IPLike.class);
            context.put("ipaddr", ip.getHostAddress());
            Boolean out = (Boolean)e.evaluate((JexlContext)new MapContext(context));
            return out;
        }
        catch (Exception e) {
            LOG.error("Can't process rule '{}' while checking IP {}.", new Object[]{expr, ip, e});
            return false;
        }
    }

    protected static String generateExpr(String basicExpr) {
        LOG.debug("generateExpr: original expression {}", (Object)basicExpr);
        String data = basicExpr;
        Pattern p = Pattern.compile("[0-9a-f:.,\\-*]+");
        Matcher m = p.matcher(data);
        while (m.find()) {
            data = data.replace(m.group(), "iplike.matches(ipaddr,'" + m.group() + "')");
        }
        LOG.debug("generateExpr: computed expression {}", (Object)data);
        return data;
    }
}

