/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;

public class IPAddressTableTracker
extends TableTracker {
    public static final SnmpObjId IP_ADDRESS_PREFIX_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.4.32.1");
    public static final SnmpObjId IP_ADDRESS_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.4.34.1");
    public static final SnmpObjId IP_ADDRESS_IF_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"3");
    public static final SnmpObjId IP_ADDRESS_TYPE_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"4");
    public static final SnmpObjId IP_ADDRESS_PREFIX_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId IP_ADDRESS_PREFIX_ORIGIN_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_PREFIX_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId IP_ADDRESS_ORIGIN_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"6");
    public static final SnmpObjId IP_ADDRESS_STATUS_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"7");
    public static final SnmpObjId IP_ADDRESS_CREATED_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"8");
    public static final SnmpObjId IP_ADDRESS_LAST_CHANGED_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"9");
    public static final SnmpObjId IP_ADDRESS_ROW_STATUS_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"10");
    public static final SnmpObjId IP_ADDRESS_STORAGE_TYPE_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"11");
    public static final int TYPE_IPV4 = 1;
    public static final int TYPE_IPV6 = 2;
    private static SnmpObjId[] s_tableColumns = new SnmpObjId[]{IP_ADDRESS_IF_INDEX, IP_ADDRESS_PREFIX_INDEX};

    public IPAddressTableTracker() {
        super(s_tableColumns);
    }

    public IPAddressTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_tableColumns);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new IPAddressRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processIPAddressRow((IPAddressRow)row);
    }

    public void processIPAddressRow(IPAddressRow row) {
    }

    class IPAddressRow
    extends SnmpRowResult {
        public IPAddressRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LogUtils.debugf((Object)((Object)this), (String)"column count = %d, instance = %s", (Object[])new Object[]{columnCount, instance});
        }

        public Integer getIfIndex() {
            SnmpValue value = this.getValue(IP_ADDRESS_IF_INDEX);
            return value.toInt();
        }

        public String getIpAddress() {
            SnmpResult result = this.getResult(IP_ADDRESS_IF_INDEX);
            int[] instanceIds = result.getInstance().getIds();
            int addressType = instanceIds[0];
            int addressLength = instanceIds[1];
            if (addressType == 1 || addressType == 2) {
                InetAddress address = InetAddressUtils.getInetAddress((int[])instanceIds, (int)2, (int)addressLength);
                return InetAddressUtils.str((InetAddress)address);
            }
            return null;
        }

        private String getNetMask() {
            SnmpValue value = this.getValue(IP_ADDRESS_PREFIX_INDEX);
            SnmpInstId netmaskRef = value.toSnmpObjId().getInstance(IP_ADDRESS_PREFIX_ORIGIN_INDEX);
            int[] rawIds = netmaskRef.getIds();
            int addressType = rawIds[1];
            int addressLength = rawIds[2];
            InetAddress address = InetAddressUtils.getInetAddress((int[])rawIds, (int)3, (int)addressLength);
            int mask = rawIds[rawIds.length - 1];
            if (addressType == 1 || addressType == 2) {
                return InetAddressUtils.str((InetAddress)address) + "/" + mask;
            }
            LogUtils.warnf((Object)((Object)this), (String)"unknown address type, expected 1 (IPv4) or 2 (IPv6), but got %d", (Object[])new Object[]{addressType});
            return null;
        }

        public OnmsIpInterface createInterfaceFromRow() {
            Integer ifIndex = this.getIfIndex();
            String ipAddr = this.getIpAddress();
            String netMask = this.getNetMask();
            LogUtils.debugf((Object)((Object)this), (String)"createInterfaceFromRow: ifIndex = %s, ipAddress = %s, netmask = %s", (Object[])new Object[]{ifIndex, ipAddr, netMask});
            OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(null, ifIndex);
            snmpIface.setNetMask(netMask);
            snmpIface.setCollectionEnabled(true);
            OnmsIpInterface iface = new OnmsIpInterface(ipAddr, null);
            iface.setSnmpInterface(snmpIface);
            iface.setIfIndex(ifIndex);
            String hostName = InetAddressUtils.normalize((String)ipAddr);
            LogUtils.debugf((Object)((Object)this), (String)"setIpHostName: %s", (Object[])new Object[]{hostName});
            iface.setIpHostName(hostName == null ? ipAddr : hostName);
            return iface;
        }

        private SnmpResult getResult(SnmpObjId base) {
            for (SnmpResult result : this.getResults()) {
                if (!base.equals((Object)result.getBase())) continue;
                return result;
            }
            return null;
        }
    }
}

