/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.snmp;

import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.provision.service.snmp.IpAddrTableEntry;
import org.opennms.netmgt.provision.service.snmp.SnmpTable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpAddrTable
extends SnmpTable<IpAddrTableEntry> {
    public IpAddrTable(InetAddress address) {
        super(address, "ipAddrTable", IpAddrTableEntry.ms_elemList);
    }

    public IpAddrTable(InetAddress address, Set<SnmpInstId> ipAddrs) {
        super(address, "ipAddrTable", IpAddrTableEntry.ms_elemList, ipAddrs);
    }

    @Override
    protected IpAddrTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IpAddrTableEntry();
    }

    public Set<Integer> getIfIndices() {
        TreeSet<Integer> ifIndices = new TreeSet<Integer>();
        for (IpAddrTableEntry entry : this.getEntries()) {
            Integer ifIndex = entry.getIpAdEntIfIndex();
            if (ifIndex == null) continue;
            ifIndices.add(ifIndex);
        }
        return ifIndices;
    }

    public InetAddress[] getIfAddressAndMask(int ifIndex) {
        InetAddress[] inetAddressArray;
        IpAddrTableEntry entry = this.getEntryByIfIndex(ifIndex);
        if (entry == null) {
            inetAddressArray = null;
        } else {
            InetAddress[] inetAddressArray2 = new InetAddress[2];
            inetAddressArray2[0] = entry.getIpAdEntAddr();
            inetAddressArray = inetAddressArray2;
            inetAddressArray2[1] = entry.getIpAdEntNetMask();
        }
        return inetAddressArray;
    }

    public InetAddress getIfAddress(int ifIndex) {
        IpAddrTableEntry entry = this.getEntryByIfIndex(ifIndex);
        return entry == null ? null : entry.getIpAdEntAddr();
    }

    public InetAddress getNetMask(int ifIndex) {
        IpAddrTableEntry entry = this.getEntryByIfIndex(ifIndex);
        return entry == null ? null : entry.getIpAdEntNetMask();
    }

    public InetAddress getNetMask(InetAddress address) {
        return this.getEntry(address) == null ? null : this.getEntry(address).getIpAdEntNetMask();
    }

    public Integer getIfIndex(InetAddress address) {
        return this.getEntry(address) == null ? null : this.getEntry(address).getIpAdEntIfIndex();
    }

    public IpAddrTableEntry getEntryByIfIndex(int ifIndex) {
        if (this.getEntries() == null) {
            return null;
        }
        for (IpAddrTableEntry entry : this.getEntries()) {
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            return entry;
        }
        return null;
    }

    public IpAddrTableEntry getEntry(InetAddress address) {
        return (IpAddrTableEntry)((Object)this.getEntry(new SnmpInstId(address.getHostAddress())));
    }

    protected final Category log() {
        return ThreadCategory.getInstance(IpAddrTable.class);
    }

    public void updateIpInterfaceData(OnmsNode node) {
        for (IpAddrTableEntry entry : this.getEntries()) {
            this.updateIpInterfaceData(node, entry.getIpAdEntAddr().getHostAddress());
        }
    }

    public void updateIpInterfaceData(OnmsNode node, String ipAddr) {
        InetAddress inetAddr;
        Integer ifIndex;
        OnmsIpInterface ipIf = node.getIpInterfaceByIpAddress(ipAddr);
        if (ipIf == null) {
            ipIf = new OnmsIpInterface(ipAddr, node);
        }
        if ((ifIndex = this.getIfIndex(inetAddr = ipIf.getInetAddress())) != null) {
            OnmsSnmpInterface snmpIf = node.getSnmpInterfaceWithIfIndex(ifIndex.intValue());
            if (snmpIf == null) {
                snmpIf = new OnmsSnmpInterface(ipAddr, ifIndex, node);
            }
            snmpIf.setIpAddress(ipAddr);
            InetAddress mask = this.getNetMask(inetAddr);
            if (mask != null) {
                snmpIf.setNetMask(mask.getHostAddress());
            }
            snmpIf.setCollectionEnabled(true);
            ipIf.setSnmpInterface(snmpIf);
        }
        ipIf.setIpHostName(ipAddr);
    }

    public Set<String> getIpAddresses() {
        LinkedHashSet<String> ipAddrs = new LinkedHashSet<String>();
        for (SnmpInstId inst : this.getInstances()) {
            ipAddrs.add(inst.toString());
        }
        return ipAddrs;
    }
}

