/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.snmp;

import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.provision.service.snmp.IfTableEntry;
import org.opennms.netmgt.provision.service.snmp.SnmpTable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IfTable
extends SnmpTable<IfTableEntry> {
    public IfTable(InetAddress address) {
        this(address, null);
    }

    public IfTable(InetAddress address, Set<SnmpInstId> ifIndices) {
        super(address, "ifTable", IfTableEntry.ms_elemList, ifIndices);
    }

    @Override
    protected IfTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IfTableEntry();
    }

    protected final Category log() {
        return ThreadCategory.getInstance(IfTable.class);
    }

    public Integer getOperStatus(int ifIndex) {
        return this.getEntry(ifIndex) == null ? null : ((IfTableEntry)((Object)this.getEntry(ifIndex))).getIfOperStatus();
    }

    public Integer getAdminStatus(int ifIndex) {
        return this.getEntry(ifIndex) == null ? null : ((IfTableEntry)((Object)this.getEntry(ifIndex))).getIfAdminStatus();
    }

    public Integer getIfType(int ifIndex) {
        return this.getEntry(ifIndex) == null ? null : ((IfTableEntry)((Object)this.getEntry(ifIndex))).getIfType();
    }

    public String getIfDescr(int ifIndex) {
        return this.getEntry(ifIndex) == null ? null : ((IfTableEntry)((Object)this.getEntry(ifIndex))).getIfDescr();
    }

    public Long getIfSpeed(int ifIndex) {
        return this.getEntry(ifIndex) == null ? null : ((IfTableEntry)((Object)this.getEntry(ifIndex))).getIfSpeed();
    }

    public String getPhysAddr(int ifIndex) {
        return this.getEntry(ifIndex) == null ? null : ((IfTableEntry)((Object)this.getEntry(ifIndex))).getPhysAddr();
    }

    public void updateSnmpInterfaceData(OnmsNode node) {
        for (IfTableEntry entry : this.getEntries()) {
            this.updateSnmpInterfaceData(node, entry.getIfIndex());
        }
    }

    public void updateSnmpInterfaceData(OnmsNode node, Integer ifIndex) {
        OnmsSnmpInterface snmpIf = node.getSnmpInterfaceWithIfIndex(ifIndex.intValue());
        if (snmpIf == null) {
            snmpIf = new OnmsSnmpInterface(null, ifIndex, node);
        }
        this.updateSnmpInterfaceData(ifIndex, snmpIf);
    }

    private void updateSnmpInterfaceData(Integer ifIndex, OnmsSnmpInterface snmpIf) {
        snmpIf.setIfType(this.getIfType(ifIndex));
        snmpIf.setIfAdminStatus(this.getAdminStatus(ifIndex));
        snmpIf.setIfDescr(this.getIfDescr(ifIndex));
        snmpIf.setIfSpeed(this.getIfSpeed(ifIndex));
        snmpIf.setPhysAddr(this.getPhysAddr(ifIndex));
    }

    public Set<Integer> getIfIndices() {
        LinkedHashSet<Integer> ifIndices = new LinkedHashSet<Integer>();
        for (SnmpInstId inst : this.getInstances()) {
            ifIndices.add(inst.toInt());
        }
        return ifIndices;
    }
}

