/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.operations;

import java.net.InetAddress;
import java.util.TreeSet;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.service.snmp.IfTable;
import org.opennms.netmgt.provision.service.snmp.IfXTable;
import org.opennms.netmgt.provision.service.snmp.IpAddrTable;
import org.opennms.netmgt.provision.service.snmp.SystemGroup;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;

public class ScanManager {
    private final InetAddress m_address;
    private SystemGroup m_systemGroup;
    private IfTable m_ifTable;
    private IpAddrTable m_ipAddrTable;
    private IfXTable m_ifXTable;

    ScanManager(InetAddress address) {
        this.m_address = address;
    }

    public SystemGroup getSystemGroup() {
        return this.m_systemGroup;
    }

    public IfTable getIfTable() {
        return this.m_ifTable;
    }

    public IpAddrTable getIpAddrTable() {
        return this.m_ipAddrTable;
    }

    public IfXTable getIfXTable() {
        return this.m_ifXTable;
    }

    String getNetMask(int ifIndex) {
        InetAddress addr = this.getIpAddrTable().getNetMask(ifIndex);
        return addr == null ? null : addr.getHostAddress();
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    boolean isSnmpDataForInterfacesUpToDate() {
        return !this.getIfTable().failed() && !this.getIpAddrTable().failed();
    }

    boolean isSnmpDataForNodeUpToDate() {
        return !this.getSystemGroup().failed();
    }

    void updateSnmpData(OnmsNode node) {
        try {
            this.m_systemGroup = new SystemGroup(this.m_address);
            TreeSet<SnmpInstId> ipAddrs = new TreeSet<SnmpInstId>();
            for (OnmsIpInterface iface : node.getIpInterfaces()) {
                ipAddrs.add(new SnmpInstId(iface.getIpAddress()));
            }
            this.m_ipAddrTable = new IpAddrTable(this.m_address, ipAddrs);
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(this.m_address);
            SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"system/ipAddrTable", (CollectionTracker[])new CollectionTracker[]{this.m_systemGroup, this.m_ipAddrTable});
            walker.start();
            walker.waitFor();
            TreeSet<SnmpInstId> ifIndices = new TreeSet<SnmpInstId>();
            for (Integer n : this.m_ipAddrTable.getIfIndices()) {
                ifIndices.add(new SnmpInstId(n.intValue()));
            }
            this.m_ifTable = new IfTable(this.m_address, ifIndices);
            this.m_ifXTable = new IfXTable(this.m_address, ifIndices);
            walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"ifTable/ifXTable", (CollectionTracker[])new CollectionTracker[]{this.m_ifTable, this.m_ifXTable});
            walker.start();
            walker.waitFor();
            this.m_systemGroup.updateSnmpDataForNode(node);
            for (SnmpInstId snmpInstId : ifIndices) {
                this.m_ifTable.updateSnmpInterfaceData(node, snmpInstId.toInt());
            }
            for (SnmpInstId snmpInstId : ifIndices) {
                this.m_ifXTable.updateSnmpInterfaceData(node, snmpInstId.toInt());
            }
            for (SnmpInstId snmpInstId : ipAddrs) {
                this.m_ipAddrTable.updateIpInterfaceData(node, snmpInstId.toString());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public AggregateTracker createCollectionTracker() {
        return new AggregateTracker((Collectable[])new CollectionTracker[]{this.getSystemGroup(), this.getIfTable(), this.getIpAddrTable(), this.getIfXTable()});
    }
}

