/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.Task;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleInstance;
import org.opennms.netmgt.provision.service.lifecycle.annotations.Activity;
import org.opennms.netmgt.provision.service.lifecycle.annotations.Attribute;

public class Phase
extends BatchTask {
    private LifeCycleInstance m_lifecycle;
    private String m_name;
    private Object[] m_providers;

    public Phase(ContainerTask parent, LifeCycleInstance lifecycle, String name, Object[] providers) {
        super(lifecycle.getCoordinator(), parent);
        this.m_lifecycle = lifecycle;
        this.m_name = name;
        this.m_providers = providers;
        this.addPhaseMethods();
    }

    public String getName() {
        return this.m_name;
    }

    public LifeCycleInstance getLifeCycleInstance() {
        return this.m_lifecycle;
    }

    public LifeCycleInstance createNestedLifeCycle(String lifeCycleName) {
        return this.m_lifecycle.createNestedLifeCycle(this, lifeCycleName);
    }

    public void addPhaseMethods() {
        for (Object provider : this.m_providers) {
            this.addPhaseMethods(provider);
        }
    }

    public void addPhaseMethods(Object provider) {
        for (Method method : provider.getClass().getMethods()) {
            String schedulingHint = this.isPhaseMethod(method);
            if (schedulingHint == null) continue;
            this.add((Task)this.createPhaseMethod(provider, method, schedulingHint));
        }
    }

    private String isPhaseMethod(Method method) {
        Activity activity = method.getAnnotation(Activity.class);
        if (activity != null && activity.phase().equals(this.m_name) && activity.lifecycle().equals(this.m_lifecycle.getName())) {
            return activity.schedulingHint();
        }
        return null;
    }

    PhaseMethod createPhaseMethod(Object provider, Method method, String schedulingHint) {
        return new PhaseMethod(this, provider, method, schedulingHint);
    }

    public String toString() {
        return String.format("Phase %s of lifecycle %s", this.getName(), this.m_lifecycle.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhaseMethod
    extends BatchTask {
        private Phase m_phase;
        private Object m_target;
        private Method m_method;

        public PhaseMethod(Phase phase, Object target, Method method, String schedulingHint) {
            super(phase.getCoordinator(), (ContainerTask)phase);
            this.m_phase = phase;
            this.m_target = target;
            this.m_method = method;
            this.add(this.phaseRunner(), schedulingHint);
        }

        private Runnable phaseRunner() {
            return new Runnable(){

                public void run() {
                    try {
                        PhaseMethod.this.doInvoke(PhaseMethod.this.m_phase.getLifeCycleInstance());
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }

                public String toString() {
                    return "Runner for " + PhaseMethod.this.m_phase.toString();
                }
            };
        }

        private void doInvoke(LifeCycleInstance lifeCycle) throws IllegalAccessException, InvocationTargetException {
            lifeCycle.setAttribute("currentPhase", (Object)this.m_phase);
            Object[] args = this.findArguments(lifeCycle);
            Object retVal = this.m_method.invoke(this.m_target, args);
            Attribute retValAttr = this.m_method.getAnnotation(Attribute.class);
            if (retValAttr != null) {
                lifeCycle.setAttribute(retValAttr.value(), retVal);
            } else if (retVal instanceof Task) {
                this.add((Task)retVal);
            } else if (retVal != null) {
                lifeCycle.setAttribute(retVal.getClass().getName(), retVal);
            }
        }

        private Object[] findArguments(LifeCycleInstance lifeCycle) {
            Type[] types = this.m_method.getGenericParameterTypes();
            Object[] args = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                Attribute annot = this.getParameterAnnotation(this.m_method, i, Attribute.class);
                if (annot != null) {
                    args[i] = lifeCycle.getAttribute(annot.value());
                    continue;
                }
                Type type = types[i];
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    args[i] = lifeCycle.findAttributeByType(clazz);
                    continue;
                }
                args[i] = null;
            }
            return args;
        }

        private <T extends Annotation> T getParameterAnnotation(Method method, int parmIndex, Class<T> annotationClass) {
            Annotation[] annotations;
            for (Annotation a : annotations = method.getParameterAnnotations()[parmIndex]) {
                if (!annotationClass.isInstance(a)) continue;
                return (T)((Annotation)annotationClass.cast(a));
            }
            return null;
        }

        public String toString() {
            return String.format("%s.%s(%s)", this.m_target.getClass().getSimpleName(), this.m_method.getName(), this.m_phase.getLifeCycleInstance());
        }
    }
}

