/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.dns;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.persist.ProvisionPrefixContextResolver;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.Type;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnsRequisitionUrlConnection
extends URLConnection {
    private static final String EXPRESSION_ARG = "expression";
    private static final String QUERY_ARG_SEPARATOR = "&";
    public static final String URL_SCHEME = "dns://";
    public static final String PROTOCOL = "dns";
    private String m_zone;
    private Long m_serial;
    private Boolean m_fallback;
    private TSIG m_key;
    private URL m_url;
    private int m_port;
    private String m_foreignSource;

    protected DnsRequisitionUrlConnection(URL url) throws MalformedURLException {
        super(url);
        DnsRequisitionUrlConnection.validateDnsUrl(url);
        this.m_url = url;
        this.m_port = url.getPort() == -1 ? 53 : url.getPort();
        this.m_zone = DnsRequisitionUrlConnection.parseZone(url);
        this.m_foreignSource = DnsRequisitionUrlConnection.parseForeignSource(url);
        if (this.m_zone == null) {
            throw new IllegalArgumentException("Specified Zone is null");
        }
        this.m_serial = 0L;
        this.m_fallback = false;
        this.m_key = null;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ByteArrayInputStream stream = null;
        try {
            Requisition r = this.buildRequisitionFromZoneTransfer();
            stream = new ByteArrayInputStream(this.jaxBMarshal(r).getBytes());
        }
        catch (IOException e) {
            DnsRequisitionUrlConnection.log().warn((Object)("getInputStream: Problem getting input stream: " + e), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String message = "Problem getting input stream: " + e;
            DnsRequisitionUrlConnection.log().warn((Object)message, (Throwable)e);
            throw new IOExceptionWithCause(message, (Throwable)e);
        }
        return stream;
    }

    private Requisition buildRequisitionFromZoneTransfer() throws IOException, ZoneTransferException {
        ZoneTransferIn xfer = ZoneTransferIn.newIXFR((Name)new Name(this.m_zone), (long)this.m_serial, (boolean)this.m_fallback, (String)this.m_url.getHost(), (int)this.m_port, (TSIG)this.m_key);
        List<Record> records = this.getRecords(xfer);
        Requisition r = null;
        if (records.size() > 0) {
            r = new Requisition(this.getForeignSource());
            for (Record rec : records) {
                if (!this.matchingRecord(rec)) continue;
                r.insertNode(this.createRequisitionNode(rec));
            }
        }
        return r;
    }

    private List<Record> getRecords(ZoneTransferIn xfer) throws IOException, ZoneTransferException {
        return xfer.run();
    }

    private RequisitionNode createRequisitionNode(Record rec) {
        ARecord arec = (ARecord)rec;
        String addr = StringUtils.stripStart((String)arec.getAddress().toString(), (String)"/");
        RequisitionNode n = new RequisitionNode();
        String host = rec.getName().toString();
        String nodeLabel = StringUtils.stripStart((String)host, (String)".");
        n.setBuilding(this.getForeignSource());
        n.setForeignId(this.computeHashCode(nodeLabel));
        n.setNodeLabel(nodeLabel);
        RequisitionInterface i = new RequisitionInterface();
        i.setDescr("DNS-A");
        i.setIpAddr(addr);
        i.setSnmpPrimary("P");
        i.setManaged(Boolean.valueOf(true));
        i.setStatus(Integer.valueOf(1));
        i.insertMonitoredService(new RequisitionMonitoredService("ICMP"));
        i.insertMonitoredService(new RequisitionMonitoredService("SNMP"));
        n.insertInterface(i);
        return n;
    }

    private boolean matchingRecord(Record rec) {
        DnsRequisitionUrlConnection.log().info((Object)("matchingRecord: checking rec: " + rec + " to see if it should be imported..."));
        boolean matches = false;
        if ("A".equals(Type.string((int)rec.getType()))) {
            DnsRequisitionUrlConnection.log().debug((Object)"matchingRecord: record is a an A record, continuing...");
            String expression = DnsRequisitionUrlConnection.determineExpressionFromUrl(this.getUrl());
            if (expression != null) {
                Pattern p = Pattern.compile(expression);
                Matcher m = p.matcher(rec.getName().toString());
                DnsRequisitionUrlConnection.log().debug((Object)("matchingRecord: attempting to match record: [" + rec.getName().toString() + "] with expression: [" + expression + "]"));
                if (m.matches()) {
                    matches = true;
                }
                DnsRequisitionUrlConnection.log().debug((Object)("matchingRecord: record matches expression: " + matches));
            } else {
                DnsRequisitionUrlConnection.log().debug((Object)"matchingRecord: on expression for this zone, returning valid match for this A record...");
                matches = true;
            }
        }
        DnsRequisitionUrlConnection.log().info((Object)("matchingRecord: record: " + rec + " matches: " + matches));
        return matches;
    }

    private String computeHashCode(String nodeLabel) {
        String hash = String.valueOf(nodeLabel.hashCode());
        return hash;
    }

    @Override
    public URL getURL() {
        return super.getURL();
    }

    private String jaxBMarshal(Requisition r) throws JAXBException {
        ProvisionPrefixContextResolver cr = new ProvisionPrefixContextResolver();
        JAXBContext context = cr.getContext(r.getClass());
        Marshaller m = context.createMarshaller();
        StringWriter w = new StringWriter();
        m.marshal((Object)r, (Writer)w);
        String xml = ((Object)w).toString();
        return xml;
    }

    public String getZone() {
        return this.m_zone;
    }

    public Long getSerial() {
        return this.m_serial;
    }

    public void setSerial(Long serial) {
        this.m_serial = serial;
    }

    public Boolean getFallback() {
        return this.m_fallback;
    }

    public void setFallback(Boolean fallback) {
        this.m_fallback = fallback;
    }

    public TSIG getKey() {
        return this.m_key;
    }

    public void setKey(TSIG key) {
        this.m_key = key;
    }

    public String getDescription() {
        return this.m_url.toString();
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    public URL getUrl() {
        return this.m_url;
    }

    protected static String determineExpressionFromUrl(URL url) {
        DnsRequisitionUrlConnection.log().info((Object)("determineExpressionFromUrl: finding regex as parameter in query string of URL: " + url));
        if (url.getQuery() == null) {
            return null;
        }
        String query = DnsRequisitionUrlConnection.decodeQueryString(url);
        List<String> queryArgs = DnsRequisitionUrlConnection.tokenizeQueryArgs(query);
        HashMap<String, String> args = new HashMap<String, String>();
        for (String queryArg : queryArgs) {
            String[] argTokens = StringUtils.split((String)queryArg, (char)'=');
            if (argTokens.length < 2) {
                DnsRequisitionUrlConnection.log().warn((Object)("determineExpressionFromUrl: syntax error in URL query string, missing '=' in query argument: " + queryArg));
                continue;
            }
            args.put(argTokens[0].toLowerCase(), argTokens[1]);
        }
        return (String)args.get(EXPRESSION_ARG);
    }

    private static List<String> tokenizeQueryArgs(String query) throws IllegalArgumentException {
        if (query == null) {
            throw new IllegalArgumentException("The URL query is null");
        }
        ArrayList<String> queryArgs = new ArrayList();
        queryArgs = Arrays.asList(StringUtils.split((String)query, (String)QUERY_ARG_SEPARATOR));
        return queryArgs;
    }

    protected static String decodeQueryString(URL url) {
        String query = null;
        if (url == null || url.getQuery() == null) {
            throw new IllegalArgumentException("The URL or the URL query is null: " + url);
        }
        try {
            query = URLDecoder.decode(url.getQuery(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            DnsRequisitionUrlConnection.log().error((Object)("decodeQueryString: " + e), (Throwable)e);
        }
        return query;
    }

    protected static void validateDnsUrl(URL url) throws MalformedURLException {
        String path = url.getPath();
        path = StringUtils.removeStart((String)path, (String)"/");
        if ((path = StringUtils.removeEnd((String)path, (String)"/")) == null || StringUtils.countMatches((String)path, (String)"/") > 1) {
            throw new MalformedURLException("The specified DNS URL contains invalid path: " + url);
        }
        String query = url.getQuery();
        if (query != null && DnsRequisitionUrlConnection.determineExpressionFromUrl(url) == null) {
            throw new MalformedURLException("The specified DNS URL contains an invalid query string: " + url);
        }
    }

    protected static String parseZone(URL url) {
        String path = url.getPath();
        path = StringUtils.removeStart((String)path, (String)"/");
        String zone = path = StringUtils.removeEnd((String)path, (String)"/");
        if (path != null && StringUtils.countMatches((String)path, (String)"/") == 1) {
            String[] paths = path.split("/");
            zone = paths[0];
        }
        return zone;
    }

    protected static String parseForeignSource(URL url) {
        String path = url.getPath();
        path = StringUtils.removeStart((String)path, (String)"/");
        String foreignSource = path = StringUtils.removeEnd((String)path, (String)"/");
        if (path != null && StringUtils.countMatches((String)path, (String)"/") == 1) {
            String[] paths = path.split("/");
            foreignSource = paths[1];
        }
        return foreignSource;
    }

    private static Logger log() {
        return ThreadCategory.getInstance(DnsRequisitionUrlConnection.class);
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }
}

