/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.util.Collection;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.EventSubscriptionService;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.provision.ProvisioningAdapter;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.service.PluginRegistry;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

@EventListener(name="ProvisioningAdapterManager:EventListener")
public class ProvisioningAdapterManager
implements InitializingBean {
    private PluginRegistry m_pluginRegistry;
    private Collection<ProvisioningAdapter> m_adapters;
    private volatile EventSubscriptionService m_eventSubscriptionService;
    private volatile EventForwarder m_eventForwarder;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_pluginRegistry, (String)"pluginRegistry must be set");
        Assert.notNull((Object)this.m_eventSubscriptionService);
        this.m_adapters = this.m_pluginRegistry.getAllPlugins(ProvisioningAdapter.class);
    }

    public PluginRegistry getPluginRegistry() {
        return this.m_pluginRegistry;
    }

    public void setPluginRegistry(PluginRegistry pluginRegistry) {
        this.m_pluginRegistry = pluginRegistry;
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeAdded")
    public void handleNodeAddedEvent(Event e) {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            this.log().info((Object)("handleNodeAddedEvent: Calling adapter:" + adapter.getName() + " for node: " + e.getNodeid()));
            try {
                adapter.addNode((int)e.getNodeid());
            }
            catch (ProvisioningAdapterException pae) {
                this.log().error((Object)("handleNodeAddedEvent: Adapter threw known exception: " + adapter.getName()), (Throwable)pae);
            }
            catch (Throwable t) {
                this.log().error((Object)("handleNodeAddedEvent: Unanticpated exception when calling adapter: " + adapter.getName()), t);
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeUpdated")
    public void handleNodeUpdatedEvent(Event e) {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            this.log().info((Object)("handleNodeUpdatedEvent: Calling adapter:" + adapter.getName() + " for node: " + e.getNodeid()));
            try {
                adapter.updateNode((int)e.getNodeid());
            }
            catch (ProvisioningAdapterException pae) {
                this.log().error((Object)("handleNodeUpdatedEvent: Adapter threw known exception: " + adapter.getName()), (Throwable)pae);
            }
            catch (Throwable t) {
                this.log().error((Object)("handleNodeUpdatedEvent: Unanticpated exception when calling adapter: " + adapter.getName()), t);
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeletedEvent(Event e) {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            this.log().info((Object)("handleNodeDeletedEvent: Calling adapter:" + adapter.getName() + " for node: " + e.getNodeid()));
            try {
                adapter.deleteNode((int)e.getNodeid());
            }
            catch (ProvisioningAdapterException pae) {
                this.log().error((Object)("handleNodeDeletedEvent: Adapter threw known exception: " + adapter.getName()), (Throwable)pae);
            }
            catch (Throwable t) {
                this.log().error((Object)("handleNodeDeletedEvent: Unanticpated exception when calling adapter: " + adapter.getName()), t);
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/translator/entityConfigChanged")
    public void handleNodeChangedEvent(Event e) {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            this.log().info((Object)("handleNodeChangedEvent: Calling adapter:" + adapter.getName() + " for node: " + e.getNodeid()));
            try {
                if (e.getNodeid() != 0L) {
                    adapter.nodeConfigChanged((int)e.getNodeid());
                    continue;
                }
                this.log().warn((Object)("handleNodeChangedEvent: received configChanged event without nodeId: " + e));
            }
            catch (ProvisioningAdapterException pae) {
                this.log().error((Object)("handleNodeChangedEvent: Adapter threw known exception: " + adapter.getName()), (Throwable)pae);
            }
            catch (Throwable t) {
                this.log().error((Object)("handleNodeChangedEvent: Unanticpated exception when calling adapter: " + adapter.getName()), t);
            }
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void setEventSubscriptionService(EventSubscriptionService eventSubscriptionService) {
        this.m_eventSubscriptionService = eventSubscriptionService;
    }

    public EventSubscriptionService getEventSubscriptionService() {
        return this.m_eventSubscriptionService;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void initializeAdapters() {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            adapter.init();
        }
    }
}

