/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.EventSubscriptionService;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.provision.service.ImportManager;
import org.opennms.netmgt.provision.service.ImportScheduler;
import org.opennms.netmgt.provision.service.NodeScan;
import org.opennms.netmgt.provision.service.NodeScanSchedule;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.ProvisioningAdapterManager;
import org.opennms.netmgt.provision.service.TimeTrackingMonitor;
import org.opennms.netmgt.provision.service.dns.DnsUrlFactory;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleInstance;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleRepository;
import org.opennms.netmgt.provision.service.operations.NoOpProvisionMonitor;
import org.opennms.netmgt.provision.service.operations.ProvisionMonitor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EventListener(name="Provisiond:EventListener")
public class Provisioner
implements SpringServiceDaemon {
    public static final String NAME = "Provisioner";
    private List<Object> m_providers;
    private LifeCycleRepository m_lifeCycleRepository;
    private ProvisionService m_provisionService;
    private ScheduledExecutorService m_scheduledExecutor;
    private final Map<Integer, ScheduledFuture<?>> m_scheduledNodes = new ConcurrentHashMap();
    private volatile EventSubscriptionService m_eventSubscriptionService;
    private volatile EventForwarder m_eventForwarder;
    private volatile TimeTrackingMonitor m_stats;
    @Autowired
    private ProvisioningAdapterManager m_manager;
    private ImportScheduler m_importSchedule;

    public void setProvisionService(ProvisionService provisionService) {
        this.m_provisionService = provisionService;
    }

    public ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.m_scheduledExecutor = scheduledExecutor;
    }

    public void setLifeCycleRepository(LifeCycleRepository lifeCycleRepository) {
        this.m_lifeCycleRepository = lifeCycleRepository;
    }

    public void setProviders(List<Object> providers) {
        this.m_providers = providers;
    }

    public void setImportSchedule(ImportScheduler schedule) {
        this.m_importSchedule = schedule;
    }

    public ImportScheduler getImportSchedule() {
        return this.m_importSchedule;
    }

    public void start() throws Exception {
        this.m_manager.initializeAdapters();
        this.scheduleRescanForExistingNodes();
        this.m_importSchedule.start();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getProvisionService(), (String)"provisionService property must be set");
        Assert.notNull((Object)this.m_scheduledExecutor, (String)"scheduledExecutor property must be set");
        Assert.notNull((Object)this.m_lifeCycleRepository, (String)"lifeCycleRepository property must be set");
        try {
            new URL("dns://localhost/localhost");
        }
        catch (MalformedURLException e) {
            URL.setURLStreamHandlerFactory(new DnsUrlFactory());
        }
    }

    protected void scheduleRescanForExistingNodes() {
        List<NodeScanSchedule> schedules = this.m_provisionService.getScheduleForNodes();
        this.checkNodeListForRemovals(schedules);
        for (NodeScanSchedule schedule : schedules) {
            if (!this.m_scheduledNodes.containsKey(schedule.getNodeId())) {
                this.addToScheduleQueue(schedule);
                continue;
            }
            this.updateNodeScheduleInQueue(schedule);
        }
    }

    public void doNodeScan(int nodeId) throws InterruptedException, ExecutionException {
    }

    public NodeScan createNodeScan(Integer nodeId, String foreignSource, String foreignId) {
        this.log().warn((Object)"createNodeScan called");
        return new NodeScan(nodeId, foreignSource, foreignId, this.m_provisionService, this.m_eventForwarder, this.m_lifeCycleRepository, this.m_providers);
    }

    protected void addToScheduleQueue(NodeScanSchedule schedule) {
        ScheduledFuture<?> future = this.scheduleNodeScan(schedule);
        this.log().warn((Object)("addToScheduleQueue future = " + future));
        this.m_scheduledNodes.put(schedule.getNodeId(), future);
    }

    protected void updateNodeScheduleInQueue(NodeScanSchedule schedule) {
        ScheduledFuture<?> scheduledFuture = this.getScheduledFutureForNode(schedule.getNodeId());
        if (!scheduledFuture.isDone() && !scheduledFuture.isCancelled()) {
            scheduledFuture.cancel(true);
            scheduledFuture = this.scheduleNodeScan(schedule);
            this.m_scheduledNodes.put(schedule.getNodeId(), scheduledFuture);
        }
    }

    private ScheduledFuture<?> scheduleNodeScan(NodeScanSchedule schedule) {
        NodeScan nodeScan = this.createNodeScan(schedule.getNodeId(), schedule.getForeignSource(), schedule.getForeignId());
        this.log().warn((Object)("nodeScan = " + nodeScan));
        return nodeScan.schedule(this.m_scheduledExecutor, schedule);
    }

    public ScheduledFuture<?> getScheduledFutureForNode(int nodeId) {
        ScheduledFuture<?> scheduledFuture = this.m_scheduledNodes.get(nodeId);
        return scheduledFuture;
    }

    protected void removeNodeFromScheduleQueue(Integer nodeId) {
        ScheduledFuture<?> scheduledFuture = this.m_scheduledNodes.remove(nodeId);
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            scheduledFuture.cancel(true);
        }
    }

    protected void removeFromScheduleQueue(List<Integer> nodeIds) {
        for (Integer nodeId : nodeIds) {
            this.removeNodeFromScheduleQueue(nodeId);
        }
    }

    protected void checkNodeListForRemovals(List<NodeScanSchedule> schedules) {
        Set<Integer> keySet = this.m_scheduledNodes.keySet();
        ArrayList<Integer> markedForDelete = new ArrayList<Integer>();
        for (int nodeId : keySet) {
            boolean isDirty = false;
            for (NodeScanSchedule schedule : schedules) {
                if (schedule.getNodeId() != nodeId) continue;
                isDirty = true;
            }
            if (isDirty) continue;
            markedForDelete.add(nodeId);
        }
        this.removeFromScheduleQueue(markedForDelete);
    }

    public int getScheduleLength() {
        return this.m_scheduledNodes.size();
    }

    protected void importModelFromResource(Resource resource) throws Exception {
        this.importModelFromResource(resource, new NoOpProvisionMonitor());
    }

    protected void importModelFromResource(Resource resource, ProvisionMonitor monitor) throws Exception {
        this.doImport(resource, monitor, new ImportManager());
    }

    private void doImport(Resource resource, ProvisionMonitor monitor, ImportManager importManager) throws Exception {
        LifeCycleInstance doImport = this.m_lifeCycleRepository.createLifeCycleInstance("import", this.m_providers.toArray());
        doImport.setAttribute("resource", resource);
        doImport.trigger();
        doImport.waitFor();
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public EventSubscriptionService getEventSubscriptionService() {
        return this.m_eventSubscriptionService;
    }

    public void setEventSubscriptionService(EventSubscriptionService eventManager) {
        this.m_eventSubscriptionService = eventManager;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void doImport() {
        Event e = null;
        this.doImport(e);
    }

    @EventHandler(uei="uei.opennms.org/internal/importer/reloadImport")
    public void doImport(Event event) {
        String url = this.getEventUrl(event);
        if (url != null) {
            this.doImport(url);
        } else {
            String msg = "reloadImport event requires 'url' paramter";
            this.log().error((Object)("doImport: " + msg));
            this.send(this.importFailedEvent(msg, url));
        }
    }

    public void doImport(String url) {
        try {
            this.log().info((Object)("doImport: importing from url: " + url + "..."));
            UrlResource resource = new UrlResource(url);
            this.m_stats = new TimeTrackingMonitor();
            this.send(this.importStartedEvent((Resource)resource));
            this.importModelFromResource((Resource)resource, this.m_stats);
            this.log().info((Object)("Finished Importing: " + this.m_stats));
            this.send(this.importSuccessEvent(this.m_stats, url));
        }
        catch (Exception e) {
            String msg = "Exception importing " + url;
            this.log().error((Object)msg, (Throwable)e);
            this.send(this.importFailedEvent(msg + ": " + e.getMessage(), url));
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeAdded")
    public void handleNodeAddedEvent(Event e) {
        NodeScanSchedule scheduleForNode = null;
        this.log().warn((Object)("node added event (" + System.currentTimeMillis() + ")"));
        try {
            scheduleForNode = this.getProvisionService().getScheduleForNode(new Long(e.getNodeid()).intValue(), true);
        }
        catch (Throwable t) {
            this.log().error((Object)"getScheduleForNode fails", t);
        }
        this.log().warn((Object)("scheduleForNode is " + scheduleForNode));
        if (scheduleForNode != null) {
            this.addToScheduleQueue(scheduleForNode);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/forceRescan")
    public void handleForceRescan(Event e) {
        this.removeNodeFromScheduleQueue(new Long(e.getNodeid()).intValue());
        NodeScanSchedule scheduleForNode = this.getProvisionService().getScheduleForNode(new Long(e.getNodeid()).intValue(), true);
        if (scheduleForNode != null) {
            this.addToScheduleQueue(scheduleForNode);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeUpdated")
    public void handleNodeUpdated(Event e) {
        this.removeNodeFromScheduleQueue(new Long(e.getNodeid()).intValue());
        NodeScanSchedule scheduleForNode = this.getProvisionService().getScheduleForNode(new Long(e.getNodeid()).intValue(), true);
        if (scheduleForNode != null) {
            this.addToScheduleQueue(scheduleForNode);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeletedEvent(Event e) {
        this.removeNodeFromScheduleQueue(new Long(e.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event e) {
        if (this.isReloadConfigEventTarget(e)) {
            this.log().info((Object)"handleReloadConfigEvent: reloading configuration...");
            EventBuilder ebldr = null;
            try {
                this.log().debug((Object)"handleReloadConfigEvent: lock acquired, unscheduling current reports...");
                this.m_importSchedule.rebuildImportSchedule();
                this.log().debug((Object)"handleRelodConfigEvent: reports rescheduled.");
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Provisiond");
                ebldr.addParam("daemonName", "Statsd");
            }
            catch (Exception exception) {
                this.log().error((Object)("handleReloadConfigurationEvent: Error reloading configuration:" + exception), (Throwable)exception);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Provisiond");
                ebldr.addParam("daemonName", "Provisiond");
                ebldr.addParam("reason", exception.getLocalizedMessage().substring(1, 128));
            }
            if (ebldr != null) {
                this.getEventForwarder().sendNow(ebldr.getEvent());
            }
            this.log().info((Object)"handleReloadConfigEvent: configuration reloaded.");
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParms().getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Provisiond".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        this.log().debug((Object)("isReloadConfigEventTarget: Provisiond was target of reload event: " + isTarget));
        return isTarget;
    }

    private String getEventUrl(Event event) {
        return EventUtils.getParm((Event)event, (String)"url");
    }

    public String getStats() {
        return this.m_stats == null ? "No Stats Availabile" : this.m_stats.toString();
    }

    private Event importSuccessEvent(TimeTrackingMonitor stats, String url) {
        return new EventBuilder("uei.opennms.org/internal/importer/importSuccessful", NAME).addParam("importResource", url).addParam("importStats", stats.toString()).getEvent();
    }

    private void send(Event event) {
        this.getEventForwarder().sendNow(event);
    }

    private Event importFailedEvent(String msg, String url) {
        return new EventBuilder("uei.opennms.org/internal/importer/importFailed", NAME).addParam("importResource", url).addParam("failureMessage", msg).getEvent();
    }

    private Event importStartedEvent(Resource resource) {
        return new EventBuilder("uei.opennms.org/internal/importer/importStarted", NAME).addParam("importResource", resource.toString()).getEvent();
    }

    protected String getEventForeignSource(Event event) {
        return EventUtils.getParm((Event)event, (String)"foreignSource");
    }
}

