/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;

public class PhysInterfaceTableTracker
extends TableTracker {
    public static final SnmpObjId IF_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1");
    public static final SnmpObjId IF_INDEX = SnmpObjId.get((SnmpObjId)IF_TABLE_ENTRY, (String)"1");
    public static final SnmpObjId IF_DESCR = SnmpObjId.get((SnmpObjId)IF_TABLE_ENTRY, (String)"2");
    public static final SnmpObjId IF_TYPE = SnmpObjId.get((SnmpObjId)IF_TABLE_ENTRY, (String)"3");
    public static final SnmpObjId IF_MTU = SnmpObjId.get((SnmpObjId)IF_TABLE_ENTRY, (String)"4");
    public static final SnmpObjId IF_SPEED = SnmpObjId.get((SnmpObjId)IF_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId IF_PHYS_ADDR = SnmpObjId.get((SnmpObjId)IF_TABLE_ENTRY, (String)"6");
    public static final SnmpObjId IF_ADMIN_STATUS = SnmpObjId.get((SnmpObjId)IF_TABLE_ENTRY, (String)"7");
    public static final SnmpObjId IF_OPER_STATUS = SnmpObjId.get((SnmpObjId)IF_TABLE_ENTRY, (String)"8");
    public static final SnmpObjId IF_LAST_CHANGE = SnmpObjId.get((SnmpObjId)IF_TABLE_ENTRY, (String)"9");
    public static final SnmpObjId IF_XTABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.31.1.1.1");
    public static final SnmpObjId IF_NAME = SnmpObjId.get((SnmpObjId)IF_XTABLE_ENTRY, (String)"1");
    public static final SnmpObjId IF_IN_MCAST_PKTS = SnmpObjId.get((SnmpObjId)IF_XTABLE_ENTRY, (String)"2");
    public static final SnmpObjId IF_IN_BCAST_PKTS = SnmpObjId.get((SnmpObjId)IF_XTABLE_ENTRY, (String)"3");
    public static final SnmpObjId IF_OUT_MCAST_PKTS = SnmpObjId.get((SnmpObjId)IF_XTABLE_ENTRY, (String)"4");
    public static final SnmpObjId IF_LINK_UP_DOWN_TRAP_ENABLE = SnmpObjId.get((SnmpObjId)IF_XTABLE_ENTRY, (String)"14");
    public static final SnmpObjId IF_HIGH_SPEED = SnmpObjId.get((SnmpObjId)IF_XTABLE_ENTRY, (String)"15");
    public static final SnmpObjId IF_PROMISCUOUS_MODE = SnmpObjId.get((SnmpObjId)IF_XTABLE_ENTRY, (String)"16");
    public static final SnmpObjId IF_CONNECTOR_PRESENT = SnmpObjId.get((SnmpObjId)IF_XTABLE_ENTRY, (String)"17");
    public static final SnmpObjId IF_ALIAS = SnmpObjId.get((SnmpObjId)IF_XTABLE_ENTRY, (String)"18");
    public static final SnmpObjId IF_COUNTER_DISCONTINUITY_TIME = SnmpObjId.get((SnmpObjId)IF_XTABLE_ENTRY, (String)"19");
    private static SnmpObjId[] s_tableColumns = new SnmpObjId[]{IF_INDEX, IF_DESCR, IF_TYPE, IF_MTU, IF_SPEED, IF_PHYS_ADDR, IF_ADMIN_STATUS, IF_OPER_STATUS, IF_LAST_CHANGE, IF_NAME, IF_ALIAS, IF_HIGH_SPEED};

    public PhysInterfaceTableTracker() {
        super(s_tableColumns);
    }

    public PhysInterfaceTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_tableColumns);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new PhysicalInterfaceRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processPhysicalInterfaceRow((PhysicalInterfaceRow)row);
    }

    public void processPhysicalInterfaceRow(PhysicalInterfaceRow row) {
    }

    class PhysicalInterfaceRow
    extends SnmpRowResult {
        public PhysicalInterfaceRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public Integer getIfIndex() {
            SnmpValue value = this.getValue(IF_INDEX);
            return value == null ? null : Integer.valueOf(value.toInt());
        }

        private Integer getIfType() {
            SnmpValue value = this.getValue(IF_TYPE);
            return value == null ? null : Integer.valueOf(value.toInt());
        }

        private Long getIfSpeed() {
            SnmpValue value = this.getValue(IF_SPEED);
            return value == null ? null : Long.valueOf(value.toLong());
        }

        private Long getIfHighSpeed() {
            SnmpValue value = this.getValue(IF_HIGH_SPEED);
            return value == null ? null : Long.valueOf(value.toLong() * 1000000L);
        }

        private Long getSpeed() {
            Long highSpeed = this.getIfHighSpeed();
            return highSpeed != null && highSpeed > 0L ? highSpeed : this.getIfSpeed();
        }

        private Integer getIfOperStatus() {
            SnmpValue value = this.getValue(IF_OPER_STATUS);
            return value == null ? null : Integer.valueOf(value.toInt());
        }

        private String getIfName() {
            SnmpValue value = this.getValue(IF_NAME);
            return value == null ? null : value.toDisplayString();
        }

        private String getIfDescr() {
            SnmpValue value = this.getValue(IF_DESCR);
            return value == null ? null : value.toDisplayString();
        }

        private String getIfAlias() {
            SnmpValue value = this.getValue(IF_ALIAS);
            return value == null ? null : value.toDisplayString();
        }

        private Integer getIfAdminStatus() {
            SnmpValue value = this.getValue(IF_ADMIN_STATUS);
            return value == null ? null : Integer.valueOf(value.toInt());
        }

        public OnmsSnmpInterface createInterfaceFromRow() {
            OnmsSnmpInterface snmpIface = new OnmsSnmpInterface("0.0.0.0", this.getIfIndex(), null);
            snmpIface.setIfAdminStatus(this.getIfAdminStatus());
            snmpIface.setIfAlias(this.getIfAlias());
            snmpIface.setIfDescr(this.getIfDescr());
            snmpIface.setIfName(this.getIfName());
            snmpIface.setIfOperStatus(this.getIfOperStatus());
            snmpIface.setIfSpeed(this.getSpeed());
            snmpIface.setIfType(this.getIfType());
            return snmpIface;
        }
    }
}

