/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.provision.service.NodeScanSchedule;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleInstance;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleRepository;
import org.opennms.netmgt.provision.service.lifecycle.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeScan
implements Runnable {
    private Integer m_nodeId;
    private String m_foreignSource;
    private String m_foreignId;
    private ProvisionService m_provisionService;
    private EventForwarder m_eventForwarder;
    private LifeCycleRepository m_lifeCycleRepository;
    private List<Object> m_providers;
    private boolean m_aborted = false;
    private OnmsNode m_node;

    public NodeScan(Integer nodeId, String foreignSource, String foreignId, ProvisionService provisionService, EventForwarder eventForwarder, LifeCycleRepository lifeCycleRepository, List<Object> providers) {
        this.m_nodeId = nodeId;
        this.m_foreignSource = foreignSource;
        this.m_foreignId = foreignId;
        this.m_provisionService = provisionService;
        this.m_lifeCycleRepository = lifeCycleRepository;
        this.m_providers = providers;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public String getForeignId() {
        return this.m_foreignId;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public OnmsNode getNode() {
        return this.m_node;
    }

    public boolean isAborted() {
        return this.m_aborted;
    }

    public void abort(String reason) {
        this.m_aborted = true;
        this.log().info((Object)String.format("Aborting Scan of node %d for the following reason: %s", this.m_nodeId, reason));
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/provisiond/nodeScanAborted", "Provisiond");
        if (this.m_nodeId != null) {
            bldr.setNodeid(this.m_nodeId.intValue());
        }
        bldr.addParam("foreignSource", this.m_foreignSource);
        bldr.addParam("foreignId", this.m_foreignId);
        bldr.addParam("reason", reason);
        this.m_eventForwarder.sendNow(bldr.getEvent());
    }

    @Override
    public void run() {
        try {
            this.doNodeScan();
        }
        catch (InterruptedException e) {
            this.log().warn((Object)"The node scan was interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            this.log().warn((Object)String.format("An error occurred while scanning node (%s/%s)", this.m_foreignSource, this.m_foreignId), (Throwable)e);
        }
    }

    ScheduledFuture<?> schedule(ScheduledExecutorService executor, NodeScanSchedule schedule) {
        ScheduledFuture<?> future = executor.scheduleWithFixedDelay(this, schedule.getInitialDelay().getMillis(), schedule.getScanInterval().getMillis(), TimeUnit.MILLISECONDS);
        return future;
    }

    private void doNodeScan() throws InterruptedException, ExecutionException {
        this.log().info((Object)String.format("Scanning node (%s/%s)", this.m_foreignSource, this.m_foreignId));
        LifeCycleInstance doNodeScan = this.m_lifeCycleRepository.createLifeCycleInstance("nodeScan", this.m_providers.toArray());
        doNodeScan.setAttribute("nodeScan", this);
        doNodeScan.trigger();
        doNodeScan.waitFor();
        this.log().debug((Object)String.format("Finished scanning node (%s/%s)", this.m_foreignSource, this.m_foreignId));
    }

    public void doLoadNode(Phase loadNode) {
        this.m_node = this.m_provisionService.getRequisitionedNode(this.getForeignSource(), this.getForeignId());
        if (this.m_node == null) {
            this.abort(String.format("Unable to get requisitioned node (%s/%s): aborted", this.m_foreignSource, this.m_foreignId));
        }
    }

    public void doAgentScan(Phase detectAgents, InetAddress agentAddress, String agentType) {
        detectAgents.createNestedLifeCycle("agentScan").setAttribute("agentScan", this.createAgentScan(agentAddress, agentType)).setAttribute("agentType", agentType).setAttribute("node", this.getNode()).setAttribute("foreignSource", this.getForeignSource()).setAttribute("foreignId", this.getForeignId()).setAttribute("primaryAddress", agentAddress).trigger();
    }

    public void doNoAgentScan(Phase detectAgents) {
        detectAgents.createNestedLifeCycle("noAgent").setAttribute("noAgentScan", this.createNoAgentScan()).trigger();
    }

    private BaseAgentScan createAgentScan(InetAddress agentAddress, String agentType) {
        return new AgentScan(this.m_nodeId, this.m_node, agentAddress, agentType);
    }

    private BaseAgentScan createNoAgentScan() {
        return new NoAgentScan(this.m_nodeId, this.m_node);
    }

    private Category log() {
        return ThreadCategory.getInstance(NodeScan.class);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("foreign source", (Object)this.m_foreignSource).append("foreign id", (Object)this.m_foreignId).append("node id", (Object)this.m_nodeId).append("aborted", this.m_aborted).append("providers", this.m_providers).append("provision service", (Object)this.m_provisionService).append("lifecycle repository", (Object)this.m_lifeCycleRepository).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.m_foreignSource).append((Object)this.m_foreignId).append((Object)this.m_nodeId).append(this.m_aborted).append(this.m_providers).append((Object)this.m_provisionService).append((Object)this.m_lifeCycleRepository).toHashCode();
    }

    public class IpInterfaceScan {
        private InetAddress m_address;
        private Integer m_nodeId;

        public IpInterfaceScan(Integer nodeId, InetAddress address) {
            this.m_nodeId = nodeId;
            this.m_address = address;
        }

        public String getForeignSource() {
            return NodeScan.this.m_foreignSource;
        }

        public Integer getNodeId() {
            return this.m_nodeId;
        }

        public InetAddress getAddress() {
            return this.m_address;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("address", (Object)this.m_address).append("foreign source", (Object)NodeScan.this.m_foreignSource).append("node ID", (Object)this.m_nodeId).toString();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.m_address).append((Object)NodeScan.this.m_foreignSource).append((Object)this.m_nodeId).toHashCode();
        }
    }

    public class BaseAgentScan {
        private Date m_scanStamp;
        private OnmsNode m_node;
        private Integer m_nodeId;

        private BaseAgentScan(Integer nodeId, OnmsNode node) {
            this.m_nodeId = nodeId;
            this.m_node = node;
        }

        public void setScanStamp(Date scanStamp) {
            this.m_scanStamp = scanStamp;
        }

        public Date getScanStamp() {
            return this.m_scanStamp;
        }

        public OnmsNode getNode() {
            return this.m_node;
        }

        public Integer getNodeId() {
            return this.m_nodeId;
        }

        public boolean isAborted() {
            return NodeScan.this.isAborted();
        }

        public void abort(String reason) {
            NodeScan.this.abort(reason);
        }

        public String getForeignSource() {
            return this.m_node.getForeignSource();
        }

        public String getForeignId() {
            return this.m_node.getForeignId();
        }

        public void doUpdateIPInterface(Phase currentPhase, OnmsIpInterface iface) {
            NodeScan.this.m_provisionService.updateIpInterfaceAttributes(this.getNodeId(), iface);
        }

        public void triggerIPInterfaceScan(Phase currentPhase, InetAddress ipAddress) {
            currentPhase.createNestedLifeCycle("ipInterfaceScan").setAttribute("ipInterfaceScan", this.createIpInterfaceScan(this.getNodeId(), ipAddress)).setAttribute("foreignSource", this.getForeignSource()).setAttribute("nodeId", this.getNodeId()).setAttribute("ipAddress", ipAddress).trigger();
        }

        private IpInterfaceScan createIpInterfaceScan(Integer nodeId, InetAddress ipAddress) {
            return new IpInterfaceScan(nodeId, ipAddress);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("foreign source", (Object)this.getForeignSource()).append("foreign id", (Object)this.getForeignId()).append("node id", (Object)this.m_nodeId).append("scan stamp", (Object)this.m_scanStamp).toString();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.m_nodeId).append((Object)this.m_scanStamp).toHashCode();
        }
    }

    public class NoAgentScan
    extends BaseAgentScan {
        private NoAgentScan(Integer nodeId, OnmsNode node) {
            super(nodeId, node);
        }
    }

    public class AgentScan
    extends BaseAgentScan {
        private InetAddress m_agentAddress;
        private String m_agentType;

        public AgentScan(Integer nodeId, OnmsNode node, InetAddress agentAddress, String agentType) {
            super(nodeId, node);
            this.m_agentAddress = agentAddress;
            this.m_agentType = agentType;
        }

        public InetAddress getAgentAddress() {
            return this.m_agentAddress;
        }

        public String getAgentType() {
            return this.m_agentType;
        }

        public void doPersistNodeInfo() {
            if (this.isAborted()) {
                return;
            }
            NodeScan.this.m_provisionService.updateNodeAttributes(this.getNode());
        }

        public void setNode(OnmsNode node) {
            NodeScan.this.m_node = node;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("address", (Object)this.m_agentAddress).append("type", (Object)this.m_agentType).toString();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.m_agentAddress).append((Object)this.m_agentType).toHashCode();
        }
    }
}

