/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;

public class IPInterfaceTableTracker
extends TableTracker {
    public static final SnmpObjId IP_ADDR_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.4.20.1");
    public static final SnmpObjId IP_ADDR_ENT_ADDR = SnmpObjId.get((SnmpObjId)IP_ADDR_TABLE_ENTRY, (String)"1");
    public static final SnmpObjId IP_ADDR_IF_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDR_TABLE_ENTRY, (String)"2");
    public static final SnmpObjId IP_ADDR_ENT_NETMASK = SnmpObjId.get((SnmpObjId)IP_ADDR_TABLE_ENTRY, (String)"3");
    public static final SnmpObjId IP_ADDR_ENT_BCASTADDR = SnmpObjId.get((SnmpObjId)IP_ADDR_TABLE_ENTRY, (String)"4");
    private static SnmpObjId[] s_tableColumns = new SnmpObjId[]{IP_ADDR_ENT_ADDR, IP_ADDR_IF_INDEX, IP_ADDR_ENT_NETMASK, IP_ADDR_ENT_BCASTADDR};

    public IPInterfaceTableTracker() {
        super(s_tableColumns);
    }

    public IPInterfaceTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_tableColumns);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new IPInterfaceRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processIPInterfaceRow((IPInterfaceRow)row);
    }

    public void processIPInterfaceRow(IPInterfaceRow row) {
    }

    class IPInterfaceRow
    extends SnmpRowResult {
        public IPInterfaceRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public Integer getIfIndex() {
            SnmpValue value = this.getValue(IP_ADDR_IF_INDEX);
            return value == null ? null : Integer.valueOf(value.toInt());
        }

        public String getIpAddress() {
            SnmpValue value = this.getValue(IP_ADDR_ENT_ADDR);
            return value == null ? null : value.toInetAddress().getHostAddress();
        }

        private String getNetMask() {
            SnmpValue value = this.getValue(IP_ADDR_ENT_NETMASK);
            return value == null ? null : value.toInetAddress().getHostAddress();
        }

        public OnmsIpInterface createInterfaceFromRow() {
            String ipAddr = this.getIpAddress();
            String netMask = this.getNetMask();
            Integer ifIndex = this.getIfIndex();
            OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(ipAddr, ifIndex, null);
            snmpIface.setNetMask(netMask);
            snmpIface.setCollectionEnabled(true);
            OnmsIpInterface iface = new OnmsIpInterface(ipAddr, null);
            iface.setSnmpInterface(snmpIface);
            iface.setIfIndex(ifIndex);
            try {
                iface.setIpHostName(InetAddress.getByName(ipAddr).getHostName());
            }
            catch (UnknownHostException e) {
                iface.setIpHostName(ipAddr);
            }
            return iface;
        }
    }
}

