/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PathElement;
import org.opennms.netmgt.model.events.AddEventVisitor;
import org.opennms.netmgt.model.events.DeleteEventVisitor;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.UpdateEventVisitor;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.NodeScanSchedule;
import org.opennms.netmgt.provision.service.PluginRegistry;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DefaultProvisionService
implements ProvisionService {
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    @Qualifier(value="transactionAware")
    private EventForwarder m_eventForwarder;
    @Autowired
    @Qualifier(value="fused")
    private ForeignSourceRepository m_foreignSourceRepository;
    @Autowired
    private PluginRegistry m_pluginRegistry;
    private final ThreadLocal<HashMap<String, OnmsServiceType>> m_typeCache = new ThreadLocal();
    private final ThreadLocal<HashMap<String, OnmsCategory>> m_categoryCache = new ThreadLocal();

    @Override
    @Transactional
    public void insertNode(OnmsNode node) {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.m_distPollerDao.get((Serializable)((Object)"localhost"));
        node.setDistPoller(distPoller);
        this.m_nodeDao.save((Object)node);
        AddEventVisitor eventAccumlator = new AddEventVisitor(this.m_eventForwarder);
        node.visit((EntityVisitor)eventAccumlator);
    }

    @Override
    @Transactional
    public void updateNode(OnmsNode node) {
        OnmsNode dbNode = this.m_nodeDao.getHierarchy(node.getId());
        dbNode.mergeNode(node, this.m_eventForwarder, false);
        this.m_nodeDao.update((Object)dbNode);
        UpdateEventVisitor eventAccumlator = new UpdateEventVisitor(this.m_eventForwarder);
        node.visit((EntityVisitor)eventAccumlator);
    }

    @Override
    @Transactional
    public void deleteNode(Integer nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeId);
        if (node != null) {
            this.m_nodeDao.delete((Object)node);
            node.visit((EntityVisitor)new DeleteEventVisitor(this.m_eventForwarder));
        }
    }

    private void assertNotNull(Object o, String format, Object ... args) {
        if (o == null) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    @Override
    public OnmsIpInterface updateIpInterfaceAttributes(Integer nodeId, OnmsIpInterface scannedIface) {
        OnmsIpInterface dbIface;
        if (scannedIface.getSnmpInterface() != null) {
            scannedIface.setSnmpInterface(this.updateSnmpInterfaceAttributes(nodeId, scannedIface.getSnmpInterface()));
        }
        if ((dbIface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, scannedIface.getIpAddress())) != null) {
            dbIface.mergeInterfaceAttributes(scannedIface);
            this.info("Updating IpInterface %s", dbIface);
            this.m_ipInterfaceDao.update((Object)dbIface);
            return dbIface;
        }
        OnmsNode dbNode = (OnmsNode)this.m_nodeDao.load((Serializable)nodeId);
        this.assertNotNull(dbNode, "no node found with nodeId %d", nodeId);
        scannedIface.setNode(dbNode);
        this.saveOrUpdate(scannedIface);
        AddEventVisitor visitor = new AddEventVisitor(this.m_eventForwarder);
        scannedIface.visit((EntityVisitor)visitor);
        return scannedIface;
    }

    @Override
    public OnmsSnmpInterface updateSnmpInterfaceAttributes(Integer nodeId, OnmsSnmpInterface snmpInterface) {
        OnmsSnmpInterface dbSnmpIface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(nodeId, snmpInterface.getIfIndex());
        if (dbSnmpIface != null) {
            dbSnmpIface.mergeSnmpInterfaceAttributes(snmpInterface);
            this.info("Updating SnmpInterface %s", dbSnmpIface);
            this.m_snmpInterfaceDao.update((Object)dbSnmpIface);
            return dbSnmpIface;
        }
        OnmsNode dbNode = (OnmsNode)this.m_nodeDao.load((Serializable)nodeId);
        this.assertNotNull(dbNode, "no node found with nodeId %d", nodeId);
        snmpInterface.setNode(dbNode);
        this.info("Saving SnmpInterface %s", snmpInterface);
        this.m_snmpInterfaceDao.save((Object)snmpInterface);
        return snmpInterface;
    }

    @Override
    public OnmsMonitoredService addMonitoredService(Integer ipInterfaceId, String svcName) {
        OnmsMonitoredService svc;
        OnmsIpInterface iface = (OnmsIpInterface)this.m_ipInterfaceDao.get((Serializable)ipInterfaceId);
        this.assertNotNull(iface, "could not find interface with id %d", ipInterfaceId);
        OnmsServiceType svcType = this.m_serviceTypeDao.findByName(svcName);
        if (svcType == null) {
            svcType = new OnmsServiceType(svcName);
            this.m_serviceTypeDao.save((Object)svcType);
        }
        if ((svc = iface.getMonitoredServiceByServiceType(svcName)) != null) {
            this.m_monitoredServiceDao.saveOrUpdate((Object)svc);
        } else {
            svc = new OnmsMonitoredService(iface, svcType);
            svc.setStatus("A");
            this.m_ipInterfaceDao.saveOrUpdate((Object)iface);
            AddEventVisitor visitor = new AddEventVisitor(this.m_eventForwarder);
            svc.visit((EntityVisitor)visitor);
        }
        return svc;
    }

    @Override
    public OnmsMonitoredService addMonitoredService(Integer nodeId, String ipAddress, String svcName) {
        OnmsMonitoredService svc;
        OnmsIpInterface iface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddress);
        this.assertNotNull(iface, "could not find interface with nodeid %d and ipAddr %s", nodeId, ipAddress);
        OnmsServiceType svcType = this.m_serviceTypeDao.findByName(svcName);
        if (svcType == null) {
            svcType = new OnmsServiceType(svcName);
            this.m_serviceTypeDao.save((Object)svcType);
        }
        if ((svc = iface.getMonitoredServiceByServiceType(svcName)) != null) {
            this.m_monitoredServiceDao.saveOrUpdate((Object)svc);
        } else {
            svc = new OnmsMonitoredService(iface, svcType);
            svc.setStatus("A");
            this.m_ipInterfaceDao.saveOrUpdate((Object)iface);
            AddEventVisitor visitor = new AddEventVisitor(this.m_eventForwarder);
            svc.visit((EntityVisitor)visitor);
        }
        return svc;
    }

    @Override
    public void clearCache() {
        this.m_nodeDao.clear();
    }

    @Override
    @Transactional
    public OnmsDistPoller createDistPollerIfNecessary(String dpName, String dpAddr) {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.m_distPollerDao.get((Serializable)((Object)dpName));
        if (distPoller == null) {
            distPoller = new OnmsDistPoller(dpName, dpAddr);
            this.m_distPollerDao.save((Object)distPoller);
        }
        return distPoller;
    }

    @Override
    @Transactional
    public OnmsNode getRequisitionedNode(String foreignSource, String foreignId) throws ForeignSourceRepositoryException {
        OnmsNodeRequisition nodeReq = this.m_foreignSourceRepository.getNodeRequisition(foreignSource, foreignId);
        if (nodeReq == null) {
            this.warn("nodeReq for node %s:%s cannot be null!", foreignSource, foreignId);
            return null;
        }
        OnmsNode node = nodeReq.constructOnmsNodeFromRequisition();
        HashSet<OnmsCategory> dbCategories = new HashSet<OnmsCategory>();
        for (OnmsCategory category : node.getCategories()) {
            OnmsCategory dbCategory = this.createCategoryIfNecessary(category.getName());
            dbCategories.add(dbCategory);
        }
        node.setCategories(dbCategories);
        node.visit((EntityVisitor)new ServiceTypeFulfiller());
        return node;
    }

    @Override
    @Transactional
    public OnmsServiceType createServiceTypeIfNecessary(String serviceName) {
        this.preloadExistingTypes();
        OnmsServiceType type = this.m_typeCache.get().get(serviceName);
        if (type == null) {
            type = this.loadServiceType(serviceName);
            this.m_typeCache.get().put(serviceName, type);
        }
        return type;
    }

    @Override
    @Transactional
    public OnmsCategory createCategoryIfNecessary(String name) {
        this.preloadExistingCategories();
        OnmsCategory category = this.m_categoryCache.get().get(name);
        if (category == null) {
            category = this.loadCategory(name);
            this.m_categoryCache.get().put(category.getName(), category);
        }
        return category;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Integer> getForeignIdToNodeIdMap(String foreignSource) {
        return this.m_nodeDao.getForeignIdToNodeIdMap(foreignSource);
    }

    @Override
    @Transactional
    public void setNodeParentAndDependencies(String foreignSource, String foreignId, String parentForeignId, String parentNodeLabel) {
        OnmsNode node = this.findNodebyForeignId(foreignSource, foreignId);
        if (node == null) {
            return;
        }
        OnmsNode parent = this.findParent(foreignSource, parentForeignId, parentNodeLabel);
        this.setParent(node, parent);
        this.setPathDependency(node, parent);
        this.m_nodeDao.update((Object)node);
    }

    private void preloadExistingTypes() {
        if (this.m_typeCache.get() == null) {
            this.m_typeCache.set(this.loadServiceTypeMap());
        }
    }

    private HashMap<String, OnmsServiceType> loadServiceTypeMap() {
        HashMap<String, OnmsServiceType> serviceTypeMap = new HashMap<String, OnmsServiceType>();
        for (OnmsServiceType svcType : this.m_serviceTypeDao.findAll()) {
            serviceTypeMap.put(svcType.getName(), svcType);
        }
        return serviceTypeMap;
    }

    @Transactional
    private OnmsServiceType loadServiceType(String serviceName) {
        OnmsServiceType type = this.m_serviceTypeDao.findByName(serviceName);
        if (type == null) {
            type = new OnmsServiceType(serviceName);
            this.m_serviceTypeDao.save((Object)type);
        }
        return type;
    }

    private void preloadExistingCategories() {
        if (this.m_categoryCache.get() == null) {
            this.m_categoryCache.set(this.loadCategoryMap());
        }
    }

    @Transactional(readOnly=true)
    private HashMap<String, OnmsCategory> loadCategoryMap() {
        HashMap<String, OnmsCategory> categoryMap = new HashMap<String, OnmsCategory>();
        for (OnmsCategory category : this.m_categoryDao.findAll()) {
            categoryMap.put(category.getName(), category);
        }
        return categoryMap;
    }

    @Transactional
    private OnmsCategory loadCategory(String name) {
        OnmsCategory category = this.m_categoryDao.findByName(name);
        if (category == null) {
            category = new OnmsCategory(name);
            this.m_categoryDao.save((Object)category);
        }
        return category;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private OnmsNode findNodebyNodeLabel(String label) {
        Collection nodes = this.m_nodeDao.findByLabel(label);
        if (nodes.size() == 1) {
            return (OnmsNode)nodes.iterator().next();
        }
        this.error("Unable to locate a unique node using label %s: %d nodes found.  Ignoring relationship.", label, nodes.size());
        return null;
    }

    @Transactional(readOnly=true)
    private OnmsNode findNodebyForeignId(String foreignSource, String foreignId) {
        return this.m_nodeDao.findByForeignId(foreignSource, foreignId);
    }

    @Transactional(readOnly=true)
    private OnmsNode findParent(String foreignSource, String parentForeignId, String parentNodeLabel) {
        if (parentForeignId != null) {
            return this.findNodebyForeignId(foreignSource, parentForeignId);
        }
        if (parentNodeLabel != null) {
            return this.findNodebyNodeLabel(parentNodeLabel);
        }
        return null;
    }

    private void setPathDependency(OnmsNode node, OnmsNode parent) {
        if (node == null) {
            return;
        }
        OnmsIpInterface critIface = null;
        if (parent != null) {
            critIface = parent.getCriticalInterface();
        }
        this.info("Setting criticalInterface of node: %s to: %s", node, critIface);
        node.setPathElement(critIface == null ? null : new PathElement(critIface.getIpAddress(), "ICMP"));
    }

    private void setParent(OnmsNode node, OnmsNode parent) {
        if (node == null) {
            return;
        }
        this.info("Setting parent of node: %s to: %s", node, parent);
        node.setParent(parent);
        this.m_nodeDao.update((Object)node);
    }

    @Override
    public NodeScanSchedule getScheduleForNode(int nodeId, boolean force) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        return this.createScheduleForNode(node, force);
    }

    @Override
    public List<NodeScanSchedule> getScheduleForNodes() {
        Assert.notNull((Object)this.m_nodeDao, (String)"Node DAO is null and is not supposed to be");
        List nodes = this.m_nodeDao.findAllProvisionedNodes();
        ArrayList<NodeScanSchedule> scheduledNodes = new ArrayList<NodeScanSchedule>();
        for (OnmsNode node : nodes) {
            NodeScanSchedule nodeScanSchedule = this.createScheduleForNode(node, false);
            if (nodeScanSchedule == null) continue;
            scheduledNodes.add(nodeScanSchedule);
        }
        return scheduledNodes;
    }

    private NodeScanSchedule createScheduleForNode(OnmsNode node, boolean force) {
        DateTime now;
        DateTime nextPoll;
        Assert.notNull((Object)node, (String)"Node may not be null");
        if (node.getForeignSource() == null) {
            this.info("Not scheduling node %s to be scanned since it has a null foreignSource", node);
            return null;
        }
        ForeignSource fs = null;
        try {
            fs = this.m_foreignSourceRepository.getForeignSource(node.getForeignSource());
        }
        catch (ForeignSourceRepositoryException e) {
            this.log().warn((Object)String.format("unable to get foreign source '%s' from repository", node.getForeignSource()), (Throwable)e);
            return null;
        }
        Duration scanInterval = fs.getScanInterval();
        Duration initialDelay = Duration.ZERO;
        if (node.getLastCapsdPoll() != null && !force && (nextPoll = new DateTime(node.getLastCapsdPoll().getTime()).plus((ReadableDuration)scanInterval)).isAfter((ReadableInstant)(now = new DateTime()))) {
            initialDelay = new Duration((ReadableInstant)now, (ReadableInstant)nextPoll);
        }
        NodeScanSchedule nSchedule = new NodeScanSchedule(node.getId(), node.getForeignSource(), node.getForeignId(), initialDelay, scanInterval);
        return nSchedule;
    }

    @Override
    public void setForeignSourceRepository(ForeignSourceRepository foriengSourceRepository) {
        this.m_foreignSourceRepository = foriengSourceRepository;
    }

    public ForeignSourceRepository getForeignSourceRepository() {
        return this.m_foreignSourceRepository;
    }

    @Override
    public Requisition loadRequisition(Resource resource) {
        Requisition r = this.m_foreignSourceRepository.importResourceRequisition(resource);
        r.updateLastImported();
        this.m_foreignSourceRepository.save(r);
        return r;
    }

    @Override
    public OnmsNode updateNodeAttributes(OnmsNode node) {
        OnmsNode dbNode = node.getId() != null ? (OnmsNode)this.m_nodeDao.get((Serializable)node.getId()) : this.m_nodeDao.findByForeignId(node.getForeignSource(), node.getForeignId());
        if (dbNode == null) {
            OnmsDistPoller dbPoller;
            OnmsDistPoller scannedPoller = node.getDistPoller();
            if (scannedPoller == null) {
                dbPoller = (OnmsDistPoller)this.m_distPollerDao.get((Serializable)((Object)"locahost"));
            } else {
                dbPoller = (OnmsDistPoller)this.m_distPollerDao.get((Serializable)((Object)scannedPoller.getName()));
                if (dbPoller == null) {
                    this.m_distPollerDao.save((Object)scannedPoller);
                    dbPoller = scannedPoller;
                }
            }
            node.setDistPoller(dbPoller);
            return this.saveOrUpdate(node);
        }
        dbNode.mergeNodeAttributes(node);
        return this.saveOrUpdate(dbNode);
    }

    private OnmsNode saveOrUpdate(OnmsNode node) {
        HashSet<OnmsCategory> updatedCategories = new HashSet<OnmsCategory>();
        Iterator it = node.getCategories().iterator();
        while (it.hasNext()) {
            OnmsCategory category = (OnmsCategory)it.next();
            if (category.getId() != null) continue;
            it.remove();
            OnmsCategory newCategory = this.createCategoryIfNecessary(category.getName());
            updatedCategories.add(newCategory);
        }
        node.getCategories().addAll(updatedCategories);
        this.m_nodeDao.saveOrUpdate((Object)node);
        return node;
    }

    private OnmsIpInterface saveOrUpdate(OnmsIpInterface iface) {
        iface.visit((EntityVisitor)new ServiceTypeFulfiller());
        this.info("SaveOrUpdating IpInterface %s", iface);
        this.m_ipInterfaceDao.saveOrUpdate((Object)iface);
        return iface;
    }

    @Override
    public List<ServiceDetector> getDetectorsForForeignSource(String foreignSourceName) {
        ForeignSource foreignSource = this.m_foreignSourceRepository.getForeignSource(foreignSourceName);
        this.assertNotNull(foreignSource, "Expected a foreignSource with name %s", foreignSourceName);
        List detectorConfigs = foreignSource.getDetectors();
        if (detectorConfigs == null) {
            return new ArrayList<ServiceDetector>(this.m_pluginRegistry.getAllPlugins(ServiceDetector.class));
        }
        ArrayList<ServiceDetector> detectors = new ArrayList<ServiceDetector>(detectorConfigs.size());
        for (PluginConfig detectorConfig : detectorConfigs) {
            ServiceDetector detector = this.m_pluginRegistry.getPluginInstance(ServiceDetector.class, detectorConfig);
            if (detector == null) {
                this.error("Configured plugin does not exist: %s", detectorConfig);
                continue;
            }
            detector.setServiceName(detectorConfig.getName());
            detector.init();
            detectors.add(detector);
        }
        return detectors;
    }

    @Override
    public List<NodePolicy> getNodePoliciesForForeignSource(String foreignSourceName) {
        return this.getPluginsForForeignSource(NodePolicy.class, foreignSourceName);
    }

    @Override
    public List<IpInterfacePolicy> getIpInterfacePoliciesForForeignSource(String foreignSourceName) {
        return this.getPluginsForForeignSource(IpInterfacePolicy.class, foreignSourceName);
    }

    @Override
    public List<SnmpInterfacePolicy> getSnmpInterfacePoliciesForForeignSource(String foreignSourceName) {
        return this.getPluginsForForeignSource(SnmpInterfacePolicy.class, foreignSourceName);
    }

    public <T> List<T> getPluginsForForeignSource(Class<T> pluginClass, String foreignSourceName) {
        ForeignSource foreignSource = this.m_foreignSourceRepository.getForeignSource(foreignSourceName);
        this.assertNotNull(foreignSource, "Expected a foreignSource with name %s", foreignSourceName);
        List configs = foreignSource.getPolicies();
        if (configs == null) {
            return Collections.emptyList();
        }
        ArrayList<T> plugins = new ArrayList<T>(configs.size());
        for (PluginConfig config : configs) {
            T plugin = this.m_pluginRegistry.getPluginInstance(pluginClass, config);
            if (plugin == null) {
                this.info("Configured plugin is not appropropriate for policy class %s: %s", pluginClass, config);
                continue;
            }
            plugins.add(plugin);
        }
        return plugins;
    }

    @Override
    public void deleteObsoleteInterfaces(Integer nodeId, Date scanStamp) {
        List obsoleteInterfaces = this.m_nodeDao.findObsoleteIpInterfaces(nodeId, scanStamp);
        for (OnmsIpInterface iface : obsoleteInterfaces) {
            iface.visit((EntityVisitor)new DeleteEventVisitor(this.m_eventForwarder));
        }
        this.m_nodeDao.deleteObsoleteInterfaces(nodeId, scanStamp);
    }

    @Override
    public void updateNodeScanStamp(Integer nodeId, Date scanStamp) {
        this.m_nodeDao.updateNodeScanStamp(nodeId, scanStamp);
    }

    private void error(String format, Object ... args) {
        this.log().error((Object)String.format(format, args));
    }

    private void info(String format, Object ... args) {
        this.log().info((Object)String.format(format, args));
    }

    private void warn(String format, Object ... args) {
        this.log().warn((Object)String.format(format, args));
    }

    private void debug(String format, Object ... args) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)String.format(format, args));
        }
    }

    private final class ServiceTypeFulfiller
    extends AbstractEntityVisitor {
        private ServiceTypeFulfiller() {
        }

        public void visitMonitoredService(OnmsMonitoredService monSvc) {
            OnmsServiceType dbType = monSvc.getServiceType();
            if (dbType.getId() == null) {
                dbType = DefaultProvisionService.this.createServiceTypeIfNecessary(dbType.getName());
            }
            monSvc.setServiceType(dbType);
        }
    }
}

