/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.ExtensionManager;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.OnmsPolicy;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.SyncServiceDetector;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.service.PluginRegistry;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginRegistry
implements PluginRegistry,
InitializingBean {
    @Autowired(required=false)
    Set<SyncServiceDetector> m_syncDetectors;
    @Autowired(required=false)
    Set<AsyncServiceDetector> m_asyncDetectors;
    @Autowired(required=false)
    Set<NodePolicy> m_nodePolicies;
    @Autowired(required=false)
    Set<IpInterfacePolicy> m_ipInterfacePolicies;
    @Autowired(required=false)
    Set<SnmpInterfacePolicy> m_snmpInterfacePolicies;
    @Autowired
    ExtensionManager m_extensionManager;
    @Autowired
    private ApplicationContext m_applicationContext;

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_extensionManager, (String)"ExtensionManager must not be null");
        this.addAllExtensions(this.m_asyncDetectors, AsyncServiceDetector.class, ServiceDetector.class);
        this.addAllExtensions(this.m_syncDetectors, SyncServiceDetector.class, ServiceDetector.class);
        this.addAllExtensions(this.m_nodePolicies, NodePolicy.class, OnmsPolicy.class);
        this.addAllExtensions(this.m_ipInterfacePolicies, IpInterfacePolicy.class, OnmsPolicy.class);
        this.addAllExtensions(this.m_snmpInterfacePolicies, SnmpInterfacePolicy.class, OnmsPolicy.class);
    }

    private void debug(String format, Object ... args) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format(format, args));
        }
    }

    private void info(String format, Object ... args) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        if (log.isInfoEnabled()) {
            log.info((Object)String.format(format, args));
        }
    }

    private <T> void addAllExtensions(Collection<T> extensions, Class<?> ... extensionPoints) {
        if (extensions == null || extensions.isEmpty()) {
            this.info("Found NO Extensions for ExtensionPoints %s", Arrays.toString(extensionPoints));
            return;
        }
        for (T extension : extensions) {
            this.info("Register Extension %s for ExtensionPoints %s", extension, Arrays.toString(extensionPoints));
            this.m_extensionManager.registerExtension(extension, (Class[])extensionPoints);
        }
    }

    @Override
    public <T> Collection<T> getAllPlugins(Class<T> pluginClass) {
        return this.beansOfType(pluginClass).values();
    }

    @Override
    public <T> T getPluginInstance(Class<T> pluginClass, PluginConfig pluginConfig) {
        T pluginInstance = this.beanWithNameOfType(pluginConfig.getPluginClass(), pluginClass);
        if (pluginInstance == null) {
            return null;
        }
        HashMap parameters = new HashMap(pluginConfig.getParameterMap());
        BeanWrapperImpl wrapper = new BeanWrapperImpl(pluginInstance);
        wrapper.setPropertyValues(parameters);
        return pluginInstance;
    }

    private <T> Map<String, T> beansOfType(Class<T> pluginClass) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.m_applicationContext, pluginClass, (boolean)true, (boolean)true);
    }

    private <T> T beanWithNameOfType(String beanName, Class<T> pluginClass) {
        Map<String, T> beans = this.beansOfType(pluginClass);
        T bean = beans.get(beanName);
        this.debug("Found bean %s with name %s of type %s", bean, beanName, pluginClass);
        return bean;
    }
}

