/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.mina.core.future.IoFutureListener;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.Callback;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.SnmpAgentConfigFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.DetectorMonitor;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.SyncServiceDetector;
import org.opennms.netmgt.provision.service.IPInterfaceTableTracker;
import org.opennms.netmgt.provision.service.NodeScan;
import org.opennms.netmgt.provision.service.PhysInterfaceTableTracker;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.lifecycle.Phase;
import org.opennms.netmgt.provision.service.lifecycle.annotations.Activity;
import org.opennms.netmgt.provision.service.lifecycle.annotations.ActivityProvider;
import org.opennms.netmgt.provision.service.snmp.SystemGroup;
import org.opennms.netmgt.provision.support.NullDetectorMonitor;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ActivityProvider
public class CoreScanActivities {
    @Autowired
    private ProvisionService m_provisionService;
    @Autowired
    @Qualifier(value="standard")
    private EventForwarder m_eventForwarder;
    @Autowired
    private SnmpAgentConfigFactory m_agentConfigFactory;

    @Activity(lifecycle="nodeScan", phase="loadNode")
    public void loadNode(Phase currentPhase, NodeScan nodeScan) {
        nodeScan.doLoadNode(currentPhase);
    }

    @Activity(lifecycle="nodeScan", phase="detectAgents")
    public void detectAgents(Phase currentPhase, NodeScan nodeScan) {
        boolean foundAgent = false;
        if (!nodeScan.isAborted()) {
            OnmsIpInterface primaryIface = nodeScan.getNode().getPrimaryInterface();
            if (primaryIface != null && primaryIface.getMonitoredServiceByServiceType("SNMP") != null) {
                nodeScan.doAgentScan(currentPhase, primaryIface.getInetAddress(), "SNMP");
                foundAgent = true;
            }
            if (!foundAgent) {
                nodeScan.doNoAgentScan(currentPhase);
            }
        }
    }

    @Activity(lifecycle="nodeScan", phase="scanCompleted")
    public void scanCompleted(Phase currentPhase, NodeScan nodeScan) {
        if (!nodeScan.isAborted()) {
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/provisiond/nodeScanCompleted", "Provisiond");
            bldr.setNodeid(nodeScan.getNodeId().intValue());
            bldr.addParam("foreignSource", nodeScan.getForeignSource());
            bldr.addParam("foreignId", nodeScan.getForeignId());
            this.m_eventForwarder.sendNow(bldr.getEvent());
        }
    }

    @Activity(lifecycle="agentScan", phase="collectNodeInfo")
    public void collectNodeInfo(Phase currentPhase, NodeScan.AgentScan agentScan) throws InterruptedException {
        Date scanStamp = new Date();
        agentScan.setScanStamp(scanStamp);
        InetAddress primaryAddress = agentScan.getAgentAddress();
        SnmpAgentConfig agentConfig = this.m_agentConfigFactory.getAgentConfig(primaryAddress);
        Assert.notNull((Object)this.m_agentConfigFactory, (String)"agentConfigFactory was not injected");
        SystemGroup systemGroup = new SystemGroup(primaryAddress);
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"systemGroup", (CollectionTracker)systemGroup);
        walker.start();
        walker.waitFor();
        if (walker.timedOut()) {
            agentScan.abort("Aborting node scan : Agent timedout while scanning the system table");
        } else if (walker.failed()) {
            agentScan.abort("Aborting node scan : Agent failed while scanning the system table: " + walker.getErrorMessage());
        } else {
            systemGroup.updateSnmpDataForNode(agentScan.getNode());
            List<NodePolicy> nodePolicies = this.m_provisionService.getNodePoliciesForForeignSource(agentScan.getForeignSource());
            OnmsNode node = agentScan.getNode();
            for (NodePolicy policy : nodePolicies) {
                if (node == null) continue;
                node = policy.apply(node);
            }
            if (node == null) {
                agentScan.abort("Aborted scan of node due to configured policy");
            } else {
                agentScan.setNode(node);
            }
        }
    }

    @Activity(lifecycle="agentScan", phase="persistNodeInfo", schedulingHint="write")
    public void persistNodeInfo(Phase currentPhase, NodeScan.AgentScan agentScan) {
        agentScan.doPersistNodeInfo();
    }

    @Activity(lifecycle="agentScan", phase="detectPhysicalInterfaces")
    public void detectPhysicalInterfaces(final Phase currentPhase, final NodeScan.AgentScan agentScan) throws InterruptedException {
        if (agentScan.isAborted()) {
            return;
        }
        SnmpAgentConfig agentConfig = this.m_agentConfigFactory.getAgentConfig(agentScan.getAgentAddress());
        Assert.notNull((Object)this.m_agentConfigFactory, (String)"agentConfigFactory was not injected");
        PhysInterfaceTableTracker physIfTracker = new PhysInterfaceTableTracker(){

            public void processPhysicalInterfaceRow(PhysInterfaceTableTracker.PhysicalInterfaceRow row) {
                System.out.println("Processing row for ifIndex " + row.getIfIndex());
                OnmsSnmpInterface snmpIface = row.createInterfaceFromRow();
                snmpIface.setLastCapsdPoll(agentScan.getScanStamp());
                List<SnmpInterfacePolicy> policies = CoreScanActivities.this.m_provisionService.getSnmpInterfacePoliciesForForeignSource(agentScan.getForeignSource());
                for (SnmpInterfacePolicy policy : policies) {
                    if (snmpIface == null) continue;
                    snmpIface = policy.apply(snmpIface);
                }
                if (snmpIface != null) {
                    final OnmsSnmpInterface snmpIfaceResult = snmpIface;
                    Runnable r = new Runnable(){

                        public void run() {
                            System.out.println("Saving OnmsSnmpInterface " + snmpIfaceResult);
                            CoreScanActivities.this.m_provisionService.updateSnmpInterfaceAttributes(agentScan.getNodeId(), snmpIfaceResult);
                        }
                    };
                    currentPhase.add(r, "write");
                }
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"ifTable/ifXTable", (CollectionTracker)physIfTracker);
        walker.start();
        walker.waitFor();
        if (walker.timedOut()) {
            agentScan.abort("Aborting node scan : Agent timedout while scanning the interfaces table");
        } else if (walker.failed()) {
            agentScan.abort("Aborting node scan : Agent failed while scanning the interfaces table: " + walker.getErrorMessage());
        } else {
            this.debug("Finished phase " + (Object)((Object)currentPhase), new Object[0]);
        }
    }

    @Activity(lifecycle="agentScan", phase="detectIpInterfaces")
    public void detectIpInterfaces(final Phase currentPhase, final NodeScan.AgentScan agentScan) throws InterruptedException {
        if (agentScan.isAborted()) {
            return;
        }
        SnmpAgentConfig agentConfig = this.m_agentConfigFactory.getAgentConfig(agentScan.getAgentAddress());
        Assert.notNull((Object)this.m_agentConfigFactory, (String)"agentConfigFactory was not injected");
        final HashSet<String> provisionedIps = new HashSet<String>();
        for (OnmsIpInterface provisioned : agentScan.getNode().getIpInterfaces()) {
            provisionedIps.add(provisioned.getIpAddress());
        }
        IPInterfaceTableTracker ipIfTracker = new IPInterfaceTableTracker(){

            public void processIPInterfaceRow(IPInterfaceTableTracker.IPInterfaceRow row) {
                System.out.println("Processing row with ipAddr " + row.getIpAddress());
                if (!row.getIpAddress().startsWith("127.0.0")) {
                    provisionedIps.remove(row.getIpAddress());
                    OnmsIpInterface iface = row.createInterfaceFromRow();
                    iface.setIpLastCapsdPoll(agentScan.getScanStamp());
                    iface.setIsManaged("M");
                    List<IpInterfacePolicy> policies = CoreScanActivities.this.m_provisionService.getIpInterfacePoliciesForForeignSource(agentScan.getForeignSource());
                    for (IpInterfacePolicy policy : policies) {
                        if (iface == null) continue;
                        iface = policy.apply(iface);
                    }
                    if (iface != null) {
                        currentPhase.add(CoreScanActivities.this.ipUpdater(currentPhase, agentScan, iface), "write");
                    }
                }
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"ipAddrTable", (CollectionTracker)ipIfTracker);
        walker.start();
        walker.waitFor();
        if (walker.timedOut()) {
            agentScan.abort("Aborting node scan : Agent timedout while scanning the ipAddrTable");
        } else if (walker.failed()) {
            agentScan.abort("Aborting node scan : Agent failed while scanning the ipAddrTable : " + walker.getErrorMessage());
        } else {
            for (String ipAddr : provisionedIps) {
                OnmsIpInterface iface = agentScan.getNode().getIpInterfaceByIpAddress(ipAddr);
                iface.setIpLastCapsdPoll(agentScan.getScanStamp());
                iface.setIsManaged("M");
                currentPhase.add(this.ipUpdater(currentPhase, agentScan, iface), "write");
            }
            this.debug("Finished phase " + (Object)((Object)currentPhase), new Object[0]);
        }
    }

    @Activity(lifecycle="agentScan", phase="deleteObsoleteResources", schedulingHint="write")
    public void deleteObsoleteResources(Phase currentPhase, NodeScan.AgentScan agentScan) {
        if (agentScan.isAborted()) {
            return;
        }
        this.m_provisionService.updateNodeScanStamp(agentScan.getNodeId(), agentScan.getScanStamp());
        this.m_provisionService.deleteObsoleteInterfaces(agentScan.getNodeId(), agentScan.getScanStamp());
        this.debug("Finished phase " + (Object)((Object)currentPhase), new Object[0]);
    }

    @Activity(lifecycle="agentScan", phase="agentScanCompleted", schedulingHint="write")
    public void agentScanCompleted(Phase currentPhase, NodeScan.AgentScan agentScan) {
        if (!agentScan.isAborted()) {
            EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface", "Provisiond");
            bldr.setNodeid(agentScan.getNodeId().intValue());
            bldr.setInterface(agentScan.getAgentAddress().getHostAddress());
            this.m_eventForwarder.sendNow(bldr.getEvent());
        }
    }

    @Activity(lifecycle="noAgent", phase="stampProvisionedInterfaces", schedulingHint="write")
    public void stampProvisionedInterfaces(Phase currentPhase, NodeScan.NoAgentScan scan) {
        if (scan.isAborted()) {
            return;
        }
        scan.setScanStamp(new Date());
        for (OnmsIpInterface iface : scan.getNode().getIpInterfaces()) {
            iface.setIpLastCapsdPoll(scan.getScanStamp());
            currentPhase.add(this.ipUpdater(currentPhase, scan, iface), "write");
        }
    }

    @Activity(lifecycle="noAgent", phase="deleteUnprovisionedInterfaces", schedulingHint="write")
    public void deleteObsoleteResources(Phase currentPhase, NodeScan.NoAgentScan scan) {
        this.m_provisionService.updateNodeScanStamp(scan.getNodeId(), scan.getScanStamp());
        this.m_provisionService.deleteObsoleteInterfaces(scan.getNodeId(), scan.getScanStamp());
        this.debug("Finished phase " + (Object)((Object)currentPhase), new Object[0]);
    }

    @Activity(lifecycle="ipInterfaceScan", phase="detectServices")
    public void detectServices(Phase currentPhase, NodeScan.IpInterfaceScan ifaceScan) throws InterruptedException {
        List<ServiceDetector> detectors = this.m_provisionService.getDetectorsForForeignSource(ifaceScan.getForeignSource());
        Integer nodeId = ifaceScan.getNodeId();
        InetAddress ipAddress = ifaceScan.getAddress();
        this.debug("detectServices for %d : %s: found %d detectors", nodeId, ipAddress.getHostAddress(), detectors.size());
        for (ServiceDetector detector : detectors) {
            this.addServiceDetectorTask(currentPhase, detector, nodeId, ipAddress);
        }
    }

    private void addServiceDetectorTask(Phase currentPhase, ServiceDetector detector, Integer nodeId, InetAddress ipAddress) {
        if (detector instanceof SyncServiceDetector) {
            this.addSyncServiceDetectorTask(currentPhase, nodeId, ipAddress, (SyncServiceDetector)detector);
        } else {
            this.addAsyncServiceDetectorTask(currentPhase, nodeId, ipAddress, (AsyncServiceDetector)detector);
        }
    }

    private void addAsyncServiceDetectorTask(Phase currentPhase, Integer nodeId, InetAddress ipAddress, AsyncServiceDetector detector) {
        currentPhase.add(this.runDetector(ipAddress, detector), this.persistService(nodeId, ipAddress, (ServiceDetector)detector));
    }

    private void addSyncServiceDetectorTask(Phase currentPhase, Integer nodeId, InetAddress ipAddress, SyncServiceDetector detector) {
        currentPhase.add(this.runDetector(ipAddress, detector, this.persistService(nodeId, ipAddress, (ServiceDetector)detector)));
    }

    private Callback<Boolean> persistService(final Integer nodeId, final InetAddress ipAddress, final ServiceDetector detector) {
        return new Callback<Boolean>(){

            public void complete(Boolean serviceDetected) {
                CoreScanActivities.this.info("Attempted to detect service %s on address %s: %s", new Object[]{detector.getServiceName(), ipAddress.getHostAddress(), serviceDetected});
                if (serviceDetected.booleanValue()) {
                    CoreScanActivities.this.m_provisionService.addMonitoredService(nodeId, ipAddress.getHostAddress(), detector.getServiceName());
                }
            }

            public void handleException(Throwable t) {
                CoreScanActivities.this.info(t, "Exception occurred trying to detect service %s on address %s", new Object[]{detector.getServiceName(), ipAddress.getHostAddress()});
            }
        };
    }

    private Async<Boolean> runDetector(InetAddress ipAddress, AsyncServiceDetector detector) {
        return new AsyncDetectorRunner(ipAddress, detector);
    }

    private Runnable runDetector(final InetAddress ipAddress, final SyncServiceDetector detector, final Callback<Boolean> cb) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    CoreScanActivities.this.info("Attemping to detect service %s on address %s", new Object[]{detector.getServiceName(), ipAddress.getHostAddress()});
                    cb.complete((Object)detector.isServiceDetected(ipAddress, (DetectorMonitor)new NullDetectorMonitor()));
                }
                catch (Throwable t) {
                    cb.handleException(t);
                }
                finally {
                    detector.dispose();
                }
            }

            public String toString() {
                return String.format("Run detector %s on address %s", detector.getServiceName(), ipAddress.getHostAddress());
            }
        };
    }

    private Runnable ipUpdater(final Phase currentPhase, final NodeScan.BaseAgentScan agentScan, final OnmsIpInterface iface) {
        Runnable r = new Runnable(){

            public void run() {
                agentScan.doUpdateIPInterface(currentPhase, iface);
                if (iface.isManaged()) {
                    agentScan.triggerIPInterfaceScan(currentPhase, iface.getInetAddress());
                }
            }
        };
        return r;
    }

    private void error(Throwable t, String format, Object ... args) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        log.error((Object)String.format(format, args), t);
    }

    private void debug(String format, Object ... args) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format(format, args));
        }
    }

    private void info(Throwable t, String format, Object ... args) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        if (log.isInfoEnabled()) {
            log.info((Object)String.format(format, args), t);
        }
    }

    private void info(String format, Object ... args) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        if (log.isInfoEnabled()) {
            log.info((Object)String.format(format, args));
        }
    }

    private void error(String format, Object ... args) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        log.error((Object)String.format(format, args));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncDetectorRunner
    implements Async<Boolean> {
        private final AsyncServiceDetector m_detector;
        private final InetAddress m_ipAddress;

        public AsyncDetectorRunner(InetAddress address, AsyncServiceDetector detector) {
            this.m_detector = detector;
            this.m_ipAddress = address;
        }

        public void submit(Callback<Boolean> cb) {
            try {
                CoreScanActivities.this.info("Attemping to detect service %s on address %s", new Object[]{this.m_detector.getServiceName(), this.m_ipAddress.getHostAddress()});
                DetectFuture future = this.m_detector.isServiceDetected(this.m_ipAddress, (DetectorMonitor)new NullDetectorMonitor());
                future.addListener(this.listener(cb));
            }
            catch (Throwable e) {
                cb.handleException(e);
            }
        }

        public String toString() {
            return String.format("Run detector %s on address %s", this.m_detector.getServiceName(), this.m_ipAddress.getHostAddress());
        }

        private IoFutureListener<DetectFuture> listener(final Callback<Boolean> cb) {
            return new IoFutureListener<DetectFuture>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(DetectFuture future) {
                    try {
                        if (future.getException() != null) {
                            cb.handleException(future.getException());
                        } else {
                            cb.complete((Object)future.isServiceDetected());
                        }
                    }
                    finally {
                        AsyncDetectorRunner.this.m_detector.dispose();
                    }
                }
            };
        }
    }
}

