/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.persist.AbstractRequisitionVisitor;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.ModelImportException;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleInstance;
import org.opennms.netmgt.provision.service.lifecycle.Phase;
import org.opennms.netmgt.provision.service.lifecycle.annotations.Activity;
import org.opennms.netmgt.provision.service.lifecycle.annotations.ActivityProvider;
import org.opennms.netmgt.provision.service.operations.ImportOperation;
import org.opennms.netmgt.provision.service.operations.ImportOperationsManager;
import org.springframework.core.io.Resource;

@ActivityProvider
public class CoreImportActivities {
    ProvisionService m_provisionService;

    public CoreImportActivities(ProvisionService provisionService) {
        this.m_provisionService = provisionService;
    }

    @Activity(lifecycle="import", phase="validate", schedulingHint="import")
    public Requisition loadSpecFile(Resource resource) throws ModelImportException, IOException {
        this.info("Loading requisition from resource %s", resource);
        Requisition specFile = this.m_provisionService.loadRequisition(resource);
        this.debug("Finished loading requisition.", new Object[0]);
        return specFile;
    }

    @Activity(lifecycle="import", phase="audit", schedulingHint="import")
    public ImportOperationsManager auditNodes(Requisition specFile) {
        this.info("Auditing nodes for requisition %s", specFile);
        this.m_provisionService.createDistPollerIfNecessary("localhost", "127.0.0.1");
        String foreignSource = specFile.getForeignSource();
        Map<String, Integer> foreignIdsToNodes = this.m_provisionService.getForeignIdToNodeIdMap(foreignSource);
        ImportOperationsManager opsMgr = new ImportOperationsManager(foreignIdsToNodes, this.m_provisionService);
        opsMgr.setForeignSource(foreignSource);
        opsMgr.auditNodes(specFile);
        this.debug("Finished auditing nodes.", new Object[0]);
        return opsMgr;
    }

    @Activity(lifecycle="import", phase="scan", schedulingHint="import")
    public void scanNodes(Phase currentPhase, ImportOperationsManager opsMgr) {
        this.info("Scheduling nodes for phase %s", new Object[]{currentPhase});
        Collection<ImportOperation> operations = opsMgr.getOperations();
        for (ImportOperation op : operations) {
            LifeCycleInstance nodeScan = currentPhase.createNestedLifeCycle("nodeImport");
            this.debug("Created lifecycle %s for operation %s", nodeScan, op);
            nodeScan.setAttribute("operation", op);
            nodeScan.trigger();
        }
    }

    @Activity(lifecycle="nodeImport", phase="scan", schedulingHint="import")
    public void scanNode(ImportOperation operation) {
        this.info("Running scan phase of %s", operation);
        operation.scan();
        System.out.println("Finished Running scan phase of " + operation);
    }

    @Activity(lifecycle="nodeImport", phase="persist", schedulingHint="import")
    public void persistNode(ImportOperation operation) {
        System.out.println("Running persist phase of " + operation);
        operation.persist();
        System.out.println("Finished Running persist phase of " + operation);
    }

    @Activity(lifecycle="import", phase="relate", schedulingHint="import")
    public void relateNodes(final Phase currentPhase, final Requisition requisition) {
        System.out.println("Running relate phase");
        AbstractRequisitionVisitor visitor = new AbstractRequisitionVisitor(){

            public void visitNode(OnmsNodeRequisition nodeReq) {
                System.out.println("Scheduling relate of node " + nodeReq);
                currentPhase.add(CoreImportActivities.this.parentSetter(nodeReq, requisition.getForeignSource()));
            }
        };
        requisition.visit((RequisitionVisitor)visitor);
        System.out.println("Finished Running relate phase");
    }

    private Runnable parentSetter(final OnmsNodeRequisition nodeReq, final String foreignSource) {
        return new Runnable(){

            public void run() {
                CoreImportActivities.this.m_provisionService.setNodeParentAndDependencies(foreignSource, nodeReq.getForeignId(), nodeReq.getParentForeignId(), nodeReq.getParentNodeLabel());
                CoreImportActivities.this.m_provisionService.clearCache();
            }

            public String toString() {
                return "set parent for node " + nodeReq.getNodeLabel();
            }
        };
    }

    protected void info(String format, Object ... args) {
        this.log().info((Object)String.format(format, args));
    }

    protected void debug(String format, Object ... args) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)String.format(format, args));
        }
    }

    protected Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

