/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.operations;

import javax.xml.bind.ValidationException;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.persist.requisition.Requisition;

public class RequisitionImport {
    private Requisition m_requisition;
    private Throwable m_throwable;

    public Requisition getRequisition() {
        return this.m_requisition;
    }

    public void setRequisition(Requisition requisition) {
        this.m_requisition = requisition;
        try {
            requisition.validate();
        }
        catch (ValidationException e) {
            if (this.m_throwable == null) {
                this.m_throwable = e;
            }
            LogUtils.debugf((Object)this, (Throwable)e, (String)"Requisition %s did not validate, but we'll ignore the exception because we've previously aborted with: %s", (Object[])new Object[]{requisition, this.m_throwable});
        }
    }

    public Throwable getError() {
        return this.m_throwable;
    }

    public void abort(Throwable t) {
        if (this.m_throwable == null) {
            this.m_throwable = t;
        } else {
            LogUtils.warnf((Object)this, (Throwable)t, (String)"Requisition %s has already been aborted, but we received another abort message.  Ignoring.", (Object[])new Object[]{this.m_requisition});
        }
    }

    public boolean isAborted() {
        return this.m_throwable != null;
    }
}

